/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.batches;

import com.badlogic.gdx.a.d;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$FloatChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader$AlignMode;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader$Config;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData$SaveData;
import com.badlogic.gdx.graphics.g3d.particles.batches.BillboardParticleBatch$Config;
import com.badlogic.gdx.graphics.g3d.particles.batches.BufferedParticleBatch;
import com.badlogic.gdx.graphics.g3d.particles.batches.a;
import com.badlogic.gdx.graphics.g3d.particles.renderers.BillboardControllerRenderData;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public class BillboardParticleBatch
extends BufferedParticleBatch {
    protected static final Vector3 TMP_V1 = new Vector3();
    protected static final Vector3 TMP_V2 = new Vector3();
    protected static final Vector3 TMP_V3 = new Vector3();
    protected static final Vector3 TMP_V4 = new Vector3();
    protected static final Vector3 TMP_V5 = new Vector3();
    protected static final Vector3 TMP_V6 = new Vector3();
    protected static final Matrix3 TMP_M3 = new Matrix3();
    protected static final int sizeAndRotationUsage = 512;
    protected static final int directionUsage = 1024;
    private static final VertexAttributes GPU_ATTRIBUTES = new VertexAttributes(new VertexAttribute(1, 3, "a_position"), new VertexAttribute(16, 2, "a_texCoord0"), new VertexAttribute(2, 4, "a_color"), new VertexAttribute(512, 4, "a_sizeAndRotation"));
    private static final VertexAttributes CPU_ATTRIBUTES = new VertexAttributes(new VertexAttribute(1, 3, "a_position"), new VertexAttribute(16, 2, "a_texCoord0"), new VertexAttribute(2, 4, "a_color"));
    private static final int GPU_POSITION_OFFSET = (short)(BillboardParticleBatch.GPU_ATTRIBUTES.findByUsage((int)1).offset / 4);
    private static final int GPU_UV_OFFSET = (short)(BillboardParticleBatch.GPU_ATTRIBUTES.findByUsage((int)16).offset / 4);
    private static final int GPU_SIZE_ROTATION_OFFSET = (short)(BillboardParticleBatch.GPU_ATTRIBUTES.findByUsage((int)512).offset / 4);
    private static final int GPU_COLOR_OFFSET = (short)(BillboardParticleBatch.GPU_ATTRIBUTES.findByUsage((int)2).offset / 4);
    private static final int GPU_VERTEX_SIZE = BillboardParticleBatch.GPU_ATTRIBUTES.vertexSize / 4;
    private static final int CPU_POSITION_OFFSET = (short)(BillboardParticleBatch.CPU_ATTRIBUTES.findByUsage((int)1).offset / 4);
    private static final int CPU_UV_OFFSET = (short)(BillboardParticleBatch.CPU_ATTRIBUTES.findByUsage((int)16).offset / 4);
    private static final int CPU_COLOR_OFFSET = (short)(BillboardParticleBatch.CPU_ATTRIBUTES.findByUsage((int)2).offset / 4);
    private static final int CPU_VERTEX_SIZE = BillboardParticleBatch.CPU_ATTRIBUTES.vertexSize / 4;
    private static final int MAX_PARTICLES_PER_MESH = 8191;
    private static final int MAX_VERTICES_PER_MESH = 32764;
    private a renderablePool;
    private Array renderables;
    private float[] vertices;
    private short[] indices;
    private int currentVertexSize = 0;
    private VertexAttributes currentAttributes;
    protected boolean useGPU = false;
    protected ParticleShader$AlignMode mode = ParticleShader$AlignMode.Screen;
    protected Texture texture;
    protected BlendingAttribute blendingAttribute;
    protected DepthTestAttribute depthTestAttribute;
    Shader shader;

    public BillboardParticleBatch(ParticleShader$AlignMode particleShader$AlignMode, boolean bl2, int n2, BlendingAttribute blendingAttribute, DepthTestAttribute depthTestAttribute) {
        super(BillboardControllerRenderData[]::new);
        this.renderables = new Array();
        this.renderablePool = new a(this);
        this.blendingAttribute = blendingAttribute;
        this.depthTestAttribute = depthTestAttribute;
        if (this.blendingAttribute == null) {
            this.blendingAttribute = new BlendingAttribute(1, 771, 1.0f);
        }
        if (this.depthTestAttribute == null) {
            this.depthTestAttribute = new DepthTestAttribute(515, false);
        }
        this.allocIndices();
        this.initRenderData();
        this.ensureCapacity(n2);
        this.setUseGpu(bl2);
        this.setAlignMode(particleShader$AlignMode);
    }

    public BillboardParticleBatch(ParticleShader$AlignMode particleShader$AlignMode, boolean bl2, int n2) {
        this(particleShader$AlignMode, bl2, n2, null, null);
    }

    public BillboardParticleBatch() {
        this(ParticleShader$AlignMode.Screen, false, 100);
    }

    public BillboardParticleBatch(int n2) {
        this(ParticleShader$AlignMode.Screen, false, n2);
    }

    @Override
    public void allocParticlesData(int n2) {
        this.vertices = new float[(this.currentVertexSize << 2) * n2];
        this.allocRenderables(n2);
    }

    protected Renderable allocRenderable() {
        Renderable renderable = new Renderable();
        new Renderable().meshPart.primitiveType = 4;
        renderable.meshPart.offset = 0;
        renderable.material = new Material(this.blendingAttribute, this.depthTestAttribute, TextureAttribute.createDiffuse(this.texture));
        renderable.meshPart.mesh = new Mesh(false, 32764, 49146, this.currentAttributes);
        renderable.meshPart.mesh.setIndices(this.indices);
        renderable.shader = this.shader;
        return renderable;
    }

    private void allocIndices() {
        this.indices = new short[49146];
        int n2 = 0;
        int n3 = 0;
        while (n2 < 49146) {
            this.indices[n2] = (short)n3;
            this.indices[n2 + 1] = (short)(n3 + 1);
            this.indices[n2 + 2] = (short)(n3 + 2);
            this.indices[n2 + 3] = (short)(n3 + 2);
            this.indices[n2 + 4] = (short)(n3 + 3);
            this.indices[n2 + 5] = (short)n3;
            n2 += 6;
            n3 += 4;
        }
    }

    private void allocRenderables(int n2) {
        n2 = MathUtils.ceil(n2 / 8191);
        int n3 = this.renderablePool.getFree();
        if (n3 < n2) {
            n2 -= n3;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.renderablePool.free(this.renderablePool.a());
            }
        }
    }

    protected Shader getShader(Renderable object) {
        object = this.useGPU ? new ParticleShader((Renderable)object, new ParticleShader$Config(this.mode)) : new DefaultShader((Renderable)object);
        object.init();
        return object;
    }

    private void allocShader() {
        Renderable renderable = this.allocRenderable();
        this.shader = renderable.shader = this.getShader(renderable);
        this.renderablePool.free(renderable);
    }

    private void clearRenderablesPool() {
        this.renderablePool.freeAll(this.renderables);
        int n2 = this.renderablePool.getFree();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Renderable)this.renderablePool.obtain()).meshPart.mesh.dispose();
        }
        this.renderables.clear();
    }

    public void setVertexData() {
        if (this.useGPU) {
            this.currentAttributes = GPU_ATTRIBUTES;
            this.currentVertexSize = GPU_VERTEX_SIZE;
            return;
        }
        this.currentAttributes = CPU_ATTRIBUTES;
        this.currentVertexSize = CPU_VERTEX_SIZE;
    }

    private void initRenderData() {
        this.setVertexData();
        this.clearRenderablesPool();
        this.allocShader();
        this.resetCapacity();
    }

    public void setAlignMode(ParticleShader$AlignMode particleShader$AlignMode) {
        if (particleShader$AlignMode != this.mode) {
            this.mode = particleShader$AlignMode;
            if (this.useGPU) {
                this.initRenderData();
                BillboardParticleBatch billboardParticleBatch = this;
                billboardParticleBatch.allocRenderables(billboardParticleBatch.bufferedParticlesCount);
            }
        }
    }

    public ParticleShader$AlignMode getAlignMode() {
        return this.mode;
    }

    public void setUseGpu(boolean bl2) {
        if (this.useGPU != bl2) {
            this.useGPU = bl2;
            this.initRenderData();
            BillboardParticleBatch billboardParticleBatch = this;
            billboardParticleBatch.allocRenderables(billboardParticleBatch.bufferedParticlesCount);
        }
    }

    public boolean isUseGPU() {
        return this.useGPU;
    }

    public void setTexture(Texture texture) {
        this.renderablePool.freeAll(this.renderables);
        this.renderables.clear();
        int n2 = this.renderablePool.getFree();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((TextureAttribute)((Renderable)this.renderablePool.obtain()).material.get((long)TextureAttribute.Diffuse)).textureDescription.texture = texture;
        }
        this.texture = texture;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public BlendingAttribute getBlendingAttribute() {
        return this.blendingAttribute;
    }

    @Override
    public void begin() {
        super.begin();
        this.renderablePool.freeAll(this.renderables);
        this.renderables.clear();
    }

    private static void putVertex(float[] fArray, int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
        fArray[n2 + BillboardParticleBatch.GPU_POSITION_OFFSET] = f2;
        fArray[n2 + BillboardParticleBatch.GPU_POSITION_OFFSET + 1] = f3;
        fArray[n2 + BillboardParticleBatch.GPU_POSITION_OFFSET + 2] = f4;
        fArray[n2 + BillboardParticleBatch.GPU_UV_OFFSET] = f5;
        fArray[n2 + BillboardParticleBatch.GPU_UV_OFFSET + 1] = f6;
        fArray[n2 + BillboardParticleBatch.GPU_SIZE_ROTATION_OFFSET] = f7;
        fArray[n2 + BillboardParticleBatch.GPU_SIZE_ROTATION_OFFSET + 1] = f8;
        fArray[n2 + BillboardParticleBatch.GPU_SIZE_ROTATION_OFFSET + 2] = f9;
        fArray[n2 + BillboardParticleBatch.GPU_SIZE_ROTATION_OFFSET + 3] = f10;
        fArray[n2 + BillboardParticleBatch.GPU_COLOR_OFFSET] = f11;
        fArray[n2 + BillboardParticleBatch.GPU_COLOR_OFFSET + 1] = f12;
        fArray[n2 + BillboardParticleBatch.GPU_COLOR_OFFSET + 2] = f13;
        fArray[n2 + BillboardParticleBatch.GPU_COLOR_OFFSET + 3] = f14;
    }

    private static void putVertex(float[] fArray, int n2, Vector3 vector3, float f2, float f3, float f4, float f5, float f6, float f7) {
        fArray[n2 + BillboardParticleBatch.CPU_POSITION_OFFSET] = vector3.x;
        fArray[n2 + BillboardParticleBatch.CPU_POSITION_OFFSET + 1] = vector3.y;
        fArray[n2 + BillboardParticleBatch.CPU_POSITION_OFFSET + 2] = vector3.z;
        fArray[n2 + BillboardParticleBatch.CPU_UV_OFFSET] = f2;
        fArray[n2 + BillboardParticleBatch.CPU_UV_OFFSET + 1] = f3;
        fArray[n2 + BillboardParticleBatch.CPU_COLOR_OFFSET] = f4;
        fArray[n2 + BillboardParticleBatch.CPU_COLOR_OFFSET + 1] = f5;
        fArray[n2 + BillboardParticleBatch.CPU_COLOR_OFFSET + 2] = f6;
        fArray[n2 + BillboardParticleBatch.CPU_COLOR_OFFSET + 3] = f7;
    }

    private void fillVerticesGPU(int[] nArray) {
        int n2 = 0;
        for (BillboardControllerRenderData billboardControllerRenderData : this.renderData) {
            ParallelArray$FloatChannel parallelArray$FloatChannel = billboardControllerRenderData.scaleChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel2 = billboardControllerRenderData.regionChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel3 = billboardControllerRenderData.positionChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel4 = billboardControllerRenderData.colorChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel5 = billboardControllerRenderData.rotationChannel;
            int n3 = 0;
            int n4 = billboardControllerRenderData.controller.particles.size;
            while (n3 < n4) {
                int n5 = nArray[n2] * this.currentVertexSize << 2;
                float f2 = parallelArray$FloatChannel.data[n3 * parallelArray$FloatChannel.strideSize];
                int n6 = n3 * parallelArray$FloatChannel2.strideSize;
                int n7 = n3 * parallelArray$FloatChannel3.strideSize;
                int n8 = n3 * parallelArray$FloatChannel4.strideSize;
                int n9 = n3 * parallelArray$FloatChannel5.strideSize;
                float f3 = parallelArray$FloatChannel3.data[n7];
                float f4 = parallelArray$FloatChannel3.data[n7 + 1];
                float f5 = parallelArray$FloatChannel3.data[n7 + 2];
                float f6 = parallelArray$FloatChannel2.data[n6];
                float f7 = parallelArray$FloatChannel2.data[n6 + 1];
                float f8 = parallelArray$FloatChannel2.data[n6 + 2];
                float f9 = parallelArray$FloatChannel2.data[n6 + 3];
                float f10 = parallelArray$FloatChannel2.data[n6 + 4] * f2;
                f2 = parallelArray$FloatChannel2.data[n6 + 5] * f2;
                float f11 = parallelArray$FloatChannel4.data[n8];
                float f12 = parallelArray$FloatChannel4.data[n8 + 1];
                float f13 = parallelArray$FloatChannel4.data[n8 + 2];
                float f14 = parallelArray$FloatChannel4.data[n8 + 3];
                float f15 = parallelArray$FloatChannel5.data[n9];
                float f16 = parallelArray$FloatChannel5.data[n9 + 1];
                BillboardParticleBatch.putVertex(this.vertices, n5, f3, f4, f5, f6, f9, -f10, -f2, f15, f16, f11, f12, f13, f14);
                BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, f3, f4, f5, f8, f9, f10, -f2, f15, f16, f11, f12, f13, f14);
                BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, f3, f4, f5, f8, f7, f10, f2, f15, f16, f11, f12, f13, f14);
                BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, f3, f4, f5, f6, f7, -f10, f2, f15, f16, f11, f12, f13, f14);
                ++n3;
                ++n2;
            }
        }
    }

    private void fillVerticesToViewPointCPU(int[] nArray) {
        int n2 = 0;
        for (BillboardControllerRenderData billboardControllerRenderData : this.renderData) {
            ParallelArray$FloatChannel parallelArray$FloatChannel = billboardControllerRenderData.scaleChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel2 = billboardControllerRenderData.regionChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel3 = billboardControllerRenderData.positionChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel4 = billboardControllerRenderData.colorChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel5 = billboardControllerRenderData.rotationChannel;
            int n3 = 0;
            int n4 = billboardControllerRenderData.controller.particles.size;
            while (n3 < n4) {
                int n5 = nArray[n2] * this.currentVertexSize << 2;
                float f2 = parallelArray$FloatChannel.data[n3 * parallelArray$FloatChannel.strideSize];
                int n6 = n3 * parallelArray$FloatChannel2.strideSize;
                int n7 = n3 * parallelArray$FloatChannel3.strideSize;
                int n8 = n3 * parallelArray$FloatChannel4.strideSize;
                int n9 = n3 * parallelArray$FloatChannel5.strideSize;
                float f3 = parallelArray$FloatChannel3.data[n7];
                float f4 = parallelArray$FloatChannel3.data[n7 + 1];
                float f5 = parallelArray$FloatChannel3.data[n7 + 2];
                float f6 = parallelArray$FloatChannel2.data[n6];
                float f7 = parallelArray$FloatChannel2.data[n6 + 1];
                float f8 = parallelArray$FloatChannel2.data[n6 + 2];
                float f9 = parallelArray$FloatChannel2.data[n6 + 3];
                float f10 = parallelArray$FloatChannel2.data[n6 + 4] * f2;
                f2 = parallelArray$FloatChannel2.data[n6 + 5] * f2;
                float f11 = parallelArray$FloatChannel4.data[n8];
                float f12 = parallelArray$FloatChannel4.data[n8 + 1];
                float f13 = parallelArray$FloatChannel4.data[n8 + 2];
                float f14 = parallelArray$FloatChannel4.data[n8 + 3];
                float f15 = parallelArray$FloatChannel5.data[n9];
                float f16 = parallelArray$FloatChannel5.data[n9 + 1];
                Vector3 vector3 = TMP_V3.set(this.camera.position).sub(f3, f4, f5).nor();
                Vector3 vector32 = TMP_V1.set(this.camera.up).crs(vector3).nor();
                Vector3 vector33 = TMP_V2.set(vector3).crs(vector32);
                vector32.scl(f10);
                vector33.scl(f2);
                if (f15 != 1.0f) {
                    TMP_M3.setToRotation(vector3, f15, f16);
                    BillboardParticleBatch.putVertex(this.vertices, n5, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x, -BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y, -BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f3, f4, f5), f6, f9, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x, BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y, BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f3, f4, f5), f8, f9, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x, BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y, BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f3, f4, f5), f8, f7, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x, -BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y, -BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f3, f4, f5), f6, f7, f11, f12, f13, f14);
                } else {
                    BillboardParticleBatch.putVertex(this.vertices, n5, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x + f3, -BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y + f4, -BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z + f5), f6, f9, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x + f3, BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y + f4, BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z + f5), f8, f9, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x + f3, BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y + f4, BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z + f5), f8, f7, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x + f3, -BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y + f4, -BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z + f5), f6, f7, f11, f12, f13, f14);
                }
                ++n3;
                ++n2;
            }
        }
    }

    private void fillVerticesToScreenCPU(int[] nArray) {
        Vector3 vector3 = TMP_V3.set(this.camera.direction).scl(-1.0f);
        Vector3 vector32 = TMP_V4.set(this.camera.up).crs(vector3).nor();
        Vector3 vector33 = this.camera.up;
        int n2 = 0;
        for (BillboardControllerRenderData billboardControllerRenderData : this.renderData) {
            ParallelArray$FloatChannel parallelArray$FloatChannel = billboardControllerRenderData.scaleChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel2 = billboardControllerRenderData.regionChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel3 = billboardControllerRenderData.positionChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel4 = billboardControllerRenderData.colorChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel5 = billboardControllerRenderData.rotationChannel;
            int n3 = 0;
            int n4 = billboardControllerRenderData.controller.particles.size;
            while (n3 < n4) {
                int n5 = nArray[n2] * this.currentVertexSize << 2;
                float f2 = parallelArray$FloatChannel.data[n3 * parallelArray$FloatChannel.strideSize];
                int n6 = n3 * parallelArray$FloatChannel2.strideSize;
                int n7 = n3 * parallelArray$FloatChannel3.strideSize;
                int n8 = n3 * parallelArray$FloatChannel4.strideSize;
                int n9 = n3 * parallelArray$FloatChannel5.strideSize;
                float f3 = parallelArray$FloatChannel3.data[n7];
                float f4 = parallelArray$FloatChannel3.data[n7 + 1];
                float f5 = parallelArray$FloatChannel3.data[n7 + 2];
                float f6 = parallelArray$FloatChannel2.data[n6];
                float f7 = parallelArray$FloatChannel2.data[n6 + 1];
                float f8 = parallelArray$FloatChannel2.data[n6 + 2];
                float f9 = parallelArray$FloatChannel2.data[n6 + 3];
                float f10 = parallelArray$FloatChannel2.data[n6 + 4] * f2;
                f2 = parallelArray$FloatChannel2.data[n6 + 5] * f2;
                float f11 = parallelArray$FloatChannel4.data[n8];
                float f12 = parallelArray$FloatChannel4.data[n8 + 1];
                float f13 = parallelArray$FloatChannel4.data[n8 + 2];
                float f14 = parallelArray$FloatChannel4.data[n8 + 3];
                float f15 = parallelArray$FloatChannel5.data[n9];
                float f16 = parallelArray$FloatChannel5.data[n9 + 1];
                TMP_V1.set(vector32).scl(f10);
                TMP_V2.set(vector33).scl(f2);
                if (f15 != 1.0f) {
                    TMP_M3.setToRotation(vector3, f15, f16);
                    BillboardParticleBatch.putVertex(this.vertices, n5, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x, -BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y, -BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f3, f4, f5), f6, f9, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x, BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y, BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f3, f4, f5), f8, f9, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x, BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y, BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f3, f4, f5), f8, f7, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x, -BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y, -BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f3, f4, f5), f6, f7, f11, f12, f13, f14);
                } else {
                    BillboardParticleBatch.putVertex(this.vertices, n5, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x + f3, -BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y + f4, -BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z + f5), f6, f9, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x + f3, BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y + f4, BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z + f5), f8, f9, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x + f3, BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y + f4, BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z + f5), f8, f7, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n5 += this.currentVertexSize, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x + f3, -BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y + f4, -BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z + f5), f6, f7, f11, f12, f13, f14);
                }
                ++n3;
                ++n2;
            }
        }
    }

    @Override
    protected void flush(int[] nArray) {
        int n2;
        if (this.useGPU) {
            this.fillVerticesGPU(nArray);
        } else if (this.mode == ParticleShader$AlignMode.Screen) {
            this.fillVerticesToScreenCPU(nArray);
        } else if (this.mode == ParticleShader$AlignMode.ViewPoint) {
            this.fillVerticesToViewPointCPU(nArray);
        }
        int n3 = this.bufferedParticlesCount << 2;
        for (int i2 = 0; i2 < n3; i2 += n2) {
            n2 = Math.min(n3 - i2, 32764);
            Renderable renderable = (Renderable)this.renderablePool.obtain();
            ((Renderable)this.renderablePool.obtain()).meshPart.size = n2 / 4 * 6;
            renderable.meshPart.mesh.setVertices(this.vertices, this.currentVertexSize * i2, this.currentVertexSize * n2);
            renderable.meshPart.update();
            this.renderables.add(renderable);
        }
    }

    @Override
    public void getRenderables(Array array, Pool pool) {
        for (Renderable renderable : this.renderables) {
            array.add(((Renderable)pool.obtain()).set(renderable));
        }
    }

    @Override
    public void save(d d2, ResourceData json$Serializable) {
        json$Serializable = ((ResourceData)json$Serializable).createSaveData("billboardBatch");
        ((ResourceData$SaveData)json$Serializable).save("cfg", new BillboardParticleBatch$Config(this.useGPU, this.mode));
        ((ResourceData$SaveData)json$Serializable).saveAsset(d2.e(), Texture.class);
    }

    @Override
    public void load(d object, ResourceData json$Serializable) {
        if ((json$Serializable = ((ResourceData)json$Serializable).getSaveData("billboardBatch")) != null) {
            this.setTexture((Texture)((d)object).a(((ResourceData$SaveData)json$Serializable).loadAsset()));
            object = (BillboardParticleBatch$Config)((ResourceData$SaveData)json$Serializable).load("cfg");
            this.setUseGpu(((BillboardParticleBatch$Config)object).useGPU);
            this.setAlignMode(((BillboardParticleBatch$Config)object).mode);
        }
    }
}

