/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.particles.ParticleEffect;
import com.badlogic.gdx.graphics.g3d.particles.batches.ParticleBatch;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Array$ArrayIterator;
import com.badlogic.gdx.utils.Pool;

public final class ParticleSystem
implements RenderableProvider {
    private static ParticleSystem instance;
    private Array batches = new Array();
    private Array effects = new Array();

    public static ParticleSystem get() {
        if (instance == null) {
            instance = new ParticleSystem();
        }
        return instance;
    }

    public final void add(ParticleBatch particleBatch) {
        this.batches.add(particleBatch);
    }

    public final void add(ParticleEffect particleEffect) {
        this.effects.add(particleEffect);
    }

    public final void remove(ParticleEffect particleEffect) {
        this.effects.removeValue(particleEffect, true);
    }

    public final void removeAll() {
        this.effects.clear();
    }

    public final void update() {
        Array$ArrayIterator array$ArrayIterator = this.effects.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((ParticleEffect)array$ArrayIterator.next()).update();
        }
    }

    public final void updateAndDraw() {
        for (ParticleEffect particleEffect : this.effects) {
            particleEffect.update();
            particleEffect.draw();
        }
    }

    public final void update(float f2) {
        Array$ArrayIterator array$ArrayIterator = this.effects.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((ParticleEffect)array$ArrayIterator.next()).update(f2);
        }
    }

    public final void updateAndDraw(float f2) {
        for (ParticleEffect particleEffect : this.effects) {
            particleEffect.update(f2);
            particleEffect.draw();
        }
    }

    public final void begin() {
        Array$ArrayIterator array$ArrayIterator = this.batches.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((ParticleBatch)array$ArrayIterator.next()).begin();
        }
    }

    public final void draw() {
        Array$ArrayIterator array$ArrayIterator = this.effects.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((ParticleEffect)array$ArrayIterator.next()).draw();
        }
    }

    public final void end() {
        Array$ArrayIterator array$ArrayIterator = this.batches.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((ParticleBatch)array$ArrayIterator.next()).end();
        }
    }

    @Override
    public final void getRenderables(Array array, Pool pool) {
        Array$ArrayIterator array$ArrayIterator = this.batches.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((ParticleBatch)array$ArrayIterator.next()).getRenderables(array, pool);
        }
    }

    public final Array getBatches() {
        return this.batches;
    }
}

