/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.c;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.IntAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader$AlignMode;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader$Config;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader$Inputs;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader$ParticleType;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader$Setters;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader$Inputs;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader$Setters;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class ParticleShader
extends BaseShader {
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;
    protected static long implementedFlags = BlendingAttribute.Type | TextureAttribute.Diffuse;
    static final Vector3 TMP_VECTOR3 = new Vector3();
    private Renderable renderable;
    private long materialMask;
    private long vertexMask;
    protected final ParticleShader$Config config;
    private static final long optionalAttributes = IntAttribute.CullFace | DepthTestAttribute.Type;
    Material currentMaterial;

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.e.a("com/badlogic/gdx/graphics/g3d/particles/particles.vertex.glsl").i();
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.e.a("com/badlogic/gdx/graphics/g3d/particles/particles.fragment.glsl").i();
        }
        return defaultFragmentShader;
    }

    public ParticleShader(Renderable renderable) {
        this(renderable, new ParticleShader$Config());
    }

    public ParticleShader(Renderable renderable, ParticleShader$Config particleShader$Config) {
        this(renderable, particleShader$Config, ParticleShader.createPrefix(renderable, particleShader$Config));
    }

    public ParticleShader(Renderable renderable, ParticleShader$Config particleShader$Config, String string) {
        this(renderable, particleShader$Config, string, particleShader$Config.vertexShader != null ? particleShader$Config.vertexShader : ParticleShader.getDefaultVertexShader(), particleShader$Config.fragmentShader != null ? particleShader$Config.fragmentShader : ParticleShader.getDefaultFragmentShader());
    }

    public ParticleShader(Renderable renderable, ParticleShader$Config particleShader$Config, String string, String string2, String string3) {
        this(renderable, particleShader$Config, new ShaderProgram(string + string2, string + string3));
    }

    public ParticleShader(Renderable renderable, ParticleShader$Config particleShader$Config, ShaderProgram shaderProgram) {
        this.config = particleShader$Config;
        this.program = shaderProgram;
        this.renderable = renderable;
        this.materialMask = renderable.material.getMask() | optionalAttributes;
        this.vertexMask = renderable.meshPart.mesh.getVertexAttributes().getMask();
        if (!particleShader$Config.ignoreUnimplemented && (implementedFlags & this.materialMask) != this.materialMask) {
            throw new GdxRuntimeException("Some attributes not implemented yet (" + this.materialMask + ")");
        }
        this.register(DefaultShader$Inputs.viewTrans, DefaultShader$Setters.viewTrans);
        this.register(DefaultShader$Inputs.projViewTrans, DefaultShader$Setters.projViewTrans);
        this.register(DefaultShader$Inputs.projTrans, DefaultShader$Setters.projTrans);
        this.register(ParticleShader$Inputs.screenWidth, ParticleShader$Setters.screenWidth);
        this.register(DefaultShader$Inputs.cameraUp, ParticleShader$Setters.cameraUp);
        this.register(ParticleShader$Inputs.cameraRight, ParticleShader$Setters.cameraRight);
        this.register(ParticleShader$Inputs.cameraInvDirection, ParticleShader$Setters.cameraInvDirection);
        this.register(DefaultShader$Inputs.cameraPosition, ParticleShader$Setters.cameraPosition);
        this.register(DefaultShader$Inputs.diffuseTexture, DefaultShader$Setters.diffuseTexture);
    }

    @Override
    public void init() {
        ShaderProgram shaderProgram = this.program;
        this.program = null;
        this.init(shaderProgram, this.renderable);
        this.renderable = null;
    }

    public static String createPrefix(Renderable object, ParticleShader$Config particleShader$Config) {
        object = "";
        object = Gdx.a.e() == c.b ? (String)object + "#version 120\n" : (String)object + "#version 100\n";
        if (particleShader$Config.type == ParticleShader$ParticleType.Billboard) {
            object = (String)object + "#define billboard\n";
            if (particleShader$Config.align == ParticleShader$AlignMode.Screen) {
                object = (String)object + "#define screenFacing\n";
            } else if (particleShader$Config.align == ParticleShader$AlignMode.ViewPoint) {
                object = (String)object + "#define viewPointFacing\n";
            }
        }
        return object;
    }

    @Override
    public boolean canRender(Renderable renderable) {
        return this.materialMask == (renderable.material.getMask() | optionalAttributes) && this.vertexMask == renderable.meshPart.mesh.getVertexAttributes().getMask();
    }

    @Override
    public int compareTo(Shader shader) {
        if (shader == null) {
            return -1;
        }
        if (shader == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof ParticleShader && this.equals((ParticleShader)object);
    }

    public boolean equals(ParticleShader particleShader) {
        return particleShader == this;
    }

    @Override
    public void begin(Camera camera, RenderContext renderContext) {
        super.begin(camera, renderContext);
    }

    @Override
    public void render(Renderable renderable) {
        if (!renderable.material.has(BlendingAttribute.Type)) {
            this.context.setBlending(false, 770, 771);
        }
        this.bindMaterial(renderable);
        super.render(renderable);
    }

    @Override
    public void end() {
        this.currentMaterial = null;
        super.end();
    }

    protected void bindMaterial(Renderable object) {
        if (this.currentMaterial == ((Renderable)object).material) {
            return;
        }
        int n2 = this.config.defaultCullFace == -1 ? 1029 : this.config.defaultCullFace;
        int n3 = this.config.defaultDepthFunc == -1 ? 515 : this.config.defaultDepthFunc;
        float f2 = 0.0f;
        float f3 = 1.0f;
        boolean bl2 = true;
        this.currentMaterial = ((Renderable)object).material;
        for (Attribute attribute : this.currentMaterial) {
            long l2 = attribute.type;
            if (BlendingAttribute.is(l2)) {
                this.context.setBlending(true, ((BlendingAttribute)attribute).sourceFunction, ((BlendingAttribute)attribute).destFunction);
                continue;
            }
            if ((l2 & DepthTestAttribute.Type) == DepthTestAttribute.Type) {
                DepthTestAttribute depthTestAttribute = (DepthTestAttribute)attribute;
                n3 = depthTestAttribute.depthFunc;
                f2 = depthTestAttribute.depthRangeNear;
                f3 = depthTestAttribute.depthRangeFar;
                bl2 = depthTestAttribute.depthMask;
                continue;
            }
            if (this.config.ignoreUnimplemented) continue;
            throw new GdxRuntimeException("Unknown material attribute: " + attribute.toString());
        }
        this.context.setCullFace(n2);
        this.context.setDepthTest(n3, f2, f3);
        this.context.setDepthMask(bl2);
    }

    @Override
    public void dispose() {
        this.program.dispose();
        super.dispose();
    }

    public int getDefaultCullFace() {
        if (this.config.defaultCullFace == -1) {
            return 1029;
        }
        return this.config.defaultCullFace;
    }

    public void setDefaultCullFace(int n2) {
        this.config.defaultCullFace = n2;
    }

    public int getDefaultDepthFunc() {
        if (this.config.defaultDepthFunc == -1) {
            return 515;
        }
        return this.config.defaultDepthFunc;
    }

    public void setDefaultDepthFunc(int n2) {
        this.config.defaultDepthFunc = n2;
    }
}

