/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.a.d;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$FloatChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleControllerComponent;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData$Configurable;
import com.badlogic.gdx.graphics.g3d.particles.emitters.Emitter;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.graphics.g3d.particles.renderers.ParticleControllerRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Array$ArrayIterator;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.Json$Serializable;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.reflect.ClassReflection;

public class ParticleController
implements ResourceData$Configurable,
Json$Serializable {
    protected static final float DEFAULT_TIME_STEP = 0.016666668f;
    public String name;
    public Emitter emitter;
    public Array influencers;
    public ParticleControllerRenderer renderer;
    public ParallelArray particles;
    public ParticleChannels particleChannels;
    public Matrix4 transform = new Matrix4();
    public Vector3 scale = new Vector3(1.0f, 1.0f, 1.0f);
    protected BoundingBox boundingBox;
    public float deltaTime;
    public float deltaTimeSqr;

    public ParticleController() {
        this.influencers = new Array(true, 3, Influencer[]::new);
        this.setTimeStep(0.016666668f);
    }

    public ParticleController(String string, Emitter emitter, ParticleControllerRenderer particleControllerRenderer, Influencer ... influencerArray) {
        this();
        this.name = string;
        this.emitter = emitter;
        this.renderer = particleControllerRenderer;
        this.particleChannels = new ParticleChannels();
        this.influencers = new Array(influencerArray);
    }

    private void setTimeStep(float f2) {
        this.deltaTime = f2;
        this.deltaTimeSqr = this.deltaTime * this.deltaTime;
    }

    public void setTransform(Matrix4 matrix4) {
        this.transform.set(matrix4);
        matrix4.getScale(this.scale);
    }

    public void setTransform(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f9;
        this.transform.set(f2, f3, f4, f5, f6, f7, f8, f10, f10, f9);
        float f11 = f9;
        this.scale.set(f11, f11, f9);
    }

    public void rotate(Quaternion quaternion) {
        this.transform.rotate(quaternion);
    }

    public void rotate(Vector3 vector3, float f2) {
        this.transform.rotate(vector3, f2);
    }

    public void translate(Vector3 vector3) {
        this.transform.translate(vector3);
    }

    public void setTranslation(Vector3 vector3) {
        this.transform.setTranslation(vector3);
    }

    public void scale(float f2, float f3, float f4) {
        this.transform.scale(f2, f3, f4);
        this.transform.getScale(this.scale);
    }

    public void scale(Vector3 vector3) {
        this.scale(vector3.x, vector3.y, vector3.z);
    }

    public void mul(Matrix4 matrix4) {
        this.transform.mul(matrix4);
        this.transform.getScale(this.scale);
    }

    public void getTransform(Matrix4 matrix4) {
        matrix4.set(this.transform);
    }

    public boolean isComplete() {
        return this.emitter.isComplete();
    }

    public void init() {
        this.bind();
        if (this.particles != null) {
            this.end();
            this.particleChannels.resetIds();
        }
        ParticleController particleController = this;
        particleController.allocateChannels(particleController.emitter.maxParticleCount);
        ((ParticleControllerComponent)this.emitter).init();
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).init();
        }
        this.renderer.init();
    }

    protected void allocateChannels(int n2) {
        this.particles = new ParallelArray(n2);
        this.emitter.allocateChannels();
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).allocateChannels();
        }
        this.renderer.allocateChannels();
    }

    protected void bind() {
        this.emitter.set(this);
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).set(this);
        }
        ((ParticleControllerComponent)this.renderer).set(this);
    }

    public void start() {
        this.emitter.start();
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).start();
        }
    }

    public void reset() {
        this.end();
        this.start();
    }

    public void end() {
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).end();
        }
        ((ParticleControllerComponent)this.emitter).end();
    }

    public void activateParticles(int n2, int n3) {
        this.emitter.activateParticles(n2, n3);
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).activateParticles(n2, n3);
        }
    }

    public void killParticles(int n2, int n3) {
        this.emitter.killParticles(n2, n3);
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).killParticles(n2, n3);
        }
    }

    public void update() {
        this.update(Gdx.b.k());
    }

    public void update(float f2) {
        this.setTimeStep(f2);
        this.emitter.update();
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).update();
        }
    }

    public void draw() {
        if (this.particles.size > 0) {
            ((ParticleControllerComponent)this.renderer).update();
        }
    }

    public ParticleController copy() {
        Emitter emitter = (Emitter)this.emitter.copy();
        Influencer[] influencerArray = new Influencer[this.influencers.size];
        int n2 = 0;
        for (Influencer influencer : this.influencers) {
            influencerArray[n2++] = (Influencer)influencer.copy();
        }
        return new ParticleController(new String(this.name), emitter, (ParticleControllerRenderer)this.renderer.copy(), influencerArray);
    }

    public void dispose() {
        this.emitter.dispose();
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).dispose();
        }
    }

    public BoundingBox getBoundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = new BoundingBox();
        }
        this.calculateBoundingBox();
        return this.boundingBox;
    }

    protected void calculateBoundingBox() {
        this.boundingBox.clr();
        ParallelArray$FloatChannel parallelArray$FloatChannel = (ParallelArray$FloatChannel)this.particles.getChannel(ParticleChannels.Position);
        int n2 = parallelArray$FloatChannel.strideSize * this.particles.size;
        for (int i2 = 0; i2 < n2; i2 += parallelArray$FloatChannel.strideSize) {
            this.boundingBox.ext(parallelArray$FloatChannel.data[i2], parallelArray$FloatChannel.data[i2 + 1], parallelArray$FloatChannel.data[i2 + 2]);
        }
    }

    private int findIndex(Class clazz) {
        for (int i2 = 0; i2 < this.influencers.size; ++i2) {
            Influencer influencer = (Influencer)this.influencers.get(i2);
            if (!ClassReflection.isAssignableFrom(clazz, influencer.getClass())) continue;
            return i2;
        }
        return -1;
    }

    public Influencer findInfluencer(Class clazz) {
        int n2 = this.findIndex(clazz);
        if (n2 >= 0) {
            return (Influencer)this.influencers.get(n2);
        }
        return null;
    }

    public void removeInfluencer(Class clazz) {
        int n2 = this.findIndex(clazz);
        if (n2 >= 0) {
            this.influencers.removeIndex(n2);
        }
    }

    public boolean replaceInfluencer(Class clazz, Influencer influencer) {
        int n2 = this.findIndex(clazz);
        if (n2 >= 0) {
            this.influencers.insert(n2, influencer);
            this.influencers.removeIndex(n2 + 1);
            return true;
        }
        return false;
    }

    @Override
    public void write(Json json) {
        json.writeValue("name", this.name);
        json.writeValue("emitter", this.emitter, Emitter.class);
        json.writeValue("influencers", this.influencers, Array.class, Influencer.class);
        json.writeValue("renderer", this.renderer, ParticleControllerRenderer.class);
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.name = (String)json.readValue("name", String.class, jsonValue);
        this.emitter = (Emitter)json.readValue("emitter", Emitter.class, jsonValue);
        this.influencers.addAll((Array)json.readValue("influencers", Array.class, Influencer.class, jsonValue));
        this.renderer = (ParticleControllerRenderer)json.readValue("renderer", ParticleControllerRenderer.class, jsonValue);
    }

    @Override
    public void save(d d2, ResourceData resourceData) {
        this.emitter.save(d2, resourceData);
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).save(d2, resourceData);
        }
        this.renderer.save(d2, resourceData);
    }

    @Override
    public void load(d d2, ResourceData resourceData) {
        this.emitter.load(d2, resourceData);
        Array$ArrayIterator array$ArrayIterator = this.influencers.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Influencer)array$ArrayIterator.next()).load(d2, resourceData);
        }
        this.renderer.load(d2, resourceData);
    }
}

