/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model;

import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Array$ArrayIterator;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class Node {
    public String id;
    public boolean inheritTransform = true;
    public boolean isAnimated;
    public final Vector3 translation = new Vector3();
    public final Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    public final Vector3 scale = new Vector3(1.0f, 1.0f, 1.0f);
    public final Matrix4 localTransform = new Matrix4();
    public final Matrix4 globalTransform = new Matrix4();
    public Array parts = new Array(2);
    protected Node parent;
    private final Array children = new Array(2);

    public Matrix4 calculateLocalTransform() {
        if (!this.isAnimated) {
            this.localTransform.set(this.translation, this.rotation, this.scale);
        }
        return this.localTransform;
    }

    public Matrix4 calculateWorldTransform() {
        if (this.inheritTransform && this.parent != null) {
            this.globalTransform.set(this.parent.globalTransform).mul(this.localTransform);
        } else {
            this.globalTransform.set(this.localTransform);
        }
        return this.globalTransform;
    }

    public void calculateTransforms(boolean bl2) {
        this.calculateLocalTransform();
        this.calculateWorldTransform();
        if (bl2) {
            Array$ArrayIterator array$ArrayIterator = this.children.iterator();
            while (array$ArrayIterator.hasNext()) {
                ((Node)array$ArrayIterator.next()).calculateTransforms(true);
            }
        }
    }

    public void calculateBoneTransforms(boolean bl2) {
        for (NodePart nodePart : this.parts) {
            if (nodePart.invBoneBindTransforms == null || nodePart.bones == null || nodePart.invBoneBindTransforms.size != nodePart.bones.length) continue;
            int n2 = nodePart.invBoneBindTransforms.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                nodePart.bones[i2].set(((Node[])nodePart.invBoneBindTransforms.keys)[i2].globalTransform).mul(((Matrix4[])nodePart.invBoneBindTransforms.values)[i2]);
            }
        }
        if (bl2) {
            Array$ArrayIterator array$ArrayIterator = this.children.iterator();
            while (array$ArrayIterator.hasNext()) {
                ((Node)array$ArrayIterator.next()).calculateBoneTransforms(true);
            }
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox) {
        boundingBox.inf();
        return this.extendBoundingBox(boundingBox);
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox, boolean bl2) {
        boundingBox.inf();
        return this.extendBoundingBox(boundingBox, bl2);
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox) {
        return this.extendBoundingBox(boundingBox, true);
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox, boolean bl2) {
        int n2;
        int n3 = this.parts.size;
        for (n2 = 0; n2 < n3; ++n2) {
            Object object = (NodePart)this.parts.get(n2);
            if (!((NodePart)object).enabled) continue;
            object = ((NodePart)object).meshPart;
            if (bl2) {
                ((MeshPart)object).mesh.extendBoundingBox(boundingBox, ((MeshPart)object).offset, ((MeshPart)object).size, this.globalTransform);
                continue;
            }
            ((MeshPart)object).mesh.extendBoundingBox(boundingBox, ((MeshPart)object).offset, ((MeshPart)object).size);
        }
        n2 = this.children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Node)this.children.get(i2)).extendBoundingBox(boundingBox);
        }
        return boundingBox;
    }

    public void attachTo(Node node) {
        node.addChild(this);
    }

    public void detach() {
        if (this.parent != null) {
            this.parent.removeChild(this);
            this.parent = null;
        }
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size > 0;
    }

    public int getChildCount() {
        return this.children.size;
    }

    public Node getChild(int n2) {
        return (Node)this.children.get(n2);
    }

    public Node getChild(String string, boolean bl2, boolean bl3) {
        return Node.getNode(this.children, string, bl2, bl3);
    }

    public int addChild(Node node) {
        return this.insertChild(-1, node);
    }

    public int addChildren(Iterable iterable) {
        return this.insertChildren(-1, iterable);
    }

    public int insertChild(int n2, Node node) {
        Node node2;
        for (node2 = this; node2 != null; node2 = node2.getParent()) {
            if (node2 != node) continue;
            throw new GdxRuntimeException("Cannot add a parent as a child");
        }
        node2 = node.getParent();
        if (node2 != null && !node2.removeChild(node)) {
            throw new GdxRuntimeException("Could not remove child from its current parent");
        }
        if (n2 < 0 || n2 >= this.children.size) {
            n2 = this.children.size;
            this.children.add(node);
        } else {
            this.children.insert(n2, node);
        }
        node.parent = this;
        return n2;
    }

    public int insertChildren(int n2, Iterable object) {
        if (n2 < 0 || n2 > this.children.size) {
            n2 = this.children.size;
        }
        int n3 = n2;
        object = object.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            this.insertChild(n3++, node);
        }
        return n2;
    }

    public boolean removeChild(Node node) {
        if (!this.children.removeValue(node, true)) {
            return false;
        }
        node.parent = null;
        return true;
    }

    public Iterable getChildren() {
        return this.children;
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Node copy() {
        return new Node().set(this);
    }

    protected Node set(Node node) {
        this.detach();
        this.id = node.id;
        this.isAnimated = node.isAnimated;
        this.inheritTransform = node.inheritTransform;
        this.translation.set(node.translation);
        this.rotation.set(node.rotation);
        this.scale.set(node.scale);
        this.localTransform.set(node.localTransform);
        this.globalTransform.set(node.globalTransform);
        this.parts.clear();
        for (Object object : node.parts) {
            this.parts.add(((NodePart)object).copy());
        }
        this.children.clear();
        for (Object object : node.getChildren()) {
            this.addChild(((Node)object).copy());
        }
        return this;
    }

    public static Node getNode(Array array, String string, boolean bl2, boolean bl3) {
        Node node;
        int n2;
        int n3 = array.size;
        if (bl3) {
            for (n2 = 0; n2 < n3; ++n2) {
                node = (Node)array.get(n2);
                if (!node.id.equalsIgnoreCase(string)) continue;
                return node;
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                node = (Node)array.get(n2);
                if (!node.id.equals(string)) continue;
                return node;
            }
        }
        if (bl2) {
            for (n2 = 0; n2 < n3; ++n2) {
                node = Node.getNode(((Node)array.get((int)n2)).children, string, true, bl3);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }
}

