/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.ModelCache$MeshPool;
import com.badlogic.gdx.graphics.g3d.ModelCache$SimpleMeshPool;
import com.badlogic.gdx.graphics.g3d.ModelCache$Sorter;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.a;
import com.badlogic.gdx.graphics.g3d.b;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.graphics.g3d.utils.RenderableSorter;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FlushablePool;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;

public class ModelCache
implements RenderableProvider,
Disposable {
    private Array renderables = new Array();
    private FlushablePool renderablesPool = new a(this);
    private FlushablePool meshPartPool = new b(this);
    private Array items = new Array();
    private Array tmp = new Array();
    private MeshBuilder meshBuilder;
    private boolean building;
    private RenderableSorter sorter;
    private ModelCache$MeshPool meshPool;
    private Camera camera;

    public ModelCache() {
        this(new ModelCache$Sorter(), new ModelCache$SimpleMeshPool());
    }

    public ModelCache(RenderableSorter renderableSorter, ModelCache$MeshPool modelCache$MeshPool) {
        this.sorter = renderableSorter;
        this.meshPool = modelCache$MeshPool;
        this.meshBuilder = new MeshBuilder();
    }

    public void begin() {
        this.begin(null);
    }

    public void begin(Camera camera) {
        if (this.building) {
            throw new GdxRuntimeException("Call end() after calling begin()");
        }
        this.building = true;
        this.camera = camera;
        this.renderablesPool.flush();
        this.renderables.clear();
        this.items.clear();
        this.meshPartPool.flush();
        this.meshPool.flush();
    }

    private Renderable obtainRenderable(Material material, int n2) {
        Renderable renderable = (Renderable)((Pool)this.renderablesPool).obtain();
        ((Renderable)((Pool)this.renderablesPool).obtain()).bones = null;
        renderable.environment = null;
        renderable.material = material;
        renderable.meshPart.mesh = null;
        renderable.meshPart.offset = 0;
        renderable.meshPart.size = 0;
        renderable.meshPart.primitiveType = n2;
        renderable.meshPart.center.set(0.0f, 0.0f, 0.0f);
        renderable.meshPart.halfExtents.set(0.0f, 0.0f, 0.0f);
        renderable.meshPart.radius = -1.0f;
        renderable.shader = null;
        renderable.userData = null;
        renderable.worldTransform.idt();
        return renderable;
    }

    public void end() {
        if (!this.building) {
            throw new GdxRuntimeException("Call begin() prior to calling end()");
        }
        this.building = false;
        if (this.items.size == 0) {
            return;
        }
        this.sorter.sort(this.camera, this.items);
        int cfr_ignored_0 = this.items.size;
        int cfr_ignored_1 = this.renderables.size;
        Renderable renderable = (Renderable)this.items.get(0);
        VertexAttributes vertexAttributes = renderable.meshPart.mesh.getVertexAttributes();
        Object object = renderable.material;
        int n2 = renderable.meshPart.primitiveType;
        int n3 = this.renderables.size;
        this.meshBuilder.begin(vertexAttributes);
        MeshPart meshPart = this.meshBuilder.part("", n2, (MeshPart)((Pool)this.meshPartPool).obtain());
        this.renderables.add(this.obtainRenderable((Material)object, n2));
        int n4 = this.items.size;
        for (int i2 = 0; i2 < n4; ++i2) {
            Renderable renderable2 = (Renderable)this.items.get(i2);
            VertexAttributes vertexAttributes2 = renderable2.meshPart.mesh.getVertexAttributes();
            Material material = renderable2.material;
            int n5 = renderable2.meshPart.primitiveType;
            boolean bl2 = vertexAttributes2.equals(vertexAttributes);
            int n6 = renderable2.meshPart.mesh.getNumIndices() > 0 ? renderable2.meshPart.mesh.getNumVertices() : renderable2.meshPart.size;
            n6 = this.meshBuilder.getNumVertices() + n6 <= 65536 ? 1 : 0;
            if (!((bl2 = bl2 && n6 != 0) && n5 == n2 && material.same((Attributes)object, true))) {
                if (!bl2) {
                    Mesh mesh = this.meshBuilder.end(this.meshPool.obtain(vertexAttributes, this.meshBuilder.getNumVertices(), this.meshBuilder.getNumIndices()));
                    while (n3 < this.renderables.size) {
                        ((Renderable)this.renderables.get((int)n3++)).meshPart.mesh = mesh;
                    }
                    vertexAttributes = vertexAttributes2;
                    this.meshBuilder.begin(vertexAttributes);
                }
                MeshPart meshPart2 = this.meshBuilder.part("", n5, (MeshPart)((Pool)this.meshPartPool).obtain());
                object = (Renderable)this.renderables.get(this.renderables.size - 1);
                ((Renderable)this.renderables.get(this.renderables.size - 1)).meshPart.offset = meshPart.offset;
                ((Renderable)object).meshPart.size = meshPart.size;
                meshPart = meshPart2;
                object = material;
                n2 = n5;
                this.renderables.add(this.obtainRenderable((Material)object, n2));
            }
            this.meshBuilder.setVertexTransform(renderable2.worldTransform);
            this.meshBuilder.addMesh(renderable2.meshPart.mesh, renderable2.meshPart.offset, renderable2.meshPart.size);
        }
        Mesh mesh = this.meshBuilder.end(this.meshPool.obtain(vertexAttributes, this.meshBuilder.getNumVertices(), this.meshBuilder.getNumIndices()));
        while (n3 < this.renderables.size) {
            ((Renderable)this.renderables.get((int)n3++)).meshPart.mesh = mesh;
        }
        Renderable renderable3 = (Renderable)this.renderables.get(this.renderables.size - 1);
        ((Renderable)this.renderables.get(this.renderables.size - 1)).meshPart.offset = meshPart.offset;
        renderable3.meshPart.size = meshPart.size;
    }

    public void add(Renderable renderable) {
        if (!this.building) {
            throw new GdxRuntimeException("Can only add items to the ModelCache in between .begin() and .end()");
        }
        if (renderable.bones == null) {
            this.items.add(renderable);
            return;
        }
        this.renderables.add(renderable);
    }

    public void add(RenderableProvider renderableProvider) {
        renderableProvider.getRenderables(this.tmp, this.renderablesPool);
        int n2 = this.tmp.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            ModelCache modelCache = this;
            modelCache.add((Renderable)modelCache.tmp.get(i2));
        }
        this.tmp.clear();
    }

    public void add(Iterable object) {
        object = object.iterator();
        while (object.hasNext()) {
            RenderableProvider renderableProvider = (RenderableProvider)object.next();
            this.add(renderableProvider);
        }
    }

    @Override
    public void getRenderables(Array array, Pool object) {
        if (this.building) {
            throw new GdxRuntimeException("Cannot render a ModelCache in between .begin() and .end()");
        }
        for (Renderable renderable : this.renderables) {
            ((Renderable)object.next()).shader = null;
            renderable.environment = null;
        }
        array.addAll(this.renderables);
    }

    @Override
    public void dispose() {
        if (this.building) {
            throw new GdxRuntimeException("Cannot dispose a ModelCache in between .begin() and .end()");
        }
        this.meshPool.dispose();
    }
}

