/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.freetype;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.d.a;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Blending;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFont$BitmapFontData;
import com.badlogic.gdx.graphics.g2d.BitmapFont$Glyph;
import com.badlogic.gdx.graphics.g2d.Gdx2DPixmap;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.PixmapPacker$GuillotineStrategy;
import com.badlogic.gdx.graphics.g2d.PixmapPacker$PackStrategy;
import com.badlogic.gdx.graphics.g2d.PixmapPacker$PixmapPackerRectangle;
import com.badlogic.gdx.graphics.g2d.PixmapPacker$SkylineStrategy;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$Bitmap;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$Face;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$Glyph;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$GlyphMetrics;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$GlyphSlot;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$Library;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$SizeMetrics;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$Stroker;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator$FreeTypeBitmapFontData;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator$FreeTypeFontParameter;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator$GlyphAndBitmap;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.ByteBuffer;

public class FreeTypeFontGenerator
implements Disposable {
    public static final String DEFAULT_CHARS = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
    public static final int NO_MAXIMUM = -1;
    private static int maxTextureSize = 1024;
    final FreeType$Library library;
    final FreeType$Face face;
    final String name;
    boolean bitmapped = false;
    private int pixelWidth;
    private int pixelHeight;

    public FreeTypeFontGenerator(a a2) {
        this(a2, 0);
    }

    public FreeTypeFontGenerator(a a2, int n2) {
        this.name = a2.f();
        this.library = FreeType.initFreeType();
        this.face = this.library.newFace(a2, n2);
        if (this.checkForBitmapFont()) {
            return;
        }
        this.setPixelSizes(0, 15);
    }

    private int getLoadingFlags(FreeTypeFontGenerator$FreeTypeFontParameter freeTypeFontGenerator$FreeTypeFontParameter) {
        int n2 = FreeType.FT_LOAD_DEFAULT;
        switch (freeTypeFontGenerator$FreeTypeFontParameter.hinting) {
            case None: {
                n2 |= FreeType.FT_LOAD_NO_HINTING;
                break;
            }
            case Slight: {
                n2 |= FreeType.FT_LOAD_TARGET_LIGHT;
                break;
            }
            case Medium: {
                n2 |= FreeType.FT_LOAD_TARGET_NORMAL;
                break;
            }
            case Full: {
                n2 |= FreeType.FT_LOAD_TARGET_MONO;
                break;
            }
            case AutoSlight: {
                n2 |= FreeType.FT_LOAD_FORCE_AUTOHINT | FreeType.FT_LOAD_TARGET_LIGHT;
                break;
            }
            case AutoMedium: {
                n2 |= FreeType.FT_LOAD_FORCE_AUTOHINT | FreeType.FT_LOAD_TARGET_NORMAL;
                break;
            }
            case AutoFull: {
                n2 |= FreeType.FT_LOAD_FORCE_AUTOHINT | FreeType.FT_LOAD_TARGET_MONO;
            }
        }
        return n2;
    }

    private boolean loadChar(int n2) {
        return this.loadChar(n2, FreeType.FT_LOAD_DEFAULT | FreeType.FT_LOAD_FORCE_AUTOHINT);
    }

    private boolean loadChar(int n2, int n3) {
        return this.face.loadChar(n2, n3);
    }

    private boolean checkForBitmapFont() {
        int n2 = this.face.getFaceFlags();
        if ((n2 & FreeType.FT_FACE_FLAG_FIXED_SIZES) == FreeType.FT_FACE_FLAG_FIXED_SIZES && (n2 & FreeType.FT_FACE_FLAG_HORIZONTAL) == FreeType.FT_FACE_FLAG_HORIZONTAL && this.loadChar(32) && this.face.getGlyph().getFormat() == 1651078259) {
            this.bitmapped = true;
        }
        return this.bitmapped;
    }

    public BitmapFont generateFont(FreeTypeFontGenerator$FreeTypeFontParameter freeTypeFontGenerator$FreeTypeFontParameter) {
        return this.generateFont(freeTypeFontGenerator$FreeTypeFontParameter, new FreeTypeFontGenerator$FreeTypeBitmapFontData());
    }

    public BitmapFont generateFont(FreeTypeFontGenerator$FreeTypeFontParameter freeTypeFontGenerator$FreeTypeFontParameter, FreeTypeFontGenerator$FreeTypeBitmapFontData disposable) {
        boolean bl2 = disposable.regions == null && freeTypeFontGenerator$FreeTypeFontParameter.packer != null;
        if (bl2) {
            disposable.regions = new Array();
        }
        this.generateData(freeTypeFontGenerator$FreeTypeFontParameter, (FreeTypeFontGenerator$FreeTypeBitmapFontData)disposable);
        if (bl2) {
            freeTypeFontGenerator$FreeTypeFontParameter.packer.updateTextureRegions(disposable.regions, freeTypeFontGenerator$FreeTypeFontParameter.minFilter, freeTypeFontGenerator$FreeTypeFontParameter.magFilter, freeTypeFontGenerator$FreeTypeFontParameter.genMipMaps);
        }
        if (disposable.regions.isEmpty()) {
            throw new GdxRuntimeException("Unable to create a font with no texture regions.");
        }
        FreeTypeFontGenerator$FreeTypeBitmapFontData freeTypeFontGenerator$FreeTypeBitmapFontData = disposable;
        disposable = this.newBitmapFont(freeTypeFontGenerator$FreeTypeBitmapFontData, freeTypeFontGenerator$FreeTypeBitmapFontData.regions, true);
        ((BitmapFont)disposable).setOwnsTexture(freeTypeFontGenerator$FreeTypeFontParameter.packer == null);
        return disposable;
    }

    protected BitmapFont newBitmapFont(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, Array array, boolean bl2) {
        return new BitmapFont(bitmapFont$BitmapFontData, array, bl2);
    }

    public int scaleForPixelHeight(int n2) {
        this.setPixelSizes(0, n2);
        FreeType$SizeMetrics freeType$SizeMetrics = this.face.getSize().getMetrics();
        int n3 = FreeType.toInt(freeType$SizeMetrics.getAscender());
        int n4 = FreeType.toInt(freeType$SizeMetrics.getDescender());
        int n5 = n2;
        return n5 * n5 / (n3 - n4);
    }

    public int scaleForPixelWidth(int n2, int n3) {
        FreeType$SizeMetrics freeType$SizeMetrics = this.face.getSize().getMetrics();
        int n4 = FreeType.toInt(freeType$SizeMetrics.getMaxAdvance());
        int n5 = FreeType.toInt(freeType$SizeMetrics.getAscender());
        int n6 = FreeType.toInt(freeType$SizeMetrics.getDescender());
        n2 = (n5 - n6) * n2 / (n4 * n3);
        this.setPixelSizes(0, n2);
        return n2;
    }

    public int scaleToFitSquare(int n2, int n3, int n4) {
        return Math.min(this.scaleForPixelHeight(n3), this.scaleForPixelWidth(n2, n4));
    }

    public FreeTypeFontGenerator$GlyphAndBitmap generateGlyphAndBitmap(int n2, int n3, boolean bl2) {
        this.setPixelSizes(0, n3);
        n3 = FreeType.toInt(this.face.getSize().getMetrics().getAscender());
        if (this.face.getCharIndex(n2) == 0) {
            return null;
        }
        if (!this.loadChar(n2)) {
            throw new GdxRuntimeException("Unable to load character!");
        }
        FreeType$GlyphSlot freeType$GlyphSlot = this.face.getGlyph();
        FreeType$Bitmap freeType$Bitmap = !this.bitmapped && !freeType$GlyphSlot.renderGlyph(FreeType.FT_RENDER_MODE_NORMAL) ? null : freeType$GlyphSlot.getBitmap();
        FreeType$GlyphMetrics freeType$GlyphMetrics = freeType$GlyphSlot.getMetrics();
        BitmapFont$Glyph bitmapFont$Glyph = new BitmapFont$Glyph();
        if (freeType$Bitmap != null) {
            bitmapFont$Glyph.width = freeType$Bitmap.getWidth();
            bitmapFont$Glyph.height = freeType$Bitmap.getRows();
        } else {
            bitmapFont$Glyph.width = 0;
            bitmapFont$Glyph.height = 0;
        }
        bitmapFont$Glyph.xoffset = freeType$GlyphSlot.getBitmapLeft();
        bitmapFont$Glyph.yoffset = bl2 ? -freeType$GlyphSlot.getBitmapTop() + n3 : -(bitmapFont$Glyph.height - freeType$GlyphSlot.getBitmapTop()) - n3;
        bitmapFont$Glyph.xadvance = FreeType.toInt(freeType$GlyphMetrics.getHoriAdvance());
        bitmapFont$Glyph.srcX = 0;
        bitmapFont$Glyph.srcY = 0;
        bitmapFont$Glyph.id = n2;
        FreeTypeFontGenerator$GlyphAndBitmap freeTypeFontGenerator$GlyphAndBitmap = new FreeTypeFontGenerator$GlyphAndBitmap(this);
        new FreeTypeFontGenerator$GlyphAndBitmap(this).glyph = bitmapFont$Glyph;
        freeTypeFontGenerator$GlyphAndBitmap.bitmap = freeType$Bitmap;
        return freeTypeFontGenerator$GlyphAndBitmap;
    }

    public FreeTypeFontGenerator$FreeTypeBitmapFontData generateData(int n2) {
        FreeTypeFontGenerator$FreeTypeFontParameter freeTypeFontGenerator$FreeTypeFontParameter = new FreeTypeFontGenerator$FreeTypeFontParameter();
        new FreeTypeFontGenerator$FreeTypeFontParameter().size = n2;
        return this.generateData(freeTypeFontGenerator$FreeTypeFontParameter);
    }

    public FreeTypeFontGenerator$FreeTypeBitmapFontData generateData(FreeTypeFontGenerator$FreeTypeFontParameter freeTypeFontGenerator$FreeTypeFontParameter) {
        return this.generateData(freeTypeFontGenerator$FreeTypeFontParameter, new FreeTypeFontGenerator$FreeTypeBitmapFontData());
    }

    void setPixelSizes(int n2, int n3) {
        this.pixelWidth = n2;
        this.pixelHeight = n3;
        if (!this.bitmapped && !this.face.setPixelSizes(n2, n3)) {
            throw new GdxRuntimeException("Couldn't set size for font");
        }
    }

    public FreeTypeFontGenerator$FreeTypeBitmapFontData generateData(FreeTypeFontGenerator$FreeTypeFontParameter freeTypeFontGenerator$FreeTypeFontParameter, FreeTypeFontGenerator$FreeTypeBitmapFontData freeTypeFontGenerator$FreeTypeBitmapFontData) {
        BitmapFont$Glyph bitmapFont$Glyph;
        int n2;
        int n3;
        int n4;
        char c2;
        int n5;
        int n6;
        freeTypeFontGenerator$FreeTypeBitmapFontData.name = this.name + "-" + freeTypeFontGenerator$FreeTypeFontParameter.size;
        char[] cArray = freeTypeFontGenerator$FreeTypeFontParameter.characters.toCharArray();
        int n7 = cArray.length;
        int n8 = freeTypeFontGenerator$FreeTypeFontParameter.incremental;
        int n9 = this.getLoadingFlags(freeTypeFontGenerator$FreeTypeFontParameter);
        this.setPixelSizes(0, freeTypeFontGenerator$FreeTypeFontParameter.size);
        FreeType$SizeMetrics freeType$SizeMetrics = this.face.getSize().getMetrics();
        freeTypeFontGenerator$FreeTypeBitmapFontData.flipped = freeTypeFontGenerator$FreeTypeFontParameter.flip;
        freeTypeFontGenerator$FreeTypeBitmapFontData.ascent = FreeType.toInt(freeType$SizeMetrics.getAscender());
        freeTypeFontGenerator$FreeTypeBitmapFontData.descent = FreeType.toInt(freeType$SizeMetrics.getDescender());
        freeTypeFontGenerator$FreeTypeBitmapFontData.lineHeight = FreeType.toInt(freeType$SizeMetrics.getHeight());
        float f2 = freeTypeFontGenerator$FreeTypeBitmapFontData.ascent;
        if (this.bitmapped && freeTypeFontGenerator$FreeTypeBitmapFontData.lineHeight == 0.0f) {
            for (int i2 = 32; i2 < 32 + this.face.getNumGlyphs(); ++i2) {
                if (!this.loadChar(i2, n9)) continue;
                n6 = FreeType.toInt(this.face.getGlyph().getMetrics().getHeight());
                freeTypeFontGenerator$FreeTypeBitmapFontData.lineHeight = (float)n6 > freeTypeFontGenerator$FreeTypeBitmapFontData.lineHeight ? (float)n6 : freeTypeFontGenerator$FreeTypeBitmapFontData.lineHeight;
            }
        }
        freeTypeFontGenerator$FreeTypeBitmapFontData.lineHeight += (float)freeTypeFontGenerator$FreeTypeFontParameter.spaceY;
        freeTypeFontGenerator$FreeTypeBitmapFontData.spaceXadvance = this.loadChar(32, n9) || this.loadChar(108, n9) ? (float)FreeType.toInt(this.face.getGlyph().getMetrics().getHoriAdvance()) : (float)this.face.getMaxAdvanceWidth();
        char[] cArray2 = freeTypeFontGenerator$FreeTypeBitmapFontData.xChars;
        n6 = freeTypeFontGenerator$FreeTypeBitmapFontData.xChars.length;
        for (n5 = 0; n5 < n6; ++n5) {
            c2 = cArray2[n5];
            if (!this.loadChar(c2, n9)) continue;
            freeTypeFontGenerator$FreeTypeBitmapFontData.xHeight = FreeType.toInt(this.face.getGlyph().getMetrics().getHeight());
            break;
        }
        if (freeTypeFontGenerator$FreeTypeBitmapFontData.xHeight == 0.0f) {
            throw new GdxRuntimeException("No x-height character found in font");
        }
        cArray2 = freeTypeFontGenerator$FreeTypeBitmapFontData.capChars;
        n6 = freeTypeFontGenerator$FreeTypeBitmapFontData.capChars.length;
        for (n5 = 0; n5 < n6; ++n5) {
            c2 = cArray2[n5];
            if (!this.loadChar(c2, n9)) continue;
            freeTypeFontGenerator$FreeTypeBitmapFontData.capHeight = FreeType.toInt(this.face.getGlyph().getMetrics().getHeight()) + Math.abs(freeTypeFontGenerator$FreeTypeFontParameter.shadowOffsetY);
            break;
        }
        if (!this.bitmapped && freeTypeFontGenerator$FreeTypeBitmapFontData.capHeight == 1.0f) {
            throw new GdxRuntimeException("No cap character found in font");
        }
        freeTypeFontGenerator$FreeTypeBitmapFontData.ascent -= freeTypeFontGenerator$FreeTypeBitmapFontData.capHeight;
        freeTypeFontGenerator$FreeTypeBitmapFontData.down = -freeTypeFontGenerator$FreeTypeBitmapFontData.lineHeight;
        if (freeTypeFontGenerator$FreeTypeFontParameter.flip) {
            freeTypeFontGenerator$FreeTypeBitmapFontData.ascent = -freeTypeFontGenerator$FreeTypeBitmapFontData.ascent;
            freeTypeFontGenerator$FreeTypeBitmapFontData.down = -freeTypeFontGenerator$FreeTypeBitmapFontData.down;
        }
        boolean bl2 = false;
        PixmapPacker pixmapPacker = freeTypeFontGenerator$FreeTypeFontParameter.packer;
        if (pixmapPacker == null) {
            PixmapPacker$PackStrategy pixmapPacker$PackStrategy;
            if (n8 != 0) {
                n5 = maxTextureSize;
                pixmapPacker$PackStrategy = new PixmapPacker$GuillotineStrategy();
            } else {
                int n10 = (int)Math.ceil(freeTypeFontGenerator$FreeTypeBitmapFontData.lineHeight);
                n5 = MathUtils.nextPowerOfTwo((int)Math.sqrt(n10 * n10 * n7));
                if (maxTextureSize > 0) {
                    n5 = Math.min(n5, maxTextureSize);
                }
                pixmapPacker$PackStrategy = new PixmapPacker$SkylineStrategy();
            }
            bl2 = true;
            int n11 = n5;
            pixmapPacker = new PixmapPacker(n11, n11, Pixmap$Format.RGBA8888, 1, false, pixmapPacker$PackStrategy);
            pixmapPacker.setTransparentColor(freeTypeFontGenerator$FreeTypeFontParameter.color);
            pixmapPacker.getTransparentColor().a = 0.0f;
            if (freeTypeFontGenerator$FreeTypeFontParameter.borderWidth > 0.0f) {
                pixmapPacker.setTransparentColor(freeTypeFontGenerator$FreeTypeFontParameter.borderColor);
                pixmapPacker.getTransparentColor().a = 0.0f;
            }
        }
        if (n8 != 0) {
            freeTypeFontGenerator$FreeTypeBitmapFontData.glyphs = new Array(n7 + 32);
        }
        Object object = null;
        if (freeTypeFontGenerator$FreeTypeFontParameter.borderWidth > 0.0f) {
            object = this.library.createStroker();
            ((FreeType$Stroker)object).set((int)(freeTypeFontGenerator$FreeTypeFontParameter.borderWidth * 64.0f), freeTypeFontGenerator$FreeTypeFontParameter.borderStraight ? FreeType.FT_STROKER_LINECAP_BUTT : FreeType.FT_STROKER_LINECAP_ROUND, freeTypeFontGenerator$FreeTypeFontParameter.borderStraight ? FreeType.FT_STROKER_LINEJOIN_MITER_FIXED : FreeType.FT_STROKER_LINEJOIN_ROUND, 0);
        }
        int[] nArray = new int[n7];
        for (n4 = 0; n4 < n7; ++n4) {
            BitmapFont$Glyph bitmapFont$Glyph2;
            n3 = cArray[n4];
            nArray[n4] = n2 = this.loadChar(n3, n9) ? FreeType.toInt(this.face.getGlyph().getMetrics().getHeight()) : 0;
            if (n3 != 0 || (bitmapFont$Glyph2 = this.createGlyph('\u0000', freeTypeFontGenerator$FreeTypeBitmapFontData, freeTypeFontGenerator$FreeTypeFontParameter, (FreeType$Stroker)object, f2, pixmapPacker)) == null || bitmapFont$Glyph2.width == 0 || bitmapFont$Glyph2.height == 0) continue;
            freeTypeFontGenerator$FreeTypeBitmapFontData.setGlyph(0, bitmapFont$Glyph2);
            freeTypeFontGenerator$FreeTypeBitmapFontData.missingGlyph = bitmapFont$Glyph2;
            if (n8 == 0) continue;
            freeTypeFontGenerator$FreeTypeBitmapFontData.glyphs.add(bitmapFont$Glyph2);
        }
        n4 = nArray.length;
        while (n4 > 0) {
            BitmapFont$Glyph bitmapFont$Glyph3;
            int n12;
            n3 = 0;
            n2 = nArray[0];
            for (n12 = 1; n12 < n4; ++n12) {
                n9 = nArray[n12];
                if (n9 <= n2) continue;
                n2 = n9;
                n3 = n12;
            }
            n12 = cArray[n3];
            if (((BitmapFont$BitmapFontData)freeTypeFontGenerator$FreeTypeBitmapFontData).getGlyph((char)n12) == null && (bitmapFont$Glyph3 = this.createGlyph((char)n12, freeTypeFontGenerator$FreeTypeBitmapFontData, freeTypeFontGenerator$FreeTypeFontParameter, (FreeType$Stroker)object, f2, pixmapPacker)) != null) {
                freeTypeFontGenerator$FreeTypeBitmapFontData.setGlyph(n12, bitmapFont$Glyph3);
                if (n8 != 0) {
                    freeTypeFontGenerator$FreeTypeBitmapFontData.glyphs.add(bitmapFont$Glyph3);
                }
            }
            nArray[n3] = nArray[--n4];
            n9 = cArray[n3];
            cArray[n3] = cArray[n4];
            cArray[n4] = n9;
        }
        if (object != null && n8 == 0) {
            ((FreeType$Stroker)object).dispose();
        }
        if (n8 != 0) {
            freeTypeFontGenerator$FreeTypeBitmapFontData.generator = this;
            freeTypeFontGenerator$FreeTypeBitmapFontData.parameter = freeTypeFontGenerator$FreeTypeFontParameter;
            freeTypeFontGenerator$FreeTypeBitmapFontData.stroker = object;
            freeTypeFontGenerator$FreeTypeBitmapFontData.packer = pixmapPacker;
        }
        freeTypeFontGenerator$FreeTypeFontParameter.kerning &= this.face.hasKerning();
        if (freeTypeFontGenerator$FreeTypeFontParameter.kerning) {
            for (n3 = 0; n3 < n7; ++n3) {
                n2 = cArray[n3];
                BitmapFont$Glyph bitmapFont$Glyph4 = ((BitmapFont$BitmapFontData)freeTypeFontGenerator$FreeTypeBitmapFontData).getGlyph((char)n2);
                if (bitmapFont$Glyph4 == null) continue;
                n9 = this.face.getCharIndex(n2);
                for (n8 = n3; n8 < n7; ++n8) {
                    char c3 = cArray[n8];
                    object = ((BitmapFont$BitmapFontData)freeTypeFontGenerator$FreeTypeBitmapFontData).getGlyph(c3);
                    if (object == null) continue;
                    int n13 = this.face.getCharIndex(c3);
                    n4 = this.face.getKerning(n9, n13, 0);
                    if (n4 != 0) {
                        bitmapFont$Glyph4.setKerning(c3, FreeType.toInt(n4));
                    }
                    if ((n4 = this.face.getKerning(n13, n9, 0)) == 0) continue;
                    ((BitmapFont$Glyph)object).setKerning(n2, FreeType.toInt(n4));
                }
            }
        }
        if (bl2) {
            freeTypeFontGenerator$FreeTypeBitmapFontData.regions = new Array();
            pixmapPacker.updateTextureRegions(freeTypeFontGenerator$FreeTypeBitmapFontData.regions, freeTypeFontGenerator$FreeTypeFontParameter.minFilter, freeTypeFontGenerator$FreeTypeFontParameter.magFilter, freeTypeFontGenerator$FreeTypeFontParameter.genMipMaps);
        }
        if ((bitmapFont$Glyph = ((BitmapFont$BitmapFontData)freeTypeFontGenerator$FreeTypeBitmapFontData).getGlyph(' ')) == null) {
            bitmapFont$Glyph = new BitmapFont$Glyph();
            new BitmapFont$Glyph().xadvance = (int)freeTypeFontGenerator$FreeTypeBitmapFontData.spaceXadvance + freeTypeFontGenerator$FreeTypeFontParameter.spaceX;
            bitmapFont$Glyph.id = 32;
            freeTypeFontGenerator$FreeTypeBitmapFontData.setGlyph(32, bitmapFont$Glyph);
        }
        if (bitmapFont$Glyph.width == 0) {
            bitmapFont$Glyph.width = (int)((float)bitmapFont$Glyph.xadvance + freeTypeFontGenerator$FreeTypeBitmapFontData.padRight);
        }
        return freeTypeFontGenerator$FreeTypeBitmapFontData;
    }

    protected BitmapFont$Glyph createGlyph(char c2, FreeTypeFontGenerator$FreeTypeBitmapFontData freeTypeFontGenerator$FreeTypeBitmapFontData, FreeTypeFontGenerator$FreeTypeFontParameter freeTypeFontGenerator$FreeTypeFontParameter, FreeType$Stroker freeType$Stroker, float f2, PixmapPacker pixmapPacker) {
        int n2;
        byte by2;
        int n3;
        if (this.face.getCharIndex(c2) == 0 && c2 != '\u0000') {
            return null;
        }
        if (!this.loadChar(c2, this.getLoadingFlags(freeTypeFontGenerator$FreeTypeFontParameter))) {
            return null;
        }
        FreeType$GlyphSlot freeType$GlyphSlot = this.face.getGlyph();
        FreeType$Glyph freeType$Glyph = freeType$GlyphSlot.getGlyph();
        try {
            freeType$Glyph.toBitmap(freeTypeFontGenerator$FreeTypeFontParameter.mono ? FreeType.FT_RENDER_MODE_MONO : FreeType.FT_RENDER_MODE_NORMAL);
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            freeType$Glyph.dispose();
            Gdx.a.a("FreeTypeFontGenerator", "Couldn't render char: ".concat(String.valueOf(c2)));
            return null;
        }
        FreeType$Bitmap freeType$Bitmap = freeType$Glyph.getBitmap();
        Pixmap pixmap = freeType$Bitmap.getPixmap(Pixmap$Format.RGBA8888, freeTypeFontGenerator$FreeTypeFontParameter.color, freeTypeFontGenerator$FreeTypeFontParameter.gamma);
        if (freeType$Bitmap.getWidth() != 0 && freeType$Bitmap.getRows() != 0) {
            int n4;
            if (freeTypeFontGenerator$FreeTypeFontParameter.borderWidth > 0.0f) {
                n4 = freeType$Glyph.getTop();
                n3 = freeType$Glyph.getLeft();
                FreeType$Glyph freeType$Glyph2 = freeType$GlyphSlot.getGlyph();
                freeType$Glyph2.strokeBorder(freeType$Stroker, false);
                freeType$Glyph2.toBitmap(freeTypeFontGenerator$FreeTypeFontParameter.mono ? FreeType.FT_RENDER_MODE_MONO : FreeType.FT_RENDER_MODE_NORMAL);
                int n5 = n3 - freeType$Glyph2.getLeft();
                int n6 = -(n4 - freeType$Glyph2.getTop());
                Pixmap pixmap2 = freeType$Glyph2.getBitmap().getPixmap(Pixmap$Format.RGBA8888, freeTypeFontGenerator$FreeTypeFontParameter.borderColor, freeTypeFontGenerator$FreeTypeFontParameter.borderGamma);
                int n7 = freeTypeFontGenerator$FreeTypeFontParameter.renderCount;
                for (by2 = 0; by2 < n7; ++by2) {
                    pixmap2.drawPixmap(pixmap, n5, n6);
                }
                pixmap.dispose();
                freeType$Glyph.dispose();
                pixmap = pixmap2;
                freeType$Glyph = freeType$Glyph2;
            }
            if (freeTypeFontGenerator$FreeTypeFontParameter.shadowOffsetX != 0 || freeTypeFontGenerator$FreeTypeFontParameter.shadowOffsetY != 0) {
                int n8;
                n4 = pixmap.getWidth();
                n3 = pixmap.getHeight();
                int n9 = Math.max(freeTypeFontGenerator$FreeTypeFontParameter.shadowOffsetX, 0);
                n2 = Math.max(freeTypeFontGenerator$FreeTypeFontParameter.shadowOffsetY, 0);
                int n10 = n4 + Math.abs(freeTypeFontGenerator$FreeTypeFontParameter.shadowOffsetX);
                by2 = n3 + Math.abs(freeTypeFontGenerator$FreeTypeFontParameter.shadowOffsetY);
                Pixmap pixmap3 = new Pixmap(new Gdx2DPixmap(n10, by2, Pixmap$Format.toGdx2DPixmapFormat(pixmap.getFormat())));
                pixmap3.setColor(pixmapPacker.getTransparentColor());
                pixmap3.fill();
                Color color = freeTypeFontGenerator$FreeTypeFontParameter.shadowColor;
                float f3 = color.a;
                if (f3 != 0.0f) {
                    by2 = (byte)(color.r * 255.0f);
                    n8 = (byte)(color.g * 255.0f);
                    byte by3 = (byte)(color.b * 255.0f);
                    ByteBuffer byteBuffer = pixmap.getPixels();
                    ByteBuffer byteBuffer2 = pixmap3.getPixels();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        int n11 = n10 * (i2 + n2) + n9;
                        for (int i3 = 0; i3 < n4; ++i3) {
                            int n12 = n4 * i2 + i3 << 2;
                            byte by4 = byteBuffer.get(n12 + 3);
                            n12 = by4;
                            if (by4 == 0) continue;
                            int n13 = n11 + i3 << 2;
                            byteBuffer2.put(n13, by2);
                            byteBuffer2.put(n13 + 1, (byte)n8);
                            byteBuffer2.put(n13 + 2, by3);
                            byteBuffer2.put(n13 + 3, (byte)((float)(n12 & 0xFF) * f3));
                        }
                    }
                }
                n8 = freeTypeFontGenerator$FreeTypeFontParameter.renderCount;
                for (by2 = 0; by2 < n8; ++by2) {
                    pixmap3.drawPixmap(pixmap, Math.max(-freeTypeFontGenerator$FreeTypeFontParameter.shadowOffsetX, 0), Math.max(-freeTypeFontGenerator$FreeTypeFontParameter.shadowOffsetY, 0));
                }
                pixmap.dispose();
                pixmap = pixmap3;
            } else if (freeTypeFontGenerator$FreeTypeFontParameter.borderWidth == 0.0f) {
                n3 = freeTypeFontGenerator$FreeTypeFontParameter.renderCount - 1;
                for (n4 = 0; n4 < n3; ++n4) {
                    Pixmap pixmap4 = pixmap;
                    pixmap4.drawPixmap(pixmap4, 0, 0);
                }
            }
            if (freeTypeFontGenerator$FreeTypeFontParameter.padTop > 0 || freeTypeFontGenerator$FreeTypeFontParameter.padLeft > 0 || freeTypeFontGenerator$FreeTypeFontParameter.padBottom > 0 || freeTypeFontGenerator$FreeTypeFontParameter.padRight > 0) {
                Pixmap pixmap5 = new Pixmap(pixmap.getWidth() + freeTypeFontGenerator$FreeTypeFontParameter.padLeft + freeTypeFontGenerator$FreeTypeFontParameter.padRight, pixmap.getHeight() + freeTypeFontGenerator$FreeTypeFontParameter.padTop + freeTypeFontGenerator$FreeTypeFontParameter.padBottom, pixmap.getFormat());
                pixmap5.setBlending(Pixmap$Blending.None);
                pixmap5.drawPixmap(pixmap, freeTypeFontGenerator$FreeTypeFontParameter.padLeft, freeTypeFontGenerator$FreeTypeFontParameter.padTop);
                pixmap.dispose();
                pixmap = pixmap5;
            }
        }
        FreeType$GlyphMetrics freeType$GlyphMetrics = freeType$GlyphSlot.getMetrics();
        BitmapFont$Glyph bitmapFont$Glyph = new BitmapFont$Glyph();
        new BitmapFont$Glyph().id = c2;
        bitmapFont$Glyph.width = pixmap.getWidth();
        bitmapFont$Glyph.height = pixmap.getHeight();
        bitmapFont$Glyph.xoffset = freeType$Glyph.getLeft();
        bitmapFont$Glyph.yoffset = freeTypeFontGenerator$FreeTypeFontParameter.flip ? -freeType$Glyph.getTop() + (int)f2 : -(bitmapFont$Glyph.height - freeType$Glyph.getTop()) - (int)f2;
        bitmapFont$Glyph.xadvance = FreeType.toInt(freeType$GlyphMetrics.getHoriAdvance()) + (int)freeTypeFontGenerator$FreeTypeFontParameter.borderWidth + freeTypeFontGenerator$FreeTypeFontParameter.spaceX;
        if (this.bitmapped) {
            pixmap.setColor(Color.CLEAR);
            pixmap.fill();
            ByteBuffer byteBuffer = freeType$Bitmap.getBuffer();
            n3 = Color.WHITE.toIntBits();
            int n14 = Color.CLEAR.toIntBits();
            for (n2 = 0; n2 < bitmapFont$Glyph.height; ++n2) {
                int n15 = n2 * freeType$Bitmap.getPitch();
                for (by2 = 0; by2 < bitmapFont$Glyph.width + bitmapFont$Glyph.xoffset; ++by2) {
                    int n16 = byteBuffer.get(n15 + by2 / 8) >>> 7 - by2 % 8 & 1;
                    pixmap.drawPixel(by2, n2, n16 == 1 ? n3 : n14);
                }
            }
        }
        PixmapPacker$PixmapPackerRectangle pixmapPacker$PixmapPackerRectangle = pixmapPacker.pack(pixmap);
        bitmapFont$Glyph.page = pixmapPacker.getPages().indexOf(pixmapPacker$PixmapPackerRectangle.page, true);
        bitmapFont$Glyph.srcX = pixmapPacker$PixmapPackerRectangle.getX();
        bitmapFont$Glyph.srcY = pixmapPacker$PixmapPackerRectangle.getY();
        if (freeTypeFontGenerator$FreeTypeFontParameter.incremental && freeTypeFontGenerator$FreeTypeBitmapFontData.regions != null && freeTypeFontGenerator$FreeTypeBitmapFontData.regions.size <= bitmapFont$Glyph.page) {
            pixmapPacker.updateTextureRegions(freeTypeFontGenerator$FreeTypeBitmapFontData.regions, freeTypeFontGenerator$FreeTypeFontParameter.minFilter, freeTypeFontGenerator$FreeTypeFontParameter.magFilter, freeTypeFontGenerator$FreeTypeFontParameter.genMipMaps);
        }
        pixmap.dispose();
        freeType$Glyph.dispose();
        return bitmapFont$Glyph;
    }

    public boolean hasGlyph(int n2) {
        return this.face.getCharIndex(n2) != 0;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void dispose() {
        this.face.dispose();
        this.library.dispose();
    }

    public static void setMaxTextureSize(int n2) {
        maxTextureSize = n2;
    }

    public static int getMaxTextureSize() {
        return maxTextureSize;
    }
}

