/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.freetype;

import com.badlogic.gdx.graphics.g2d.freetype.FreeType;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$Face;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType$Stroker;
import com.badlogic.gdx.graphics.g2d.freetype.a;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FreeType$Library
extends a
implements Disposable {
    LongMap fontData = new LongMap();

    FreeType$Library(long l2) {
        super(l2);
    }

    @Override
    public void dispose() {
        FreeType$Library.doneFreeType(this.address);
        for (ByteBuffer byteBuffer : this.fontData.values()) {
            if (!BufferUtils.isUnsafeByteBuffer(byteBuffer)) continue;
            BufferUtils.disposeUnsafeByteBuffer(byteBuffer);
        }
    }

    private static native void doneFreeType(long var0);

    public FreeType$Face newFace(com.badlogic.gdx.d.a a2, int n2) {
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = a2.a(FileChannel.MapMode.READ_ONLY);
        }
        catch (GdxRuntimeException gdxRuntimeException) {}
        if (byteBuffer == null) {
            InputStream inputStream = a2.h();
            try {
                int n3 = (int)a2.o();
                if (n3 == 0) {
                    byte[] byArray = StreamUtils.copyStreamToByteArray(inputStream, 16384);
                    byteBuffer = BufferUtils.newUnsafeByteBuffer(byArray.length);
                    BufferUtils.copy(byArray, 0, (Buffer)byteBuffer, byArray.length);
                } else {
                    byteBuffer = BufferUtils.newUnsafeByteBuffer(n3);
                    StreamUtils.copyStream(inputStream, byteBuffer);
                }
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException(iOException);
            }
            finally {
                StreamUtils.closeQuietly(inputStream);
            }
        }
        return this.newMemoryFace(byteBuffer, n2);
    }

    public FreeType$Face newMemoryFace(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = BufferUtils.newUnsafeByteBuffer(byArray.length);
        BufferUtils.copy(byArray, 0, (Buffer)byteBuffer, byArray.length);
        return this.newMemoryFace(byteBuffer, n3);
    }

    public FreeType$Face newMemoryFace(ByteBuffer byteBuffer, int n2) {
        ByteBuffer byteBuffer2 = byteBuffer;
        long l2 = FreeType$Library.newMemoryFace(this.address, byteBuffer2, byteBuffer2.remaining(), n2);
        if (l2 == 0L) {
            if (BufferUtils.isUnsafeByteBuffer(byteBuffer)) {
                BufferUtils.disposeUnsafeByteBuffer(byteBuffer);
            }
            throw new GdxRuntimeException("Couldn't load font, FreeType error code: " + FreeType.getLastErrorCode());
        }
        this.fontData.put(l2, byteBuffer);
        return new FreeType$Face(l2, this);
    }

    private static native long newMemoryFace(long var0, ByteBuffer var2, int var3, int var4);

    public FreeType$Stroker createStroker() {
        long l2 = FreeType$Library.strokerNew(this.address);
        if (l2 == 0L) {
            throw new GdxRuntimeException("Couldn't create FreeType stroker, FreeType error code: " + FreeType.getLastErrorCode());
        }
        return new FreeType$Stroker(l2);
    }

    private static native long strokerNew(long var0);
}

