/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.freetype;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Blending;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType;
import com.badlogic.gdx.graphics.g2d.freetype.a;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class FreeType$Bitmap
extends a {
    FreeType$Bitmap(long l2) {
        super(l2);
    }

    public int getRows() {
        return FreeType$Bitmap.getRows(this.address);
    }

    private static native int getRows(long var0);

    public int getWidth() {
        return FreeType$Bitmap.getWidth(this.address);
    }

    private static native int getWidth(long var0);

    public int getPitch() {
        return FreeType$Bitmap.getPitch(this.address);
    }

    private static native int getPitch(long var0);

    public ByteBuffer getBuffer() {
        if (this.getRows() == 0) {
            return BufferUtils.newByteBuffer(1);
        }
        return FreeType$Bitmap.getBuffer(this.address);
    }

    private static native ByteBuffer getBuffer(long var0);

    public Pixmap getPixmap(Pixmap$Format pixmap$Format, Color object, float f2) {
        Pixmap pixmap;
        int n2 = this.getWidth();
        int n3 = this.getRows();
        ByteBuffer byteBuffer = this.getBuffer();
        int n4 = this.getPixelMode();
        int n5 = Math.abs(this.getPitch());
        if (object == Color.WHITE && n4 == FreeType.FT_PIXEL_MODE_GRAY && n5 == n2 && f2 == 1.0f) {
            pixmap = new Pixmap(n2, n3, Pixmap$Format.Alpha);
            BufferUtils.copy(byteBuffer, pixmap.getPixels(), pixmap.getPixels().capacity());
        } else {
            pixmap = new Pixmap(n2, n3, Pixmap$Format.RGBA8888);
            int n6 = Color.rgba8888((Color)object);
            byte[] byArray = new byte[n5];
            int[] nArray = new int[n2];
            IntBuffer intBuffer = pixmap.getPixels().asIntBuffer();
            if (n4 == FreeType.FT_PIXEL_MODE_MONO) {
                for (n4 = 0; n4 < n3; ++n4) {
                    byteBuffer.get(byArray);
                    int n7 = 0;
                    for (int i2 = 0; i2 < n2; i2 += 8) {
                        byte by2 = byArray[n7];
                        int n8 = Math.min(8, n2 - i2);
                        for (int i3 = 0; i3 < n8; ++i3) {
                            nArray[i2 + i3] = (by2 & 1 << 7 - i3) != 0 ? n6 : 0;
                        }
                        ++n7;
                    }
                    intBuffer.put(nArray);
                }
            } else {
                n4 = n6 & 0xFFFFFF00;
                int n9 = n6 & 0xFF;
                for (int i4 = 0; i4 < n3; ++i4) {
                    byteBuffer.get(byArray);
                    for (int i5 = 0; i5 < n2; ++i5) {
                        int n10 = byArray[i5] & 0xFF;
                        nArray[i5] = n10 == 0 ? n4 : (n10 == 255 ? n4 | n9 : n4 | (int)((float)n9 * (float)Math.pow((float)n10 / 255.0f, f2)));
                    }
                    intBuffer.put(nArray);
                }
            }
        }
        object = pixmap;
        if (pixmap$Format != pixmap.getFormat()) {
            object = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), pixmap$Format);
            ((Pixmap)object).setBlending(Pixmap$Blending.None);
            ((Pixmap)object).drawPixmap(pixmap, 0, 0);
            ((Pixmap)object).setBlending(Pixmap$Blending.SourceOver);
            pixmap.dispose();
        }
        return object;
    }

    public int getNumGray() {
        return FreeType$Bitmap.getNumGray(this.address);
    }

    private static native int getNumGray(long var0);

    public int getPixelMode() {
        return FreeType$Bitmap.getPixelMode(this.address);
    }

    private static native int getPixelMode(long var0);
}

