/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.d.a;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$AtlasRegion;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$AtlasSprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$TextureAtlasData;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$TextureAtlasData$Page;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$TextureAtlasData$Region;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.ObjectSet$ObjectSetIterator;

public class TextureAtlas
implements Disposable {
    private final ObjectSet textures;
    private final Array regions;

    public TextureAtlas() {
        this.textures = new ObjectSet(4);
        this.regions = new Array();
    }

    public TextureAtlas(String string) {
        this(Gdx.e.b(string));
    }

    public TextureAtlas(a a2) {
        a a3 = a2;
        this(a3, a3.a());
    }

    public TextureAtlas(a a2, boolean bl2) {
        a a3 = a2;
        this(a3, a3.a(), bl2);
    }

    public TextureAtlas(a a2, a a3) {
        this(a2, a3, false);
    }

    public TextureAtlas(a a2, a a3, boolean bl2) {
        this(new TextureAtlas$TextureAtlasData(a2, a3, bl2));
    }

    public TextureAtlas(TextureAtlas$TextureAtlasData textureAtlas$TextureAtlasData) {
        this.textures = new ObjectSet(4);
        this.regions = new Array();
        this.load(textureAtlas$TextureAtlasData);
    }

    public void load(TextureAtlas$TextureAtlasData object) {
        this.textures.ensureCapacity(((TextureAtlas$TextureAtlasData)object).pages.size);
        for (Object object2 : ((TextureAtlas$TextureAtlasData)object).pages) {
            if (((TextureAtlas$TextureAtlasData$Page)object2).texture == null) {
                ((TextureAtlas$TextureAtlasData$Page)object2).texture = new Texture(((TextureAtlas$TextureAtlasData$Page)object2).textureFile, ((TextureAtlas$TextureAtlasData$Page)object2).format, ((TextureAtlas$TextureAtlasData$Page)object2).useMipMaps);
            }
            ((TextureAtlas$TextureAtlasData$Page)object2).texture.setFilter(((TextureAtlas$TextureAtlasData$Page)object2).minFilter, ((TextureAtlas$TextureAtlasData$Page)object2).magFilter);
            ((TextureAtlas$TextureAtlasData$Page)object2).texture.setWrap(((TextureAtlas$TextureAtlasData$Page)object2).uWrap, ((TextureAtlas$TextureAtlasData$Page)object2).vWrap);
            this.textures.add(((TextureAtlas$TextureAtlasData$Page)object2).texture);
        }
        this.regions.ensureCapacity(((TextureAtlas$TextureAtlasData)object).regions.size);
        for (Object object2 : ((TextureAtlas$TextureAtlasData)object).regions) {
            object = new TextureAtlas$AtlasRegion(((TextureAtlas$TextureAtlasData$Region)object2).page.texture, ((TextureAtlas$TextureAtlasData$Region)object2).left, ((TextureAtlas$TextureAtlasData$Region)object2).top, ((TextureAtlas$TextureAtlasData$Region)object2).rotate ? ((TextureAtlas$TextureAtlasData$Region)object2).height : ((TextureAtlas$TextureAtlasData$Region)object2).width, ((TextureAtlas$TextureAtlasData$Region)object2).rotate ? ((TextureAtlas$TextureAtlasData$Region)object2).width : ((TextureAtlas$TextureAtlasData$Region)object2).height);
            new TextureAtlas$AtlasRegion(((TextureAtlas$TextureAtlasData$Region)object2).page.texture, ((TextureAtlas$TextureAtlasData$Region)object2).left, ((TextureAtlas$TextureAtlasData$Region)object2).top, ((TextureAtlas$TextureAtlasData$Region)object2).rotate ? ((TextureAtlas$TextureAtlasData$Region)object2).height : ((TextureAtlas$TextureAtlasData$Region)object2).width, ((TextureAtlas$TextureAtlasData$Region)object2).rotate ? ((TextureAtlas$TextureAtlasData$Region)object2).width : ((TextureAtlas$TextureAtlasData$Region)object2).height).index = ((TextureAtlas$TextureAtlasData$Region)object2).index;
            ((TextureAtlas$AtlasRegion)object).name = ((TextureAtlas$TextureAtlasData$Region)object2).name;
            ((TextureAtlas$AtlasRegion)object).offsetX = ((TextureAtlas$TextureAtlasData$Region)object2).offsetX;
            ((TextureAtlas$AtlasRegion)object).offsetY = ((TextureAtlas$TextureAtlasData$Region)object2).offsetY;
            ((TextureAtlas$AtlasRegion)object).originalHeight = ((TextureAtlas$TextureAtlasData$Region)object2).originalHeight;
            ((TextureAtlas$AtlasRegion)object).originalWidth = ((TextureAtlas$TextureAtlasData$Region)object2).originalWidth;
            ((TextureAtlas$AtlasRegion)object).rotate = ((TextureAtlas$TextureAtlasData$Region)object2).rotate;
            ((TextureAtlas$AtlasRegion)object).degrees = ((TextureAtlas$TextureAtlasData$Region)object2).degrees;
            ((TextureAtlas$AtlasRegion)object).names = ((TextureAtlas$TextureAtlasData$Region)object2).names;
            ((TextureAtlas$AtlasRegion)object).values = ((TextureAtlas$TextureAtlasData$Region)object2).values;
            if (((TextureAtlas$TextureAtlasData$Region)object2).flip) {
                ((TextureRegion)object).flip(false, true);
            }
            this.regions.add(object);
        }
    }

    public TextureAtlas$AtlasRegion addRegion(String string, Texture object, int n2, int n3, int n4, int n5) {
        this.textures.add(object);
        object = new TextureAtlas$AtlasRegion((Texture)object, n2, n3, n4, n5);
        v0.name = string;
        this.regions.add(object);
        return object;
    }

    public TextureAtlas$AtlasRegion addRegion(String string, TextureRegion textureRegion) {
        this.textures.add(textureRegion.texture);
        textureRegion = new TextureAtlas$AtlasRegion(textureRegion);
        v0.name = string;
        this.regions.add(textureRegion);
        return textureRegion;
    }

    public Array getRegions() {
        return this.regions;
    }

    public TextureAtlas$AtlasRegion findRegion(String string) {
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((TextureAtlas$AtlasRegion)this.regions.get((int)i2)).name.equals(string)) continue;
            return (TextureAtlas$AtlasRegion)this.regions.get(i2);
        }
        return null;
    }

    public TextureAtlas$AtlasRegion findRegion(String string, int n2) {
        int n3 = this.regions.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = (TextureAtlas$AtlasRegion)this.regions.get(i2);
            if (!textureAtlas$AtlasRegion.name.equals(string) || textureAtlas$AtlasRegion.index != n2) continue;
            return textureAtlas$AtlasRegion;
        }
        return null;
    }

    public Array findRegions(String string) {
        Array array = new Array(TextureAtlas$AtlasRegion[]::new);
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = (TextureAtlas$AtlasRegion)this.regions.get(i2);
            if (!textureAtlas$AtlasRegion.name.equals(string)) continue;
            array.add(new TextureAtlas$AtlasRegion(textureAtlas$AtlasRegion));
        }
        return array;
    }

    public Array createSprites() {
        Array array = new Array(true, this.regions.size, Sprite[]::new);
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextureAtlas textureAtlas = this;
            array.add(textureAtlas.newSprite((TextureAtlas$AtlasRegion)textureAtlas.regions.get(i2)));
        }
        return array;
    }

    public Sprite createSprite(String string) {
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((TextureAtlas$AtlasRegion)this.regions.get((int)i2)).name.equals(string)) continue;
            TextureAtlas textureAtlas = this;
            return textureAtlas.newSprite((TextureAtlas$AtlasRegion)textureAtlas.regions.get(i2));
        }
        return null;
    }

    public Sprite createSprite(String string, int n2) {
        int n3 = this.regions.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = (TextureAtlas$AtlasRegion)this.regions.get(i2);
            if (textureAtlas$AtlasRegion.index != n2 || !textureAtlas$AtlasRegion.name.equals(string)) continue;
            TextureAtlas textureAtlas = this;
            return textureAtlas.newSprite((TextureAtlas$AtlasRegion)textureAtlas.regions.get(i2));
        }
        return null;
    }

    public Array createSprites(String string) {
        Array array = new Array(Sprite[]::new);
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = (TextureAtlas$AtlasRegion)this.regions.get(i2);
            if (!textureAtlas$AtlasRegion.name.equals(string)) continue;
            array.add(this.newSprite(textureAtlas$AtlasRegion));
        }
        return array;
    }

    private Sprite newSprite(TextureAtlas$AtlasRegion textureAtlas$AtlasRegion) {
        if (textureAtlas$AtlasRegion.packedWidth == textureAtlas$AtlasRegion.originalWidth && textureAtlas$AtlasRegion.packedHeight == textureAtlas$AtlasRegion.originalHeight) {
            if (textureAtlas$AtlasRegion.rotate) {
                Sprite sprite = new Sprite(textureAtlas$AtlasRegion);
                sprite.setBounds(0.0f, 0.0f, textureAtlas$AtlasRegion.getRegionHeight(), textureAtlas$AtlasRegion.getRegionWidth());
                sprite.rotate90(true);
                return sprite;
            }
            return new Sprite(textureAtlas$AtlasRegion);
        }
        return new TextureAtlas$AtlasSprite(textureAtlas$AtlasRegion);
    }

    public NinePatch createPatch(String object) {
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = (TextureAtlas$AtlasRegion)this.regions.get(i2);
            if (!textureAtlas$AtlasRegion.name.equals(object)) continue;
            int[] nArray = textureAtlas$AtlasRegion.findValue("split");
            if (nArray == null) {
                throw new IllegalArgumentException("Region does not have ninepatch splits: ".concat(String.valueOf(object)));
            }
            object = new NinePatch((TextureRegion)textureAtlas$AtlasRegion, nArray[0], nArray[1], nArray[2], nArray[3]);
            nArray = textureAtlas$AtlasRegion.findValue("pad");
            if (nArray != null) {
                ((NinePatch)object).setPadding(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
            return object;
        }
        return null;
    }

    public ObjectSet getTextures() {
        return this.textures;
    }

    @Override
    public void dispose() {
        ObjectSet$ObjectSetIterator objectSet$ObjectSetIterator = this.textures.iterator();
        while (objectSet$ObjectSetIterator.hasNext()) {
            ((GLTexture)((Texture)objectSet$ObjectSetIterator.next())).dispose();
        }
        this.textures.clear(0);
    }
}

