/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Mesh$VertexDataType;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.PolygonBatch;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;

public class PolygonSpriteBatch
implements PolygonBatch {
    private Mesh mesh;
    private final float[] vertices;
    private final short[] triangles;
    private int vertexIndex;
    private int triangleIndex;
    private Texture lastTexture;
    private float invTexWidth;
    private float invTexHeight;
    private boolean drawing;
    private final Matrix4 transformMatrix;
    private final Matrix4 projectionMatrix;
    private final Matrix4 combinedMatrix;
    private boolean blendingDisabled;
    private int blendSrcFunc;
    private int blendDstFunc;
    private int blendSrcFuncAlpha;
    private int blendDstFuncAlpha;
    private final ShaderProgram shader;
    private ShaderProgram customShader;
    private boolean ownsShader;
    private final Color color;
    float colorPacked;
    public int renderCalls;
    public int totalRenderCalls;
    public int maxTrianglesInBatch;

    public PolygonSpriteBatch() {
        this(2000, null);
    }

    public PolygonSpriteBatch(int n2) {
        int n3 = n2;
        this(n3, n3 << 1, null);
    }

    public PolygonSpriteBatch(int n2, ShaderProgram shaderProgram) {
        int n3 = n2;
        this(n3, n3 << 1, shaderProgram);
    }

    public PolygonSpriteBatch(int n2, int n3, ShaderProgram shaderProgram) {
        this.invTexWidth = 0.0f;
        this.invTexHeight = 0.0f;
        this.transformMatrix = new Matrix4();
        this.projectionMatrix = new Matrix4();
        this.combinedMatrix = new Matrix4();
        this.blendSrcFunc = 770;
        this.blendDstFunc = 771;
        this.blendSrcFuncAlpha = 770;
        this.blendDstFuncAlpha = 771;
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.colorPacked = Color.WHITE_FLOAT_BITS;
        this.renderCalls = 0;
        this.totalRenderCalls = 0;
        this.maxTrianglesInBatch = 0;
        if (n2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Can't have more than 32767 vertices per batch: ".concat(String.valueOf(n2)));
        }
        Mesh$VertexDataType mesh$VertexDataType = Mesh$VertexDataType.VertexArray;
        if (Gdx.i != null) {
            mesh$VertexDataType = Mesh$VertexDataType.VertexBufferObjectWithVAO;
        }
        this.mesh = new Mesh(mesh$VertexDataType, false, n2, n3 * 3, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.vertices = new float[n2 * 5];
        this.triangles = new short[n3 * 3];
        if (shaderProgram == null) {
            this.shader = SpriteBatch.createDefaultShader();
            this.ownsShader = true;
        } else {
            this.shader = shaderProgram;
        }
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.b.g(), Gdx.b.h());
    }

    @Override
    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.end must be called before begin.");
        }
        this.renderCalls = 0;
        Gdx.g.glDepthMask(false);
        if (this.customShader != null) {
            this.customShader.bind();
        } else {
            this.shader.bind();
        }
        this.setupMatrices();
        this.drawing = true;
    }

    @Override
    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before end.");
        }
        if (this.vertexIndex > 0) {
            this.flush();
        }
        this.lastTexture = null;
        this.drawing = false;
        GL20 gL20 = Gdx.g;
        gL20.glDepthMask(true);
        if (this.isBlendingEnabled()) {
            gL20.glDisable(3042);
        }
    }

    @Override
    public void setColor(Color color) {
        this.color.set(color);
        this.colorPacked = color.toFloatBits();
    }

    @Override
    public void setColor(float f2, float f3, float f4, float f5) {
        this.color.set(f2, f3, f4, f5);
        this.colorPacked = this.color.toFloatBits();
    }

    @Override
    public void setPackedColor(float f2) {
        Color.abgr8888ToColor(this.color, f2);
        this.colorPacked = f2;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public float getPackedColor() {
        return this.colorPacked;
    }

    @Override
    public void draw(PolygonRegion object, float f2, float f3) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        short[] sArray2 = ((PolygonRegion)object).triangles;
        int n2 = ((PolygonRegion)object).triangles.length;
        float[] fArray = ((PolygonRegion)object).vertices;
        int n3 = ((PolygonRegion)object).vertices.length;
        Texture texture = ((PolygonRegion)object).region.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n2 > sArray.length || this.vertexIndex + n3 * 5 / 2 > this.vertices.length) {
            this.flush();
        }
        int n4 = this.triangleIndex;
        int n5 = this.vertexIndex;
        int n6 = n5 / 5;
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[n4++] = (short)(sArray2[i2] + n6);
        }
        this.triangleIndex = n4;
        float[] fArray2 = this.vertices;
        float f4 = this.colorPacked;
        object = ((PolygonRegion)object).textureCoords;
        for (int i3 = 0; i3 < n3; i3 += 2) {
            fArray2[n5++] = fArray[i3] + f2;
            fArray2[n5++] = fArray[i3 + 1] + f3;
            fArray2[n5++] = f4;
            fArray2[n5++] = (float)object[i3];
            fArray2[n5++] = (float)object[i3 + 1];
        }
        this.vertexIndex = n5;
    }

    @Override
    public void draw(PolygonRegion object, float f2, float f3, float f4, float f5) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        short[] sArray2 = ((PolygonRegion)object).triangles;
        int n2 = ((PolygonRegion)object).triangles.length;
        float[] fArray = ((PolygonRegion)object).vertices;
        int n3 = ((PolygonRegion)object).vertices.length;
        TextureRegion textureRegion = ((PolygonRegion)object).region;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n2 > sArray.length || this.vertexIndex + n3 * 5 / 2 > this.vertices.length) {
            this.flush();
        }
        n2 = this.triangleIndex;
        int n4 = this.vertexIndex;
        int n5 = n4 / 5;
        int n6 = sArray2.length;
        for (int i2 = 0; i2 < n6; ++i2) {
            sArray[n2++] = (short)(sArray2[i2] + n5);
        }
        this.triangleIndex = n2;
        float[] fArray2 = this.vertices;
        float f6 = this.colorPacked;
        object = ((PolygonRegion)object).textureCoords;
        f4 /= (float)textureRegion.regionWidth;
        f5 /= (float)textureRegion.regionHeight;
        for (int i3 = 0; i3 < n3; i3 += 2) {
            fArray2[n4++] = fArray[i3] * f4 + f2;
            fArray2[n4++] = fArray[i3 + 1] * f5 + f3;
            fArray2[n4++] = f6;
            fArray2[n4++] = (float)object[i3];
            fArray2[n4++] = (float)object[i3 + 1];
        }
        this.vertexIndex = n4;
    }

    @Override
    public void draw(PolygonRegion object, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        short[] sArray2 = ((PolygonRegion)object).triangles;
        int n2 = ((PolygonRegion)object).triangles.length;
        float[] fArray = ((PolygonRegion)object).vertices;
        int n3 = ((PolygonRegion)object).vertices.length;
        TextureRegion textureRegion = ((PolygonRegion)object).region;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n2 > sArray.length || this.vertexIndex + n3 * 5 / 2 > this.vertices.length) {
            this.flush();
        }
        int n4 = this.triangleIndex;
        int n5 = this.vertexIndex;
        int n6 = n5 / 5;
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[n4++] = (short)(sArray2[i2] + n6);
        }
        this.triangleIndex = n4;
        float[] fArray2 = this.vertices;
        float f11 = this.colorPacked;
        object = ((PolygonRegion)object).textureCoords;
        f2 += f4;
        f3 += f5;
        f6 /= (float)textureRegion.regionWidth;
        f7 /= (float)textureRegion.regionHeight;
        float f12 = MathUtils.cosDeg(f10);
        f10 = MathUtils.sinDeg(f10);
        for (n4 = 0; n4 < n3; n4 += 2) {
            float f13 = (fArray[n4] * f6 - f4) * f8;
            float f14 = (fArray[n4 + 1] * f7 - f5) * f9;
            fArray2[n5++] = f12 * f13 - f10 * f14 + f2;
            fArray2[n5++] = f10 * f13 + f12 * f14 + f3;
            fArray2[n5++] = f11;
            fArray2[n5++] = (float)object[n4];
            fArray2[n5++] = (float)object[n4 + 1];
        }
        this.vertexIndex = n5;
    }

    @Override
    public void draw(Texture texture, float[] fArray, int n2, int n3, short[] sArray, int n4, int n5) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray2 = this.triangles;
        float[] fArray2 = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n5 > sArray2.length || this.vertexIndex + n3 > fArray2.length) {
            this.flush();
        }
        int n6 = this.triangleIndex;
        int n7 = this.vertexIndex;
        int n8 = n7 / 5;
        n5 = n4 + n5;
        while (n4 < n5) {
            sArray2[n6++] = (short)(sArray[n4] + n8);
            ++n4;
        }
        this.triangleIndex = n6;
        System.arraycopy(fArray, n2, fArray2, n7, n3);
        this.vertexIndex += n3;
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
            this.flush();
        }
        int n6 = this.triangleIndex;
        int n7 = this.vertexIndex / 5;
        sArray[n6++] = (short)n7;
        sArray[n6++] = (short)(n7 + 1);
        sArray[n6++] = (short)(n7 + 2);
        sArray[n6++] = (short)(n7 + 2);
        sArray[n6++] = (short)(n7 + 3);
        sArray[n6++] = (short)n7;
        this.triangleIndex = n6;
        float f11 = f2 + f4;
        f2 = f3 + f5;
        f3 = -f4;
        float f12 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f3 *= f8;
            f12 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f3;
        f7 = f12;
        f8 = f5;
        f9 = f4;
        if (f10 != 0.0f) {
            f12 = MathUtils.cosDeg(f10);
            float f13 = MathUtils.sinDeg(f10);
            f10 = f12 * f6 - f13 * f7;
            f6 = f13 * f6 + f12 * f7;
            f7 = f12 * f3 - f13 * f8;
            f3 = f13 * f3 + f12 * f8;
            f8 = f12 * f9 - f13 * f5;
            f5 = f13 * f9 + f12 * f5;
            f4 = f10 + (f8 - f7);
            f9 = f5 - (f3 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f3;
            f3 = f8;
            f8 = f9;
            f9 = f12;
        }
        f10 += f11;
        f6 += f2;
        f7 += f11;
        f3 += f2;
        f8 += f11;
        f5 += f2;
        f4 += f11;
        f9 += f2;
        f12 = (float)n2 * this.invTexWidth;
        float f14 = (float)(n3 + n5) * this.invTexHeight;
        f11 = (float)(n2 + n4) * this.invTexWidth;
        f2 = (float)n3 * this.invTexHeight;
        if (bl2) {
            float f15 = f12;
            f12 = f11;
            f11 = f15;
        }
        if (bl3) {
            float f16 = f14;
            f14 = f2;
            f2 = f16;
        }
        float f17 = this.colorPacked;
        n3 = this.vertexIndex;
        fArray[n3++] = f10;
        fArray[n3++] = f6;
        fArray[n3++] = f17;
        fArray[n3++] = f12;
        fArray[n3++] = f14;
        fArray[n3++] = f7;
        fArray[n3++] = f3;
        fArray[n3++] = f17;
        fArray[n3++] = f12;
        fArray[n3++] = f2;
        fArray[n3++] = f8;
        fArray[n3++] = f5;
        fArray[n3++] = f17;
        fArray[n3++] = f11;
        fArray[n3++] = f2;
        fArray[n3++] = f4;
        fArray[n3++] = f9;
        fArray[n3++] = f17;
        fArray[n3++] = f11;
        fArray[n3++] = f14;
        this.vertexIndex = n3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        void var10_39;
        void var11_40;
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
            this.flush();
        }
        int n6 = this.triangleIndex;
        int n7 = this.vertexIndex / 5;
        sArray[n6++] = (short)n7;
        sArray[n6++] = (short)(n7 + 1);
        sArray[n6++] = (short)(n7 + 2);
        sArray[n6++] = (short)(n7 + 2);
        sArray[n6++] = (short)(n7 + 3);
        sArray[n6++] = (short)n7;
        this.triangleIndex = n6;
        float f6 = (float)n2 * this.invTexWidth;
        float f7 = (float)(n3 + n5) * this.invTexHeight;
        float f8 = (float)(n2 + n4) * this.invTexWidth;
        float f9 = (float)n3 * this.invTexHeight;
        f4 = f2 + f4;
        f5 = f3 + f5;
        if (bl2) {
            float f10 = f6;
            f6 = f8;
            f8 = f10;
        }
        if (var11_40 != false) {
            float f11 = f7;
            f7 = f9;
            f9 = f11;
        }
        float f12 = this.colorPacked;
        int n8 = this.vertexIndex;
        fArray[n8] = f2;
        fArray[++var10_20] = f3;
        fArray[++var10_21] = f12;
        fArray[++var10_22] = f6;
        fArray[++var10_23] = f7;
        fArray[++var10_24] = f2;
        fArray[++var10_25] = f5;
        fArray[++var10_26] = f12;
        fArray[++var10_27] = f6;
        fArray[++var10_28] = f9;
        fArray[++var10_29] = f4;
        fArray[++var10_30] = f5;
        fArray[++var10_31] = f12;
        fArray[++var10_32] = f8;
        fArray[++var10_33] = f9;
        fArray[++var10_34] = f4;
        fArray[++var10_35] = f3;
        fArray[++var10_36] = f12;
        fArray[++var10_37] = f8;
        fArray[++var10_38] = f7;
        this.vertexIndex = ++var10_39;
    }

    @Override
    public void draw(Texture texture, float f2, float f3, int n2, int n3, int n4, int n5) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
            this.flush();
        }
        int n6 = this.triangleIndex;
        int n7 = this.vertexIndex / 5;
        sArray[n6++] = (short)n7;
        sArray[n6++] = (short)(n7 + 1);
        sArray[n6++] = (short)(n7 + 2);
        sArray[n6++] = (short)(n7 + 2);
        sArray[n6++] = (short)(n7 + 3);
        sArray[n6++] = (short)n7;
        this.triangleIndex = n6;
        float f4 = (float)n2 * this.invTexWidth;
        float f5 = (float)(n3 + n5) * this.invTexHeight;
        float f6 = (float)(n2 + n4) * this.invTexWidth;
        float f7 = (float)n3 * this.invTexHeight;
        float f8 = f2 + (float)n4;
        float f9 = f3 + (float)n5;
        float f10 = this.colorPacked;
        int n8 = this.vertexIndex;
        fArray[n8++] = f2;
        fArray[n8++] = f3;
        fArray[n8++] = f10;
        fArray[n8++] = f4;
        fArray[n8++] = f5;
        fArray[n8++] = f2;
        fArray[n8++] = f9;
        fArray[n8++] = f10;
        fArray[n8++] = f4;
        fArray[n8++] = f7;
        fArray[n8++] = f8;
        fArray[n8++] = f9;
        fArray[n8++] = f10;
        fArray[n8++] = f6;
        fArray[n8++] = f7;
        fArray[n8++] = f8;
        fArray[n8++] = f3;
        fArray[n8++] = f10;
        fArray[n8++] = f6;
        fArray[n8++] = f5;
        this.vertexIndex = n8;
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
            this.flush();
        }
        int n2 = this.triangleIndex;
        int n3 = this.vertexIndex / 5;
        sArray[n2++] = (short)n3;
        sArray[n2++] = (short)(n3 + 1);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 3);
        sArray[n2++] = (short)n3;
        this.triangleIndex = n2;
        float f10 = f2 + f4;
        f4 = f3 + f5;
        f5 = this.colorPacked;
        int n4 = this.vertexIndex;
        fArray[n4++] = f2;
        fArray[n4++] = f3;
        fArray[n4++] = f5;
        fArray[n4++] = f6;
        fArray[n4++] = f7;
        fArray[n4++] = f2;
        fArray[n4++] = f4;
        fArray[n4++] = f5;
        fArray[n4++] = f6;
        fArray[n4++] = f9;
        fArray[n4++] = f10;
        fArray[n4++] = f4;
        fArray[n4++] = f5;
        fArray[n4++] = f8;
        fArray[n4++] = f9;
        fArray[n4++] = f10;
        fArray[n4++] = f3;
        fArray[n4++] = f5;
        fArray[n4++] = f8;
        fArray[n4++] = f7;
        this.vertexIndex = n4;
    }

    @Override
    public void draw(Texture texture, float f2, float f3) {
        this.draw(texture, f2, f3, (float)((GLTexture)texture).getWidth(), (float)((GLTexture)texture).getHeight());
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
            this.flush();
        }
        int n2 = this.triangleIndex;
        int n3 = this.vertexIndex / 5;
        sArray[n2++] = (short)n3;
        sArray[n2++] = (short)(n3 + 1);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 3);
        sArray[n2++] = (short)n3;
        this.triangleIndex = n2;
        float f6 = f2 + f4;
        f4 = f3 + f5;
        f5 = this.colorPacked;
        int n4 = this.vertexIndex;
        fArray[n4++] = f2;
        fArray[n4++] = f3;
        fArray[n4++] = f5;
        fArray[n4++] = 0.0f;
        fArray[n4++] = 1.0f;
        fArray[n4++] = f2;
        fArray[n4++] = f4;
        fArray[n4++] = f5;
        fArray[n4++] = 0.0f;
        fArray[n4++] = 0.0f;
        fArray[n4++] = f6;
        fArray[n4++] = f4;
        fArray[n4++] = f5;
        fArray[n4++] = 1.0f;
        fArray[n4++] = 0.0f;
        fArray[n4++] = f6;
        fArray[n4++] = f3;
        fArray[n4++] = f5;
        fArray[n4++] = 1.0f;
        fArray[n4++] = 1.0f;
        this.vertexIndex = n4;
    }

    @Override
    public void draw(Texture texture, float[] fArray, int n2, int n3) {
        int n4;
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray2 = this.vertices;
        int n5 = n3 / 20 * 6;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
            n4 = Math.min(Math.min(n3, fArray2.length - fArray2.length % 20), sArray.length / 6 * 20);
            n5 = n4 / 20 * 6;
        } else if (this.triangleIndex + n5 > sArray.length || this.vertexIndex + n3 > fArray2.length) {
            this.flush();
            n4 = Math.min(Math.min(n3, fArray2.length - fArray2.length % 20), sArray.length / 6 * 20);
            n5 = n4 / 20 * 6;
        } else {
            n4 = n3;
        }
        int n6 = this.vertexIndex;
        short s2 = (short)(n6 / 5);
        int n7 = this.triangleIndex;
        n5 = n7 + n5;
        while (n7 < n5) {
            sArray[n7] = s2;
            sArray[n7 + 1] = (short)(s2 + 1);
            sArray[n7 + 2] = (short)(s2 + 2);
            sArray[n7 + 3] = (short)(s2 + 2);
            sArray[n7 + 4] = (short)(s2 + 3);
            sArray[n7 + 5] = s2;
            n7 += 6;
            s2 = (short)(s2 + 4);
        }
        while (true) {
            System.arraycopy(fArray, n2, fArray2, n6, n4);
            this.vertexIndex = n6 + n4;
            this.triangleIndex = n7;
            if ((n3 -= n4) == 0) break;
            n2 += n4;
            this.flush();
            n6 = 0;
            if (n4 <= n3) continue;
            n4 = Math.min(n3, sArray.length / 6 * 20);
            n7 = n4 / 20 * 6;
        }
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3) {
        this.draw(textureRegion, f2, f3, (float)textureRegion.getRegionWidth(), (float)textureRegion.getRegionHeight());
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, float f4, float f5) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
            this.flush();
        }
        int n2 = this.triangleIndex;
        int n3 = this.vertexIndex / 5;
        sArray[n2++] = (short)n3;
        sArray[n2++] = (short)(n3 + 1);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 3);
        sArray[n2++] = (short)n3;
        this.triangleIndex = n2;
        f4 = f2 + f4;
        f5 = f3 + f5;
        float f6 = textureRegion.u;
        float f7 = textureRegion.v2;
        float f8 = textureRegion.u2;
        float f9 = textureRegion.v;
        float f10 = this.colorPacked;
        int n4 = this.vertexIndex;
        fArray[n4++] = f2;
        fArray[n4++] = f3;
        fArray[n4++] = f10;
        fArray[n4++] = f6;
        fArray[n4++] = f7;
        fArray[n4++] = f2;
        fArray[n4++] = f5;
        fArray[n4++] = f10;
        fArray[n4++] = f6;
        fArray[n4++] = f9;
        fArray[n4++] = f4;
        fArray[n4++] = f5;
        fArray[n4++] = f10;
        fArray[n4++] = f8;
        fArray[n4++] = f9;
        fArray[n4++] = f4;
        fArray[n4++] = f3;
        fArray[n4++] = f10;
        fArray[n4++] = f8;
        fArray[n4++] = f7;
        this.vertexIndex = n4;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
            this.flush();
        }
        int n2 = this.triangleIndex;
        int n3 = this.vertexIndex / 5;
        sArray[n2++] = (short)n3;
        sArray[n2++] = (short)(n3 + 1);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 3);
        sArray[n2++] = (short)n3;
        this.triangleIndex = n2;
        f2 += f4;
        f3 += f5;
        float f11 = -f4;
        float f12 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f11 *= f8;
            f12 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f11;
        f7 = f12;
        f8 = f11;
        f9 = f5;
        f11 = f4;
        if (f10 != 0.0f) {
            f12 = MathUtils.cosDeg(f10);
            float f13 = MathUtils.sinDeg(f10);
            f10 = f12 * f6 - f13 * f7;
            f6 = f13 * f6 + f12 * f7;
            f7 = f12 * f8 - f13 * f9;
            f8 = f13 * f8 + f12 * f9;
            f9 = f12 * f11 - f13 * f5;
            f5 = f13 * f11 + f12 * f5;
            f4 = f10 + (f9 - f7);
            f11 = f5 - (f8 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f8;
            f8 = f9;
            f9 = f11;
            f11 = f12;
        }
        f10 += f2;
        f6 += f3;
        f7 += f2;
        f8 += f3;
        f9 += f2;
        f5 += f3;
        f4 += f2;
        f11 += f3;
        f12 = textureRegion.u;
        float f14 = textureRegion.v2;
        f2 = textureRegion.u2;
        float f15 = textureRegion.v;
        f3 = this.colorPacked;
        int n4 = this.vertexIndex;
        fArray[n4++] = f10;
        fArray[n4++] = f6;
        fArray[n4++] = f3;
        fArray[n4++] = f12;
        fArray[n4++] = f14;
        fArray[n4++] = f7;
        fArray[n4++] = f8;
        fArray[n4++] = f3;
        fArray[n4++] = f12;
        fArray[n4++] = f15;
        fArray[n4++] = f9;
        fArray[n4++] = f5;
        fArray[n4++] = f3;
        fArray[n4++] = f2;
        fArray[n4++] = f15;
        fArray[n4++] = f4;
        fArray[n4++] = f11;
        fArray[n4++] = f3;
        fArray[n4++] = f2;
        fArray[n4++] = f14;
        this.vertexIndex = n4;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl2) {
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
            this.flush();
        }
        int n2 = this.triangleIndex;
        int n3 = this.vertexIndex / 5;
        sArray[n2++] = (short)n3;
        sArray[n2++] = (short)(n3 + 1);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 3);
        sArray[n2++] = (short)n3;
        this.triangleIndex = n2;
        f2 += f4;
        f3 += f5;
        float f16 = -f4;
        float f17 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f16 *= f8;
            f17 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f16;
        f7 = f17;
        f8 = f16;
        f9 = f5;
        f16 = f4;
        if (f10 != 0.0f) {
            f17 = MathUtils.cosDeg(f10);
            float f18 = MathUtils.sinDeg(f10);
            f10 = f17 * f6 - f18 * f7;
            f6 = f18 * f6 + f17 * f7;
            f7 = f17 * f8 - f18 * f9;
            f8 = f18 * f8 + f17 * f9;
            f9 = f17 * f16 - f18 * f5;
            f5 = f18 * f16 + f17 * f5;
            f4 = f10 + (f9 - f7);
            f16 = f5 - (f8 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f8;
            f8 = f9;
            f9 = f16;
            f16 = f17;
        }
        f10 += f2;
        f6 += f3;
        f7 += f2;
        f8 += f3;
        f9 += f2;
        f5 += f3;
        f4 += f2;
        f16 += f3;
        if (bl2) {
            f17 = textureRegion.u2;
            f15 = textureRegion.v2;
            f2 = textureRegion.u;
            f3 = textureRegion.v2;
            f14 = textureRegion.u;
            f13 = textureRegion.v;
            f12 = textureRegion.u2;
            f11 = textureRegion.v;
        } else {
            f17 = textureRegion.u;
            f15 = textureRegion.v;
            f2 = textureRegion.u2;
            f3 = textureRegion.v;
            f14 = textureRegion.u2;
            f13 = textureRegion.v2;
            f12 = textureRegion.u;
            f11 = textureRegion.v2;
        }
        float f19 = this.colorPacked;
        int n4 = this.vertexIndex;
        fArray[n4++] = f10;
        fArray[n4++] = f6;
        fArray[n4++] = f19;
        fArray[n4++] = f17;
        fArray[n4++] = f15;
        fArray[n4++] = f7;
        fArray[n4++] = f8;
        fArray[n4++] = f19;
        fArray[n4++] = f2;
        fArray[n4++] = f3;
        fArray[n4++] = f9;
        fArray[n4++] = f5;
        fArray[n4++] = f19;
        fArray[n4++] = f14;
        fArray[n4++] = f13;
        fArray[n4++] = f4;
        fArray[n4++] = f16;
        fArray[n4++] = f19;
        fArray[n4++] = f12;
        fArray[n4++] = f11;
        this.vertexIndex = n4;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, Affine2 affine2) {
        if (!this.drawing) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
            this.flush();
        }
        int n2 = this.triangleIndex;
        int n3 = this.vertexIndex / 5;
        sArray[n2++] = (short)n3;
        sArray[n2++] = (short)(n3 + 1);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 2);
        sArray[n2++] = (short)(n3 + 3);
        sArray[n2++] = (short)n3;
        this.triangleIndex = n2;
        float f4 = affine2.m02;
        float f5 = affine2.m12;
        float f6 = affine2.m01 * f3 + affine2.m02;
        float f7 = affine2.m11 * f3 + affine2.m12;
        float f8 = affine2.m00 * f2 + affine2.m01 * f3 + affine2.m02;
        f3 = affine2.m10 * f2 + affine2.m11 * f3 + affine2.m12;
        float f9 = affine2.m00 * f2 + affine2.m02;
        f2 = affine2.m10 * f2 + affine2.m12;
        float f10 = textureRegion.u;
        float f11 = textureRegion.v2;
        float f12 = textureRegion.u2;
        float f13 = textureRegion.v;
        float f14 = this.colorPacked;
        int n4 = this.vertexIndex;
        fArray[n4++] = f4;
        fArray[n4++] = f5;
        fArray[n4++] = f14;
        fArray[n4++] = f10;
        fArray[n4++] = f11;
        fArray[n4++] = f6;
        fArray[n4++] = f7;
        fArray[n4++] = f14;
        fArray[n4++] = f10;
        fArray[n4++] = f13;
        fArray[n4++] = f8;
        fArray[n4++] = f3;
        fArray[n4++] = f14;
        fArray[n4++] = f12;
        fArray[n4++] = f13;
        fArray[n4++] = f9;
        fArray[n4++] = f2;
        fArray[n4++] = f14;
        fArray[n4++] = f12;
        fArray[n4++] = f11;
        this.vertexIndex = n4;
    }

    @Override
    public void flush() {
        if (this.vertexIndex == 0) {
            return;
        }
        ++this.renderCalls;
        ++this.totalRenderCalls;
        int n2 = this.triangleIndex;
        if (n2 > this.maxTrianglesInBatch) {
            this.maxTrianglesInBatch = n2;
        }
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.vertexIndex);
        mesh.setIndices(this.triangles, 0, n2);
        if (this.blendingDisabled) {
            Gdx.g.glDisable(3042);
        } else {
            Gdx.g.glEnable(3042);
            if (this.blendSrcFunc != -1) {
                Gdx.g.glBlendFuncSeparate(this.blendSrcFunc, this.blendDstFunc, this.blendSrcFuncAlpha, this.blendDstFuncAlpha);
            }
        }
        mesh.render(this.customShader != null ? this.customShader : this.shader, 4, 0, n2);
        this.vertexIndex = 0;
        this.triangleIndex = 0;
    }

    @Override
    public void disableBlending() {
        this.flush();
        this.blendingDisabled = true;
    }

    @Override
    public void enableBlending() {
        this.flush();
        this.blendingDisabled = false;
    }

    @Override
    public void setBlendFunction(int n2, int n3) {
        this.setBlendFunctionSeparate(n2, n3, n2, n3);
    }

    @Override
    public void setBlendFunctionSeparate(int n2, int n3, int n4, int n5) {
        if (this.blendSrcFunc == n2 && this.blendDstFunc == n3 && this.blendSrcFuncAlpha == n4 && this.blendDstFuncAlpha == n5) {
            return;
        }
        this.flush();
        this.blendSrcFunc = n2;
        this.blendDstFunc = n3;
        this.blendSrcFuncAlpha = n4;
        this.blendDstFuncAlpha = n5;
    }

    @Override
    public int getBlendSrcFunc() {
        return this.blendSrcFunc;
    }

    @Override
    public int getBlendDstFunc() {
        return this.blendDstFunc;
    }

    @Override
    public int getBlendSrcFuncAlpha() {
        return this.blendSrcFuncAlpha;
    }

    @Override
    public int getBlendDstFuncAlpha() {
        return this.blendDstFuncAlpha;
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        if (this.ownsShader && this.shader != null) {
            this.shader.dispose();
        }
    }

    @Override
    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    @Override
    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public void setProjectionMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.projectionMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    @Override
    public void setTransformMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.transformMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    protected void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        if (this.customShader != null) {
            this.customShader.setUniformMatrix("u_projTrans", this.combinedMatrix);
            this.customShader.setUniformi("u_texture", 0);
            return;
        }
        this.shader.setUniformMatrix("u_projTrans", this.combinedMatrix);
        this.shader.setUniformi("u_texture", 0);
    }

    protected void switchTexture(Texture texture) {
        this.flush();
        this.lastTexture = texture;
        this.invTexWidth = 1.0f / (float)((GLTexture)texture).getWidth();
        this.invTexHeight = 1.0f / (float)((GLTexture)texture).getHeight();
    }

    @Override
    public void setShader(ShaderProgram shaderProgram) {
        if (this.drawing) {
            this.flush();
        }
        this.customShader = shaderProgram;
        if (this.drawing) {
            if (this.customShader != null) {
                this.customShader.bind();
            } else {
                this.shader.bind();
            }
            this.setupMatrices();
        }
    }

    @Override
    public ShaderProgram getShader() {
        if (this.customShader == null) {
            return this.shader;
        }
        return this.customShader;
    }

    @Override
    public boolean isBlendingEnabled() {
        return !this.blendingDisabled;
    }

    @Override
    public boolean isDrawing() {
        return this.drawing;
    }
}

