/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Blending;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.Texture$TextureFilter;
import com.badlogic.gdx.graphics.g2d.PixmapPacker$GuillotineStrategy;
import com.badlogic.gdx.graphics.g2d.PixmapPacker$PackStrategy;
import com.badlogic.gdx.graphics.g2d.PixmapPacker$Page;
import com.badlogic.gdx.graphics.g2d.PixmapPacker$PixmapPackerRectangle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$AtlasRegion;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Array$ArrayIterator;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PixmapPacker
implements Disposable {
    boolean packToTexture;
    boolean disposed;
    int pageWidth;
    int pageHeight;
    Pixmap$Format pageFormat;
    int padding;
    boolean duplicateBorder;
    boolean stripWhitespaceX;
    boolean stripWhitespaceY;
    int alphaThreshold;
    Color transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    final Array pages = new Array();
    PixmapPacker$PackStrategy packStrategy;
    static Pattern indexPattern = Pattern.compile("(.+)_(\\d+)$");
    private Color c = new Color();

    public PixmapPacker(int n2, int n3, Pixmap$Format pixmap$Format, int n4, boolean bl2) {
        this(n2, n3, pixmap$Format, n4, bl2, false, false, new PixmapPacker$GuillotineStrategy());
    }

    public PixmapPacker(int n2, int n3, Pixmap$Format pixmap$Format, int n4, boolean bl2, PixmapPacker$PackStrategy pixmapPacker$PackStrategy) {
        this(n2, n3, pixmap$Format, n4, bl2, false, false, pixmapPacker$PackStrategy);
    }

    public PixmapPacker(int n2, int n3, Pixmap$Format pixmap$Format, int n4, boolean bl2, boolean bl3, boolean bl4, PixmapPacker$PackStrategy pixmapPacker$PackStrategy) {
        this.pageWidth = n2;
        this.pageHeight = n3;
        this.pageFormat = pixmap$Format;
        this.padding = n4;
        this.duplicateBorder = bl2;
        this.stripWhitespaceX = bl3;
        this.stripWhitespaceY = bl4;
        this.packStrategy = pixmapPacker$PackStrategy;
    }

    public void sort(Array array) {
        this.packStrategy.sort(array);
    }

    public synchronized PixmapPacker$PixmapPackerRectangle pack(Pixmap pixmap) {
        return this.pack(null, pixmap);
    }

    public synchronized PixmapPacker$PixmapPackerRectangle pack(String string, Pixmap pixmap) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        PixmapPacker$PixmapPackerRectangle pixmapPacker$PixmapPackerRectangle;
        if (this.disposed) {
            return null;
        }
        if (string != null && this.getRect(string) != null) {
            throw new GdxRuntimeException("Pixmap has already been packed with name: ".concat(String.valueOf(string)));
        }
        Pixmap pixmap2 = null;
        if (string != null && string.endsWith(".9")) {
            pixmapPacker$PixmapPackerRectangle = new PixmapPacker$PixmapPackerRectangle(0, 0, pixmap.getWidth() - 2, pixmap.getHeight() - 2);
            pixmap2 = new Pixmap(pixmap.getWidth() - 2, pixmap.getHeight() - 2, pixmap.getFormat());
            pixmap2.setBlending(Pixmap$Blending.None);
            pixmapPacker$PixmapPackerRectangle.splits = this.getSplits(pixmap);
            pixmapPacker$PixmapPackerRectangle.pads = this.getPads(pixmap, pixmapPacker$PixmapPackerRectangle.splits);
            pixmap2.drawPixmap(pixmap, 0, 0, 1, 1, pixmap.getWidth() - 1, pixmap.getHeight() - 1);
            pixmap = pixmap2;
            string = string.split("\\.")[0];
        } else if (this.stripWhitespaceX || this.stripWhitespaceY) {
            int n8;
            int n9 = pixmap.getWidth();
            n7 = pixmap.getHeight();
            n6 = 0;
            n5 = pixmap.getHeight();
            if (this.stripWhitespaceY) {
                block0: for (n4 = 0; n4 < pixmap.getHeight(); ++n4) {
                    for (n3 = 0; n3 < pixmap.getWidth(); ++n3) {
                        if ((pixmap.getPixel(n3, n4) & 0xFF) > this.alphaThreshold) break block0;
                    }
                    ++n6;
                }
                n4 = pixmap.getHeight();
                block2: while (--n4 >= n6) {
                    for (n3 = 0; n3 < pixmap.getWidth(); ++n3) {
                        if ((pixmap.getPixel(n3, n4) & 0xFF) > this.alphaThreshold) break block2;
                    }
                    --n5;
                }
            }
            n4 = 0;
            n3 = pixmap.getWidth();
            if (this.stripWhitespaceX) {
                block4: for (n2 = 0; n2 < pixmap.getWidth(); ++n2) {
                    for (n8 = n6; n8 < n5; ++n8) {
                        if ((pixmap.getPixel(n2, n8) & 0xFF) > this.alphaThreshold) break block4;
                    }
                    ++n4;
                }
                n2 = pixmap.getWidth();
                block6: while (--n2 >= n4) {
                    for (n8 = n6; n8 < n5; ++n8) {
                        if ((pixmap.getPixel(n2, n8) & 0xFF) > this.alphaThreshold) break block6;
                    }
                    --n3;
                }
            }
            n2 = n3 - n4;
            n8 = n5 - n6;
            pixmap2 = new Pixmap(n2, n8, pixmap.getFormat());
            pixmap2.setBlending(Pixmap$Blending.None);
            pixmap2.drawPixmap(pixmap, 0, 0, n4, n6, n2, n8);
            pixmap = pixmap2;
            pixmapPacker$PixmapPackerRectangle = new PixmapPacker$PixmapPackerRectangle(0, 0, n2, n8, n4, n6, n9, n7);
        } else {
            pixmapPacker$PixmapPackerRectangle = new PixmapPacker$PixmapPackerRectangle(0, 0, pixmap.getWidth(), pixmap.getHeight());
        }
        if (pixmapPacker$PixmapPackerRectangle.getWidth() > this.pageWidth || pixmapPacker$PixmapPackerRectangle.getHeight() > this.pageHeight) {
            if (string == null) {
                throw new GdxRuntimeException("Page size too small for pixmap.");
            }
            throw new GdxRuntimeException("Page size too small for pixmap: ".concat(String.valueOf(string)));
        }
        PixmapPacker$Page pixmapPacker$Page = this.packStrategy.pack(this, string, pixmapPacker$PixmapPackerRectangle.bounds);
        if (string != null) {
            ((ObjectMap)pixmapPacker$Page.rects).put(string, pixmapPacker$PixmapPackerRectangle);
            pixmapPacker$Page.addedRects.add(string);
        }
        n7 = pixmapPacker$PixmapPackerRectangle.getX();
        n6 = pixmapPacker$PixmapPackerRectangle.getY();
        n5 = pixmapPacker$PixmapPackerRectangle.getWidth();
        n4 = pixmapPacker$PixmapPackerRectangle.getHeight();
        if (this.packToTexture && !this.duplicateBorder && pixmapPacker$Page.texture != null && !pixmapPacker$Page.dirty) {
            pixmapPacker$Page.texture.bind();
            Gdx.g.glTexSubImage2D(pixmapPacker$Page.texture.glTarget, 0, n7, n6, n5, n4, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
        } else {
            pixmapPacker$Page.dirty = true;
        }
        pixmapPacker$Page.image.drawPixmap(pixmap, n7, n6);
        if (this.duplicateBorder) {
            n3 = pixmap.getWidth();
            n2 = pixmap.getHeight();
            pixmapPacker$Page.image.drawPixmap(pixmap, 0, 0, 1, 1, n7 - 1, n6 - 1, 1, 1);
            pixmapPacker$Page.image.drawPixmap(pixmap, n3 - 1, 0, 1, 1, n7 + n5, n6 - 1, 1, 1);
            pixmapPacker$Page.image.drawPixmap(pixmap, 0, n2 - 1, 1, 1, n7 - 1, n6 + n4, 1, 1);
            pixmapPacker$Page.image.drawPixmap(pixmap, n3 - 1, n2 - 1, 1, 1, n7 + n5, n6 + n4, 1, 1);
            pixmapPacker$Page.image.drawPixmap(pixmap, 0, 0, n3, 1, n7, n6 - 1, n5, 1);
            pixmapPacker$Page.image.drawPixmap(pixmap, 0, n2 - 1, n3, 1, n7, n6 + n4, n5, 1);
            pixmapPacker$Page.image.drawPixmap(pixmap, 0, 0, 1, n2, n7 - 1, n6, 1, n4);
            pixmapPacker$Page.image.drawPixmap(pixmap, n3 - 1, 0, 1, n2, n7 + n5, n6, 1, n4);
        }
        if (pixmap2 != null) {
            pixmap2.dispose();
        }
        pixmapPacker$PixmapPackerRectangle.page = pixmapPacker$Page;
        return pixmapPacker$PixmapPackerRectangle;
    }

    public Array getPages() {
        return this.pages;
    }

    public synchronized PixmapPacker$PixmapPackerRectangle getRect(String string) {
        Array$ArrayIterator array$ArrayIterator = this.pages.iterator();
        while (array$ArrayIterator.hasNext()) {
            PixmapPacker$PixmapPackerRectangle pixmapPacker$PixmapPackerRectangle = (PixmapPacker$PixmapPackerRectangle)((PixmapPacker$Page)array$ArrayIterator.next()).rects.get(string);
            if (pixmapPacker$PixmapPackerRectangle == null) continue;
            return pixmapPacker$PixmapPackerRectangle;
        }
        return null;
    }

    public synchronized PixmapPacker$Page getPage(String string) {
        for (PixmapPacker$Page pixmapPacker$Page : this.pages) {
            if (pixmapPacker$Page.rects.get(string) == null) continue;
            return pixmapPacker$Page;
        }
        return null;
    }

    public synchronized int getPageIndex(String string) {
        for (int i2 = 0; i2 < this.pages.size; ++i2) {
            if (((PixmapPacker$Page)this.pages.get((int)i2)).rects.get(string) == null) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public synchronized void dispose() {
        for (PixmapPacker$Page pixmapPacker$Page : this.pages) {
            if (pixmapPacker$Page.texture != null) continue;
            pixmapPacker$Page.image.dispose();
        }
        this.disposed = true;
    }

    public synchronized TextureAtlas generateTextureAtlas(Texture$TextureFilter texture$TextureFilter, Texture$TextureFilter texture$TextureFilter2, boolean bl2) {
        TextureAtlas textureAtlas = new TextureAtlas();
        this.updateTextureAtlas(textureAtlas, texture$TextureFilter, texture$TextureFilter2, bl2);
        return textureAtlas;
    }

    public synchronized void updateTextureAtlas(TextureAtlas textureAtlas, Texture$TextureFilter texture$TextureFilter, Texture$TextureFilter texture$TextureFilter2, boolean bl2) {
        this.updateTextureAtlas(textureAtlas, texture$TextureFilter, texture$TextureFilter2, bl2, true);
    }

    public synchronized void updateTextureAtlas(TextureAtlas textureAtlas, Texture$TextureFilter object, Texture$TextureFilter object22, boolean bl2, boolean bl3) {
        this.updatePageTextures((Texture$TextureFilter)((Object)object), (Texture$TextureFilter)((Object)object22), bl2);
        for (Object object22 : this.pages) {
            if (((PixmapPacker$Page)object22).addedRects.size <= 0) continue;
            for (String string : ((PixmapPacker$Page)object22).addedRects) {
                Matcher matcher;
                PixmapPacker$PixmapPackerRectangle pixmapPacker$PixmapPackerRectangle = (PixmapPacker$PixmapPackerRectangle)((PixmapPacker$Page)object22).rects.get(string);
                TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = new TextureAtlas$AtlasRegion(((PixmapPacker$Page)object22).texture, pixmapPacker$PixmapPackerRectangle.getX(), pixmapPacker$PixmapPackerRectangle.getY(), pixmapPacker$PixmapPackerRectangle.getWidth(), pixmapPacker$PixmapPackerRectangle.getHeight());
                if (pixmapPacker$PixmapPackerRectangle.splits != null) {
                    textureAtlas$AtlasRegion.names = new String[]{"split", "pad"};
                    textureAtlas$AtlasRegion.values = new int[][]{pixmapPacker$PixmapPackerRectangle.splits, pixmapPacker$PixmapPackerRectangle.pads};
                }
                int n2 = -1;
                if (bl3 && (matcher = indexPattern.matcher(string)).matches()) {
                    string = matcher.group(1);
                    n2 = Integer.parseInt(matcher.group(2));
                }
                textureAtlas$AtlasRegion.name = string;
                textureAtlas$AtlasRegion.index = n2;
                textureAtlas$AtlasRegion.offsetX = pixmapPacker$PixmapPackerRectangle.offsetX;
                textureAtlas$AtlasRegion.offsetY = pixmapPacker$PixmapPackerRectangle.originalHeight - pixmapPacker$PixmapPackerRectangle.getHeight() - pixmapPacker$PixmapPackerRectangle.offsetY;
                textureAtlas$AtlasRegion.originalWidth = pixmapPacker$PixmapPackerRectangle.originalWidth;
                textureAtlas$AtlasRegion.originalHeight = pixmapPacker$PixmapPackerRectangle.originalHeight;
                textureAtlas.getRegions().add(textureAtlas$AtlasRegion);
            }
            ((PixmapPacker$Page)object22).addedRects.clear();
            textureAtlas.getTextures().add(((PixmapPacker$Page)object22).texture);
        }
    }

    public synchronized void updateTextureRegions(Array array, Texture$TextureFilter texture$TextureFilter, Texture$TextureFilter texture$TextureFilter2, boolean bl2) {
        this.updatePageTextures(texture$TextureFilter, texture$TextureFilter2, bl2);
        while (array.size < this.pages.size) {
            array.add(new TextureRegion(((PixmapPacker$Page)this.pages.get((int)array.size)).texture));
        }
    }

    public synchronized void updatePageTextures(Texture$TextureFilter texture$TextureFilter, Texture$TextureFilter texture$TextureFilter2, boolean bl2) {
        Array$ArrayIterator array$ArrayIterator = this.pages.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((PixmapPacker$Page)array$ArrayIterator.next()).updateTexture(texture$TextureFilter, texture$TextureFilter2, bl2);
        }
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int n2) {
        this.pageWidth = n2;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int n2) {
        this.pageHeight = n2;
    }

    public Pixmap$Format getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(Pixmap$Format pixmap$Format) {
        this.pageFormat = pixmap$Format;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n2) {
        this.padding = n2;
    }

    public boolean getDuplicateBorder() {
        return this.duplicateBorder;
    }

    public void setDuplicateBorder(boolean bl2) {
        this.duplicateBorder = bl2;
    }

    public boolean getPackToTexture() {
        return this.packToTexture;
    }

    public void setPackToTexture(boolean bl2) {
        this.packToTexture = bl2;
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public void setTransparentColor(Color color) {
        this.transparentColor.set(color);
    }

    private int[] getSplits(Pixmap pixmap) {
        int n2 = this.getSplitPoint(pixmap, 1, 0, true, true);
        int n3 = this.getSplitPoint(pixmap, n2, 0, false, true);
        int n4 = this.getSplitPoint(pixmap, 0, 1, true, false);
        int n5 = this.getSplitPoint(pixmap, 0, n4, false, false);
        this.getSplitPoint(pixmap, n3 + 1, 0, true, true);
        this.getSplitPoint(pixmap, 0, n5 + 1, true, false);
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0) {
            return null;
        }
        if (n2 != 0) {
            --n2;
            n3 = pixmap.getWidth() - 2 - (n3 - 1);
        } else {
            n3 = pixmap.getWidth() - 2;
        }
        n5 = n4 != 0 ? pixmap.getHeight() - 2 - (n5 - 1) : pixmap.getHeight() - 2;
        return new int[]{n2, n3, --n4, n5};
    }

    private int[] getPads(Pixmap object, int[] nArray) {
        int n2 = ((Pixmap)object).getHeight() - 1;
        int n3 = ((Pixmap)object).getWidth() - 1;
        int n4 = this.getSplitPoint((Pixmap)object, 1, n2, true, true);
        int n5 = this.getSplitPoint((Pixmap)object, n3, 1, true, false);
        int n6 = 0;
        int n7 = 0;
        if (n4 != 0) {
            n6 = this.getSplitPoint((Pixmap)object, n4 + 1, n2, false, true);
        }
        if (n5 != 0) {
            n7 = this.getSplitPoint((Pixmap)object, n3, n5 + 1, false, false);
        }
        this.getSplitPoint((Pixmap)object, n6 + 1, n2, true, true);
        this.getSplitPoint((Pixmap)object, n3, n7 + 1, true, false);
        if (n4 == 0 && n6 == 0 && n5 == 0 && n7 == 0) {
            return null;
        }
        if (n4 == 0 && n6 == 0) {
            n4 = -1;
            n6 = -1;
        } else if (n4 > 0) {
            --n4;
            n6 = ((Pixmap)object).getWidth() - 2 - (n6 - 1);
        } else {
            n6 = ((Pixmap)object).getWidth() - 2;
        }
        if (n5 == 0 && n7 == 0) {
            n5 = -1;
            n7 = -1;
        } else {
            n7 = n5 > 0 ? ((Pixmap)object).getHeight() - 2 - (n7 - 1) : ((Pixmap)object).getHeight() - 2;
        }
        object = new int[]{n4, n6, --n5, n7};
        if (nArray != null && Arrays.equals((int[])object, nArray)) {
            return null;
        }
        return object;
    }

    private int getSplitPoint(Pixmap pixmap, int n2, int n3, boolean bl2, boolean bl3) {
        int n4;
        int[] nArray = new int[4];
        int n5 = bl3 ? pixmap.getWidth() : pixmap.getHeight();
        int n6 = n4 = bl2 ? 255 : 0;
        for (int i2 = bl3 ? n2 : n3; i2 != n5; ++i2) {
            if (bl3) {
                n2 = i2;
            } else {
                n3 = i2;
            }
            int n7 = pixmap.getPixel(n2, n3);
            this.c.set(n7);
            nArray[0] = (int)(this.c.r * 255.0f);
            nArray[1] = (int)(this.c.g * 255.0f);
            nArray[2] = (int)(this.c.b * 255.0f);
            nArray[3] = (int)(this.c.a * 255.0f);
            if (nArray[3] == n4) {
                return i2;
            }
            if (bl2 || nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 255) continue;
            System.out.println(n2 + "  " + n3 + " " + nArray + " ");
        }
        return 0;
    }
}

