/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter$RangedNumericValue;
import com.badlogic.gdx.math.MathUtils;
import java.io.BufferedReader;
import java.io.Writer;
import java.util.Arrays;

public class ParticleEmitter$ScaledNumericValue
extends ParticleEmitter$RangedNumericValue {
    private float[] scaling = new float[]{1.0f};
    float[] timeline = new float[]{0.0f};
    private float highMin;
    private float highMax;
    boolean relative;

    public float newHighValue() {
        return this.highMin + (this.highMax - this.highMin) * MathUtils.random();
    }

    public void setHigh(float f2) {
        this.highMin = f2;
        this.highMax = f2;
    }

    public void setHigh(float f2, float f3) {
        this.highMin = f2;
        this.highMax = f3;
    }

    public float getHighMin() {
        return this.highMin;
    }

    public void setHighMin(float f2) {
        this.highMin = f2;
    }

    public float getHighMax() {
        return this.highMax;
    }

    public void setHighMax(float f2) {
        this.highMax = f2;
    }

    @Override
    public void scale(float f2) {
        super.scale(f2);
        this.highMin *= f2;
        this.highMax *= f2;
    }

    @Override
    public void set(ParticleEmitter$RangedNumericValue particleEmitter$RangedNumericValue) {
        if (particleEmitter$RangedNumericValue instanceof ParticleEmitter$ScaledNumericValue) {
            this.set((ParticleEmitter$ScaledNumericValue)particleEmitter$RangedNumericValue);
            return;
        }
        super.set(particleEmitter$RangedNumericValue);
    }

    public void set(ParticleEmitter$ScaledNumericValue particleEmitter$ScaledNumericValue) {
        super.set(particleEmitter$ScaledNumericValue);
        this.highMin = particleEmitter$ScaledNumericValue.highMin;
        this.highMax = particleEmitter$ScaledNumericValue.highMax;
        if (this.scaling.length != particleEmitter$ScaledNumericValue.scaling.length) {
            this.scaling = Arrays.copyOf(particleEmitter$ScaledNumericValue.scaling, particleEmitter$ScaledNumericValue.scaling.length);
        } else {
            System.arraycopy(particleEmitter$ScaledNumericValue.scaling, 0, this.scaling, 0, this.scaling.length);
        }
        if (this.timeline.length != particleEmitter$ScaledNumericValue.timeline.length) {
            this.timeline = Arrays.copyOf(particleEmitter$ScaledNumericValue.timeline, particleEmitter$ScaledNumericValue.timeline.length);
        } else {
            System.arraycopy(particleEmitter$ScaledNumericValue.timeline, 0, this.timeline, 0, this.timeline.length);
        }
        this.relative = particleEmitter$ScaledNumericValue.relative;
    }

    public float[] getScaling() {
        return this.scaling;
    }

    public void setScaling(float[] fArray) {
        this.scaling = fArray;
    }

    public float[] getTimeline() {
        return this.timeline;
    }

    public void setTimeline(float[] fArray) {
        this.timeline = fArray;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setRelative(boolean bl2) {
        this.relative = bl2;
    }

    public float getScale(float f2) {
        int n2 = -1;
        float[] fArray = this.timeline;
        int n3 = this.timeline.length;
        for (int i2 = 1; i2 < n3; ++i2) {
            if (!(fArray[i2] > f2)) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return this.scaling[n3 - 1];
        }
        float[] fArray2 = this.scaling;
        int n4 = n2 - 1;
        float f3 = fArray2[n4];
        float f4 = fArray[n4];
        return f3 + (fArray2[n2] - f3) * ((f2 - f4) / (fArray[n2] - f4));
    }

    @Override
    public void save(Writer writer) {
        int n2;
        super.save(writer);
        if (!this.active) {
            return;
        }
        writer.write("highMin: " + this.highMin + "\n");
        writer.write("highMax: " + this.highMax + "\n");
        writer.write("relative: " + this.relative + "\n");
        writer.write("scalingCount: " + this.scaling.length + "\n");
        for (n2 = 0; n2 < this.scaling.length; ++n2) {
            writer.write("scaling" + n2 + ": " + this.scaling[n2] + "\n");
        }
        writer.write("timelineCount: " + this.timeline.length + "\n");
        for (n2 = 0; n2 < this.timeline.length; ++n2) {
            writer.write("timeline" + n2 + ": " + this.timeline[n2] + "\n");
        }
    }

    @Override
    public void load(BufferedReader bufferedReader) {
        int n2;
        super.load(bufferedReader);
        if (!this.active) {
            return;
        }
        this.highMin = ParticleEmitter.readFloat(bufferedReader, "highMin");
        this.highMax = ParticleEmitter.readFloat(bufferedReader, "highMax");
        this.relative = ParticleEmitter.readBoolean(bufferedReader, "relative");
        this.scaling = new float[ParticleEmitter.readInt(bufferedReader, "scalingCount")];
        for (n2 = 0; n2 < this.scaling.length; ++n2) {
            this.scaling[n2] = ParticleEmitter.readFloat(bufferedReader, "scaling".concat(String.valueOf(n2)));
        }
        this.timeline = new float[ParticleEmitter.readInt(bufferedReader, "timelineCount")];
        for (n2 = 0; n2 < this.timeline.length; ++n2) {
            this.timeline[n2] = ParticleEmitter.readFloat(bufferedReader, "timeline".concat(String.valueOf(n2)));
        }
    }

    public void load(ParticleEmitter$ScaledNumericValue particleEmitter$ScaledNumericValue) {
        super.load(particleEmitter$ScaledNumericValue);
        this.highMax = particleEmitter$ScaledNumericValue.highMax;
        this.highMin = particleEmitter$ScaledNumericValue.highMin;
        this.scaling = new float[particleEmitter$ScaledNumericValue.scaling.length];
        System.arraycopy(particleEmitter$ScaledNumericValue.scaling, 0, this.scaling, 0, this.scaling.length);
        this.timeline = new float[particleEmitter$ScaledNumericValue.timeline.length];
        System.arraycopy(particleEmitter$ScaledNumericValue.timeline, 0, this.timeline, 0, this.timeline.length);
        this.relative = particleEmitter$ScaledNumericValue.relative;
    }
}

