/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.d.a;
import com.badlogic.gdx.graphics.Texture$TextureFilter;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFont$BitmapFontData;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.b;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;

public class DistanceFieldFont
extends BitmapFont {
    private float distanceFieldSmoothing;

    public DistanceFieldFont(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, Array array, boolean bl2) {
        super(bitmapFont$BitmapFontData, array, bl2);
    }

    public DistanceFieldFont(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, TextureRegion textureRegion, boolean bl2) {
        super(bitmapFont$BitmapFontData, textureRegion, bl2);
    }

    public DistanceFieldFont(a a2, boolean bl2) {
        super(a2, bl2);
    }

    public DistanceFieldFont(a a2, a a3, boolean bl2, boolean bl3) {
        super(a2, a3, bl2, bl3);
    }

    public DistanceFieldFont(a a2, a a3, boolean bl2) {
        super(a2, a3, bl2);
    }

    public DistanceFieldFont(a a2, TextureRegion textureRegion, boolean bl2) {
        super(a2, textureRegion, bl2);
    }

    public DistanceFieldFont(a a2, TextureRegion textureRegion) {
        super(a2, textureRegion);
    }

    public DistanceFieldFont(a a2) {
        super(a2);
    }

    @Override
    protected void load(BitmapFont$BitmapFontData object) {
        super.load((BitmapFont$BitmapFontData)object);
        object = this.getRegions().iterator();
        while (object.hasNext()) {
            Texture$TextureFilter texture$TextureFilter = Texture$TextureFilter.Linear;
            ((TextureRegion)object.next()).getTexture().setFilter(texture$TextureFilter, texture$TextureFilter);
        }
    }

    @Override
    public BitmapFontCache newFontCache() {
        DistanceFieldFont distanceFieldFont = this;
        return new b(distanceFieldFont, distanceFieldFont.integer);
    }

    public float getDistanceFieldSmoothing() {
        return this.distanceFieldSmoothing;
    }

    public void setDistanceFieldSmoothing(float f2) {
        this.distanceFieldSmoothing = f2;
    }

    public static ShaderProgram createDistanceFieldShader() {
        Object object = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tv_color = a_color;\n\tv_color.a = v_color.a * (255.0/254.0);\n\tv_texCoords = a_texCoord0;\n\tgl_Position =  u_projTrans * a_position;\n}\n";
        String string = "#ifdef GL_ES\n\tprecision mediump float;\n\tprecision mediump int;\n#endif\n\nuniform sampler2D u_texture;\nuniform float u_smoothing;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tif (u_smoothing > 0.0) {\n\t\tfloat smoothing = 0.25 / u_smoothing;\n\t\tfloat distance = texture2D(u_texture, v_texCoords).a;\n\t\tfloat alpha = smoothstep(0.5 - smoothing, 0.5 + smoothing, distance);\n\t\tgl_FragColor = vec4(v_color.rgb, alpha * v_color.a);\n\t} else {\n\t\tgl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n\t}\n}\n";
        if (!((ShaderProgram)(object = new ShaderProgram((String)object, string))).isCompiled()) {
            throw new IllegalArgumentException("Error compiling distance field shader: " + ((ShaderProgram)object).getLog());
        }
        return object;
    }
}

