/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class CpuSpriteBatch
extends SpriteBatch {
    private final Matrix4 virtualMatrix = new Matrix4();
    private final Affine2 adjustAffine = new Affine2();
    private boolean adjustNeeded;
    private boolean haveIdentityRealMatrix = true;
    private final Affine2 tmpAffine = new Affine2();

    public CpuSpriteBatch() {
        this(1000);
    }

    public CpuSpriteBatch(int n2) {
        this(n2, null);
    }

    public CpuSpriteBatch(int n2, ShaderProgram shaderProgram) {
        super(n2, shaderProgram);
    }

    public void flushAndSyncTransformMatrix() {
        this.flush();
        if (this.adjustNeeded) {
            this.haveIdentityRealMatrix = CpuSpriteBatch.checkIdt(this.virtualMatrix);
            if (!this.haveIdentityRealMatrix && this.virtualMatrix.det() == 0.0f) {
                throw new GdxRuntimeException("Transform matrix is singular, can't sync");
            }
            this.adjustNeeded = false;
            CpuSpriteBatch cpuSpriteBatch = this;
            super.setTransformMatrix(cpuSpriteBatch.virtualMatrix);
        }
    }

    @Override
    public Matrix4 getTransformMatrix() {
        if (this.adjustNeeded) {
            return this.virtualMatrix;
        }
        return super.getTransformMatrix();
    }

    @Override
    public void setTransformMatrix(Matrix4 matrix4) {
        Matrix4 matrix42 = super.getTransformMatrix();
        if (CpuSpriteBatch.checkEqual(matrix42, matrix4)) {
            this.adjustNeeded = false;
            return;
        }
        if (this.isDrawing()) {
            this.virtualMatrix.setAsAffine(matrix4);
            this.adjustNeeded = true;
            if (this.haveIdentityRealMatrix) {
                this.adjustAffine.set(matrix4);
                return;
            }
            this.tmpAffine.set(matrix4);
            this.adjustAffine.set(matrix42).inv().mul(this.tmpAffine);
            return;
        }
        matrix42.setAsAffine(matrix4);
        this.haveIdentityRealMatrix = CpuSpriteBatch.checkIdt(matrix42);
    }

    public void setTransformMatrix(Affine2 affine2) {
        Matrix4 matrix4 = super.getTransformMatrix();
        if (CpuSpriteBatch.checkEqual(matrix4, affine2)) {
            this.adjustNeeded = false;
            return;
        }
        this.virtualMatrix.setAsAffine(affine2);
        if (this.isDrawing()) {
            this.adjustNeeded = true;
            if (this.haveIdentityRealMatrix) {
                this.adjustAffine.set(affine2);
                return;
            }
            this.adjustAffine.set(matrix4).inv().mul(affine2);
            return;
        }
        matrix4.setAsAffine(affine2);
        this.haveIdentityRealMatrix = CpuSpriteBatch.checkIdt(matrix4);
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        if (!this.adjustNeeded) {
            super.draw(texture, f2, f3, f4, f5, f6, f7, f8, f9, f10, n2, n3, n4, n5, bl2, bl3);
            return;
        }
        this.drawAdjusted(texture, f2, f3, f4, f5, f6, f7, f8, f9, f10, n2, n3, n4, n5, bl2, bl3);
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        if (!this.adjustNeeded) {
            super.draw(texture, f2, f3, f4, f5, n2, n3, n4, n5, bl2, bl3);
            return;
        }
        this.drawAdjusted(texture, f2, f3, 0.0f, 0.0f, f4, f5, 1.0f, 1.0f, 0.0f, n2, n3, n4, n5, bl2, bl3);
    }

    @Override
    public void draw(Texture texture, float f2, float f3, int n2, int n3, int n4, int n5) {
        if (!this.adjustNeeded) {
            super.draw(texture, f2, f3, n2, n3, n4, n5);
            return;
        }
        this.drawAdjusted(texture, f2, f3, 0.0f, 0.0f, n4, n5, 1.0f, 1.0f, 0.0f, n2, n3, n4, n5, false, false);
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (!this.adjustNeeded) {
            super.draw(texture, f2, f3, f4, f5, f6, f7, f8, f9);
            return;
        }
        this.drawAdjustedUV(texture, f2, f3, 0.0f, 0.0f, f4, f5, 1.0f, 1.0f, 0.0f, f6, f7, f8, f9, false, false);
    }

    @Override
    public void draw(Texture texture, float f2, float f3) {
        if (!this.adjustNeeded) {
            super.draw(texture, f2, f3);
            return;
        }
        this.drawAdjusted(texture, f2, f3, 0.0f, 0.0f, ((GLTexture)texture).getWidth(), ((GLTexture)texture).getHeight(), 1.0f, 1.0f, 0.0f, 0, 1, 1, 0, false, false);
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5) {
        if (!this.adjustNeeded) {
            super.draw(texture, f2, f3, f4, f5);
            return;
        }
        this.drawAdjusted(texture, f2, f3, 0.0f, 0.0f, f4, f5, 1.0f, 1.0f, 0.0f, 0, 1, 1, 0, false, false);
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f2, f3);
            return;
        }
        this.drawAdjusted(textureRegion, f2, f3, 0.0f, 0.0f, textureRegion.getRegionWidth(), textureRegion.getRegionHeight(), 1.0f, 1.0f, 0.0f);
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, float f4, float f5) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f2, f3, f4, f5);
            return;
        }
        this.drawAdjusted(textureRegion, f2, f3, 0.0f, 0.0f, f4, f5, 1.0f, 1.0f, 0.0f);
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f2, f3, f4, f5, f6, f7, f8, f9, f10);
            return;
        }
        this.drawAdjusted(textureRegion, f2, f3, f4, f5, f6, f7, f8, f9, f10);
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl2) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f2, f3, f4, f5, f6, f7, f8, f9, f10, bl2);
            return;
        }
        this.drawAdjusted(textureRegion, f2, f3, f4, f5, f6, f7, f8, f9, f10, bl2);
    }

    @Override
    public void draw(Texture texture, float[] fArray, int n2, int n3) {
        if (n3 % 20 != 0) {
            throw new GdxRuntimeException("invalid vertex count");
        }
        if (!this.adjustNeeded) {
            super.draw(texture, fArray, n2, n3);
            return;
        }
        this.drawAdjusted(texture, fArray, n2, n3);
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, Affine2 affine2) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f2, f3, affine2);
            return;
        }
        this.drawAdjusted(textureRegion, f2, f3, affine2);
    }

    private void drawAdjusted(TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.drawAdjustedUV(textureRegion.texture, f2, f3, f4, f5, f6, f7, f8, f9, f10, textureRegion.u, textureRegion.v2, textureRegion.u2, textureRegion.v, false, false);
    }

    private void drawAdjusted(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        float f11 = 1.0f / (float)((GLTexture)texture).getWidth();
        float f12 = 1.0f / (float)((GLTexture)texture).getHeight();
        float f13 = (float)n2 * f11;
        float f14 = (float)(n3 + n5) * f12;
        float f15 = (float)(n2 + n4) * f11;
        float f16 = (float)n3 * f12;
        this.drawAdjustedUV(texture, f2, f3, f4, f5, f6, f7, f8, f9, f10, f13, f14, f15, f16, bl2, bl3);
    }

    private void drawAdjustedUV(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, boolean bl2, boolean bl3) {
        if (!this.drawing) {
            throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
        }
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == this.vertices.length) {
            super.flush();
        }
        float f15 = f2 + f4;
        f2 = f3 + f5;
        f3 = -f4;
        float f16 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f3 *= f8;
            f16 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f3;
        f7 = f16;
        f8 = f5;
        f9 = f4;
        if (f10 != 0.0f) {
            f16 = MathUtils.cosDeg(f10);
            f4 = MathUtils.sinDeg(f10);
            f10 = f16 * f6 - f4 * f7;
            f6 = f4 * f6 + f16 * f7;
            f7 = f16 * f3 - f4 * f8;
            f3 = f4 * f3 + f16 * f8;
            f8 = f16 * f9 - f4 * f5;
            f5 = f4 * f9 + f16 * f5;
            f4 = f10 + (f8 - f7);
            f9 = f5 - (f3 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f3;
            f3 = f8;
            f8 = f9;
            f9 = f16;
        }
        f10 += f15;
        f6 += f2;
        f7 += f15;
        f3 += f2;
        f8 += f15;
        f5 += f2;
        f4 += f15;
        f9 += f2;
        if (bl2) {
            f16 = f11;
            f11 = f13;
            f13 = f16;
        }
        if (bl3) {
            f16 = f12;
            f12 = f14;
            f14 = f16;
        }
        Affine2 affine2 = this.adjustAffine;
        this.vertices[this.idx] = affine2.m00 * f10 + affine2.m01 * f6 + affine2.m02;
        this.vertices[this.idx + 1] = affine2.m10 * f10 + affine2.m11 * f6 + affine2.m12;
        this.vertices[this.idx + 2] = this.colorPacked;
        this.vertices[this.idx + 3] = f11;
        this.vertices[this.idx + 4] = f12;
        this.vertices[this.idx + 5] = affine2.m00 * f7 + affine2.m01 * f3 + affine2.m02;
        this.vertices[this.idx + 6] = affine2.m10 * f7 + affine2.m11 * f3 + affine2.m12;
        this.vertices[this.idx + 7] = this.colorPacked;
        this.vertices[this.idx + 8] = f11;
        this.vertices[this.idx + 9] = f14;
        this.vertices[this.idx + 10] = affine2.m00 * f8 + affine2.m01 * f5 + affine2.m02;
        this.vertices[this.idx + 11] = affine2.m10 * f8 + affine2.m11 * f5 + affine2.m12;
        this.vertices[this.idx + 12] = this.colorPacked;
        this.vertices[this.idx + 13] = f13;
        this.vertices[this.idx + 14] = f14;
        this.vertices[this.idx + 15] = affine2.m00 * f4 + affine2.m01 * f9 + affine2.m02;
        this.vertices[this.idx + 16] = affine2.m10 * f4 + affine2.m11 * f9 + affine2.m12;
        this.vertices[this.idx + 17] = this.colorPacked;
        this.vertices[this.idx + 18] = f13;
        this.vertices[this.idx + 19] = f12;
        this.idx += 20;
    }

    private void drawAdjusted(TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl2) {
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        if (!this.drawing) {
            throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
        }
        if (textureRegion.texture != this.lastTexture) {
            this.switchTexture(textureRegion.texture);
        } else if (this.idx == this.vertices.length) {
            super.flush();
        }
        f2 += f4;
        f3 += f5;
        float f16 = -f4;
        float f17 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f16 *= f8;
            f17 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f16;
        f7 = f17;
        f8 = f16;
        f9 = f5;
        f16 = f4;
        if (f10 != 0.0f) {
            f17 = MathUtils.cosDeg(f10);
            f15 = MathUtils.sinDeg(f10);
            f10 = f17 * f6 - f15 * f7;
            f6 = f15 * f6 + f17 * f7;
            f7 = f17 * f8 - f15 * f9;
            f8 = f15 * f8 + f17 * f9;
            f9 = f17 * f16 - f15 * f5;
            f5 = f15 * f16 + f17 * f5;
            f4 = f10 + (f9 - f7);
            f16 = f5 - (f8 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f8;
            f8 = f9;
            f9 = f16;
            f16 = f17;
        }
        f10 += f2;
        f6 += f3;
        f7 += f2;
        f8 += f3;
        f9 += f2;
        f5 += f3;
        f4 += f2;
        f16 += f3;
        if (bl2) {
            f17 = textureRegion.u2;
            f15 = textureRegion.v2;
            f2 = textureRegion.u;
            f3 = textureRegion.v2;
            f14 = textureRegion.u;
            f13 = textureRegion.v;
            f12 = textureRegion.u2;
            f11 = textureRegion.v;
        } else {
            f17 = textureRegion.u;
            f15 = textureRegion.v;
            f2 = textureRegion.u2;
            f3 = textureRegion.v;
            f14 = textureRegion.u2;
            f13 = textureRegion.v2;
            f12 = textureRegion.u;
            f11 = textureRegion.v2;
        }
        Affine2 affine2 = this.adjustAffine;
        this.vertices[this.idx] = affine2.m00 * f10 + affine2.m01 * f6 + affine2.m02;
        this.vertices[this.idx + 1] = affine2.m10 * f10 + affine2.m11 * f6 + affine2.m12;
        this.vertices[this.idx + 2] = this.colorPacked;
        this.vertices[this.idx + 3] = f17;
        this.vertices[this.idx + 4] = f15;
        this.vertices[this.idx + 5] = affine2.m00 * f7 + affine2.m01 * f8 + affine2.m02;
        this.vertices[this.idx + 6] = affine2.m10 * f7 + affine2.m11 * f8 + affine2.m12;
        this.vertices[this.idx + 7] = this.colorPacked;
        this.vertices[this.idx + 8] = f2;
        this.vertices[this.idx + 9] = f3;
        this.vertices[this.idx + 10] = affine2.m00 * f9 + affine2.m01 * f5 + affine2.m02;
        this.vertices[this.idx + 11] = affine2.m10 * f9 + affine2.m11 * f5 + affine2.m12;
        this.vertices[this.idx + 12] = this.colorPacked;
        this.vertices[this.idx + 13] = f14;
        this.vertices[this.idx + 14] = f13;
        this.vertices[this.idx + 15] = affine2.m00 * f4 + affine2.m01 * f16 + affine2.m02;
        this.vertices[this.idx + 16] = affine2.m10 * f4 + affine2.m11 * f16 + affine2.m12;
        this.vertices[this.idx + 17] = this.colorPacked;
        this.vertices[this.idx + 18] = f12;
        this.vertices[this.idx + 19] = f11;
        this.idx += 20;
    }

    private void drawAdjusted(TextureRegion textureRegion, float f2, float f3, Affine2 affine2) {
        if (!this.drawing) {
            throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
        }
        if (textureRegion.texture != this.lastTexture) {
            this.switchTexture(textureRegion.texture);
        } else if (this.idx == this.vertices.length) {
            super.flush();
        }
        float f4 = affine2.m02;
        float f5 = affine2.m12;
        float f6 = affine2.m01 * f3 + affine2.m02;
        float f7 = affine2.m11 * f3 + affine2.m12;
        float f8 = affine2.m00 * f2 + affine2.m01 * f3 + affine2.m02;
        f3 = affine2.m10 * f2 + affine2.m11 * f3 + affine2.m12;
        float f9 = affine2.m00 * f2 + affine2.m02;
        f2 = affine2.m10 * f2 + affine2.m12;
        float f10 = textureRegion.u;
        float f11 = textureRegion.v2;
        float f12 = textureRegion.u2;
        float f13 = textureRegion.v;
        affine2 = this.adjustAffine;
        this.vertices[this.idx] = affine2.m00 * f4 + affine2.m01 * f5 + affine2.m02;
        this.vertices[this.idx + 1] = affine2.m10 * f4 + affine2.m11 * f5 + affine2.m12;
        this.vertices[this.idx + 2] = this.colorPacked;
        this.vertices[this.idx + 3] = f10;
        this.vertices[this.idx + 4] = f11;
        this.vertices[this.idx + 5] = affine2.m00 * f6 + affine2.m01 * f7 + affine2.m02;
        this.vertices[this.idx + 6] = affine2.m10 * f6 + affine2.m11 * f7 + affine2.m12;
        this.vertices[this.idx + 7] = this.colorPacked;
        this.vertices[this.idx + 8] = f10;
        this.vertices[this.idx + 9] = f13;
        this.vertices[this.idx + 10] = affine2.m00 * f8 + affine2.m01 * f3 + affine2.m02;
        this.vertices[this.idx + 11] = affine2.m10 * f8 + affine2.m11 * f3 + affine2.m12;
        this.vertices[this.idx + 12] = this.colorPacked;
        this.vertices[this.idx + 13] = f12;
        this.vertices[this.idx + 14] = f13;
        this.vertices[this.idx + 15] = affine2.m00 * f9 + affine2.m01 * f2 + affine2.m02;
        this.vertices[this.idx + 16] = affine2.m10 * f9 + affine2.m11 * f2 + affine2.m12;
        this.vertices[this.idx + 17] = this.colorPacked;
        this.vertices[this.idx + 18] = f12;
        this.vertices[this.idx + 19] = f11;
        this.idx += 20;
    }

    private void drawAdjusted(Texture object, float[] fArray, int n2, int n3) {
        if (!this.drawing) {
            throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
        }
        if (object != this.lastTexture) {
            this.switchTexture((Texture)object);
        }
        object = this.adjustAffine;
        int n4 = Math.min(this.vertices.length - this.idx, n3);
        do {
            n3 -= n4;
            while (n4 > 0) {
                float f2 = fArray[n2];
                float f3 = fArray[n2 + 1];
                this.vertices[this.idx] = ((Affine2)object).m00 * f2 + ((Affine2)object).m01 * f3 + ((Affine2)object).m02;
                this.vertices[this.idx + 1] = ((Affine2)object).m10 * f2 + ((Affine2)object).m11 * f3 + ((Affine2)object).m12;
                this.vertices[this.idx + 2] = fArray[n2 + 2];
                this.vertices[this.idx + 3] = fArray[n2 + 3];
                this.vertices[this.idx + 4] = fArray[n2 + 4];
                this.idx += 5;
                n2 += 5;
                n4 -= 5;
            }
            if (n3 <= 0) continue;
            super.flush();
            n4 = Math.min(this.vertices.length, n3);
        } while (n3 > 0);
    }

    private static boolean checkEqual(Matrix4 matrix4, Matrix4 matrix42) {
        if (matrix4 == matrix42) {
            return true;
        }
        return matrix4.val[0] == matrix42.val[0] && matrix4.val[1] == matrix42.val[1] && matrix4.val[4] == matrix42.val[4] && matrix4.val[5] == matrix42.val[5] && matrix4.val[12] == matrix42.val[12] && matrix4.val[13] == matrix42.val[13];
    }

    private static boolean checkEqual(Matrix4 object, Affine2 affine2) {
        float[] fArray = ((Matrix4)object).getValues();
        object = fArray;
        return fArray[0] == affine2.m00 && object[1] == affine2.m10 && object[4] == affine2.m01 && object[5] == affine2.m11 && object[12] == affine2.m02 && object[13] == affine2.m12;
    }

    private static boolean checkIdt(Matrix4 object) {
        float[] fArray = ((Matrix4)object).getValues();
        object = fArray;
        return fArray[0] == 1.0f && object[1] == 0.0f && object[4] == 0.0f && object[5] == 1.0f && object[12] == 0.0f && object[13] == 0.0f;
    }
}

