/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.d.a;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont$Glyph;
import com.badlogic.gdx.graphics.g2d.GlyphLayout$GlyphRun;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$AtlasRegion;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BitmapFont$BitmapFontData {
    public String name;
    public String[] imagePaths;
    public a fontFile;
    public boolean flipped;
    public float padTop;
    public float padRight;
    public float padBottom;
    public float padLeft;
    public float lineHeight;
    public float capHeight = 1.0f;
    public float ascent;
    public float descent;
    public float down;
    public float blankLineScale = 1.0f;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public boolean markupEnabled;
    public float cursorX;
    public final BitmapFont$Glyph[][] glyphs = new BitmapFont$Glyph[128][];
    public BitmapFont$Glyph missingGlyph;
    public float spaceXadvance;
    public float xHeight = 1.0f;
    public char[] breakChars;
    public char[] xChars = new char[]{'x', 'e', 'a', 'o', 'n', 's', 'r', 'c', 'u', 'm', 'v', 'w', 'z'};
    public char[] capChars = new char[]{'M', 'N', 'B', 'D', 'C', 'E', 'F', 'K', 'A', 'G', 'H', 'I', 'J', 'L', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public BitmapFont$BitmapFontData() {
    }

    public BitmapFont$BitmapFontData(a a2, boolean bl2) {
        this.fontFile = a2;
        this.flipped = bl2;
        this.load(a2, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public void load(a a2, boolean bl2) {
        if (this.imagePaths != null) {
            throw new IllegalStateException("Already loaded.");
        }
        this.name = a2.f();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(a2.h()), 512);
        try {
            void var4_23;
            char c2;
            BitmapFont$Glyph bitmapFont$Glyph;
            int n2;
            char c3;
            int n3;
            void var4_20;
            BitmapFont$Glyph bitmapFont$Glyph2;
            BitmapFont$Glyph bitmapFont$Glyph3;
            String string;
            String string2;
            Object object;
            int n4;
            String object3 = bufferedReader.readLine();
            if (object3 == null) {
                throw new GdxRuntimeException("File is empty.");
            }
            String string3 = object3;
            String c22 = string3.substring(string3.indexOf("padding=") + 8);
            String[] exception = c22.substring(0, c22.indexOf(32)).split(",", 4);
            if (exception.length != 4) {
                throw new GdxRuntimeException("Invalid padding.");
            }
            this.padTop = Integer.parseInt(exception[0]);
            this.padRight = Integer.parseInt(exception[1]);
            this.padBottom = Integer.parseInt(exception[2]);
            this.padLeft = Integer.parseInt(exception[3]);
            float f2 = this.padTop + this.padBottom;
            String string4 = bufferedReader.readLine();
            if (string4 == null) {
                throw new GdxRuntimeException("Missing common header.");
            }
            String[] stringArray = string4.split(" ", 9);
            if (stringArray.length < 3) {
                throw new GdxRuntimeException("Invalid common header.");
            }
            if (!stringArray[1].startsWith("lineHeight=")) {
                throw new GdxRuntimeException("Missing: lineHeight");
            }
            this.lineHeight = Integer.parseInt(stringArray[1].substring(11));
            if (!stringArray[2].startsWith("base=")) {
                throw new GdxRuntimeException("Missing: base");
            }
            float f3 = Integer.parseInt(stringArray[2].substring(5));
            int n5 = 1;
            if (stringArray.length >= 6 && stringArray[5] != null && stringArray[5].startsWith("pages=")) {
                try {
                    n5 = Math.max(1, Integer.parseInt(stringArray[5].substring(6)));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.imagePaths = new String[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                String string5;
                String string6 = bufferedReader.readLine();
                if (string6 == null) {
                    throw new GdxRuntimeException("Missing additional page definitions.");
                }
                object = Pattern.compile(".*id=(\\d+)").matcher(string6);
                if (((Matcher)object).find()) {
                    string5 = ((Matcher)object).group(1);
                    try {
                        if (Integer.parseInt(string5) != n4) {
                            throw new GdxRuntimeException("Page IDs must be indices starting at 0: ".concat(String.valueOf(string5)));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new GdxRuntimeException("Invalid page id: ".concat(String.valueOf(string5)), numberFormatException);
                    }
                }
                if (!((Matcher)(object = Pattern.compile(".*file=\"?([^\"]+)\"?").matcher(string6))).find()) {
                    throw new GdxRuntimeException("Missing: file");
                }
                string5 = ((Matcher)object).group(1);
                this.imagePaths[n4] = a2.a().a(string5).c().replaceAll("\\\\", "/");
            }
            this.descent = 0.0f;
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("kernings ") && !string2.startsWith("metrics ")) {
                if (!string2.startsWith("char ")) continue;
                BitmapFont$Glyph bitmapFont$Glyph4 = new BitmapFont$Glyph();
                object = new StringTokenizer(string2, " =");
                ((StringTokenizer)object).nextToken();
                ((StringTokenizer)object).nextToken();
                int n6 = Integer.parseInt(((StringTokenizer)object).nextToken());
                if (n6 <= 0) {
                    this.missingGlyph = bitmapFont$Glyph4;
                } else {
                    if (n6 > 65535) continue;
                    this.setGlyph(n6, bitmapFont$Glyph4);
                }
                bitmapFont$Glyph4.id = n6;
                ((StringTokenizer)object).nextToken();
                bitmapFont$Glyph4.srcX = Integer.parseInt(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                bitmapFont$Glyph4.srcY = Integer.parseInt(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                bitmapFont$Glyph4.width = Integer.parseInt(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                bitmapFont$Glyph4.height = Integer.parseInt(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                bitmapFont$Glyph4.xoffset = Integer.parseInt(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                bitmapFont$Glyph4.yoffset = bl2 ? Integer.parseInt(((StringTokenizer)object).nextToken()) : -(bitmapFont$Glyph4.height + Integer.parseInt(((StringTokenizer)object).nextToken()));
                ((StringTokenizer)object).nextToken();
                bitmapFont$Glyph4.xadvance = Integer.parseInt(((StringTokenizer)object).nextToken());
                if (((StringTokenizer)object).hasMoreTokens()) {
                    ((StringTokenizer)object).nextToken();
                }
                if (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        bitmapFont$Glyph4.page = Integer.parseInt(((StringTokenizer)object).nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (bitmapFont$Glyph4.width <= 0 || bitmapFont$Glyph4.height <= 0) continue;
                this.descent = Math.min(f3 + (float)bitmapFont$Glyph4.yoffset, this.descent);
            }
            this.descent += this.padBottom;
            while ((string = bufferedReader.readLine()) != null && string.startsWith("kerning ")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " =");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                int n7 = Integer.parseInt(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                int n8 = Integer.parseInt(stringTokenizer.nextToken());
                if (n7 < 0 || n7 > 65535 || n8 < 0 || n8 > 65535) continue;
                BitmapFont$Glyph bitmapFont$Glyph5 = this.getGlyph((char)n7);
                stringTokenizer.nextToken();
                n5 = Integer.parseInt(stringTokenizer.nextToken());
                if (bitmapFont$Glyph5 == null) continue;
                bitmapFont$Glyph5.setKerning(n8, n5);
            }
            n4 = 0;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            if (string != null && string.startsWith("metrics ")) {
                n4 = 1;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " =");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                f4 = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                f5 = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                f6 = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                f7 = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                f8 = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                f9 = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                f10 = Float.parseFloat(stringTokenizer.nextToken());
            }
            if ((bitmapFont$Glyph3 = this.getGlyph(' ')) == null) {
                BitmapFont$Glyph bitmapFont$Glyph6 = new BitmapFont$Glyph();
                new BitmapFont$Glyph().id = 32;
                bitmapFont$Glyph2 = this.getGlyph('l');
                if (bitmapFont$Glyph2 == null) {
                    bitmapFont$Glyph2 = this.getFirstGlyph();
                }
                bitmapFont$Glyph6.xadvance = bitmapFont$Glyph2.xadvance;
                this.setGlyph(32, bitmapFont$Glyph6);
            }
            if (var4_20.width == 0) {
                var4_20.width = (int)(this.padLeft + (float)var4_20.xadvance + this.padRight);
                var4_20.xoffset = (int)(-this.padLeft);
            }
            this.spaceXadvance = var4_20.xadvance;
            bitmapFont$Glyph2 = null;
            char[] cArray = this.xChars;
            int n9 = this.xChars.length;
            for (n3 = 0; n3 < n9 && (bitmapFont$Glyph2 = this.getGlyph(c3 = cArray[n3])) == null; ++n3) {
            }
            if (bitmapFont$Glyph2 == null) {
                bitmapFont$Glyph2 = this.getFirstGlyph();
            }
            this.xHeight = (float)bitmapFont$Glyph2.height - f2;
            Object var4_22 = null;
            Object object2 = this.capChars;
            n3 = this.capChars.length;
            for (n2 = 0; n2 < n3 && (bitmapFont$Glyph = this.getGlyph(c2 = object2[n2])) == null; ++n2) {
            }
            if (var4_23 == null) {
                object2 = this.glyphs;
                n3 = this.glyphs.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    char c4 = object2[n2];
                    if (c4 == null) continue;
                    for (void var20_59 : c4) {
                        if (var20_59 == null || var20_59.height == 0 || var20_59.width == 0) continue;
                        this.capHeight = Math.max(this.capHeight, (float)var20_59.height);
                    }
                }
            } else {
                this.capHeight = var4_23.height;
            }
            this.capHeight -= f2;
            this.ascent = f3 - this.capHeight;
            this.down = -this.lineHeight;
            if (bl2) {
                this.ascent = -this.ascent;
                this.down = -this.down;
            }
            if (n4 != 0) {
                this.ascent = f4;
                this.descent = f5;
                this.down = f6;
                this.capHeight = f7;
                this.lineHeight = f8;
                this.spaceXadvance = f9;
                this.xHeight = f10;
            }
            return;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error loading font file: ".concat(String.valueOf(a2)), exception);
        }
        finally {
            StreamUtils.closeQuietly(bufferedReader);
        }
    }

    public void setGlyphRegion(BitmapFont$Glyph bitmapFont$Glyph, TextureRegion textureRegion) {
        Texture texture = textureRegion.getTexture();
        float f2 = 1.0f / (float)((GLTexture)texture).getWidth();
        float f3 = 1.0f / (float)((GLTexture)texture).getHeight();
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = textureRegion.u;
        float f7 = textureRegion.v;
        float f8 = textureRegion.getRegionWidth();
        float f9 = textureRegion.getRegionHeight();
        if (textureRegion instanceof TextureAtlas$AtlasRegion) {
            textureRegion = (TextureAtlas$AtlasRegion)textureRegion;
            f4 = ((TextureAtlas$AtlasRegion)textureRegion).offsetX;
            f5 = (float)(((TextureAtlas$AtlasRegion)textureRegion).originalHeight - ((TextureAtlas$AtlasRegion)textureRegion).packedHeight) - ((TextureAtlas$AtlasRegion)textureRegion).offsetY;
        }
        float f10 = bitmapFont$Glyph.srcX;
        float f11 = bitmapFont$Glyph.srcX + bitmapFont$Glyph.width;
        float f12 = bitmapFont$Glyph.srcY;
        float f13 = bitmapFont$Glyph.srcY + bitmapFont$Glyph.height;
        if (f4 > 0.0f) {
            float f14;
            float f15;
            f10 -= f4;
            if (f15 < 0.0f) {
                bitmapFont$Glyph.width = (int)((float)bitmapFont$Glyph.width + f10);
                bitmapFont$Glyph.xoffset = (int)((float)bitmapFont$Glyph.xoffset - f10);
                f10 = 0.0f;
            }
            f11 -= f4;
            if (f14 > f8) {
                bitmapFont$Glyph.width = (int)((float)bitmapFont$Glyph.width - (f11 - f8));
                f11 = f8;
            }
        }
        if (f5 > 0.0f) {
            float f16;
            float f17;
            f12 -= f5;
            if (f17 < 0.0f) {
                bitmapFont$Glyph.height = (int)((float)bitmapFont$Glyph.height + f12);
                if (bitmapFont$Glyph.height < 0) {
                    bitmapFont$Glyph.height = 0;
                }
                f12 = 0.0f;
            }
            f13 -= f5;
            if (f16 > f9) {
                f4 = f13 - f9;
                bitmapFont$Glyph.height = (int)((float)bitmapFont$Glyph.height - f4);
                bitmapFont$Glyph.yoffset = (int)((float)bitmapFont$Glyph.yoffset + f4);
                f13 = f9;
            }
        }
        bitmapFont$Glyph.u = f6 + f10 * f2;
        bitmapFont$Glyph.u2 = f6 + f11 * f2;
        if (this.flipped) {
            bitmapFont$Glyph.v = f7 + f12 * f3;
            bitmapFont$Glyph.v2 = f7 + f13 * f3;
            return;
        }
        bitmapFont$Glyph.v2 = f7 + f12 * f3;
        bitmapFont$Glyph.v = f7 + f13 * f3;
    }

    public void setLineHeight(float f2) {
        this.lineHeight = f2 * this.scaleY;
        this.down = this.flipped ? this.lineHeight : -this.lineHeight;
    }

    public void setGlyph(int n2, BitmapFont$Glyph bitmapFont$Glyph) {
        BitmapFont$Glyph[] bitmapFont$GlyphArray = this.glyphs[n2 / 512];
        if (bitmapFont$GlyphArray == null) {
            bitmapFont$GlyphArray = new BitmapFont$Glyph[512];
            this.glyphs[n2 / 512] = bitmapFont$GlyphArray;
        }
        bitmapFont$GlyphArray[n2 & 0x1FF] = bitmapFont$Glyph;
    }

    public BitmapFont$Glyph getFirstGlyph() {
        BitmapFont$Glyph[][] bitmapFont$GlyphArray = this.glyphs;
        int n2 = this.glyphs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            BitmapFont$Glyph[] bitmapFont$GlyphArray2 = bitmapFont$GlyphArray[i2];
            if (bitmapFont$GlyphArray2 == null) continue;
            for (BitmapFont$Glyph bitmapFont$Glyph : bitmapFont$GlyphArray2) {
                if (bitmapFont$Glyph == null || bitmapFont$Glyph.height == 0 || bitmapFont$Glyph.width == 0) continue;
                return bitmapFont$Glyph;
            }
        }
        throw new GdxRuntimeException("No glyphs found.");
    }

    public boolean hasGlyph(char c2) {
        if (this.missingGlyph != null) {
            return true;
        }
        return this.getGlyph(c2) != null;
    }

    public BitmapFont$Glyph getGlyph(char c2) {
        BitmapFont$Glyph[] bitmapFont$GlyphArray = this.glyphs[c2 / 512];
        if (bitmapFont$GlyphArray != null) {
            return bitmapFont$GlyphArray[c2 & 0x1FF];
        }
        return null;
    }

    public void getGlyphs(GlyphLayout$GlyphRun glyphLayout$GlyphRun, CharSequence charSequence, int n2, int n3, BitmapFont$Glyph bitmapFont$Glyph) {
        int n4 = n3 - n2;
        if (n4 == 0) {
            return;
        }
        boolean bl2 = this.markupEnabled;
        float f2 = this.scaleX;
        Array array = glyphLayout$GlyphRun.glyphs;
        FloatArray floatArray = glyphLayout$GlyphRun.xAdvances;
        array.ensureCapacity(n4);
        glyphLayout$GlyphRun.xAdvances.ensureCapacity(n4 + 1);
        do {
            char c2;
            if ((c2 = charSequence.charAt(n2++)) == '\r') continue;
            BitmapFont$Glyph bitmapFont$Glyph2 = this.getGlyph(c2);
            if (bitmapFont$Glyph2 == null) {
                if (this.missingGlyph == null) continue;
                bitmapFont$Glyph2 = this.missingGlyph;
            }
            array.add(bitmapFont$Glyph2);
            floatArray.add(bitmapFont$Glyph == null ? (bitmapFont$Glyph2.fixedWidth ? 0.0f : (float)(-bitmapFont$Glyph2.xoffset) * f2 - this.padLeft) : (float)(bitmapFont$Glyph.xadvance + bitmapFont$Glyph.getKerning(c2)) * f2);
            bitmapFont$Glyph = bitmapFont$Glyph2;
            if (!bl2 || c2 != '[' || n2 >= n3 || charSequence.charAt(n2) != '[') continue;
            ++n2;
        } while (n2 < n3);
        if (bitmapFont$Glyph != null) {
            float f3 = bitmapFont$Glyph.fixedWidth ? (float)bitmapFont$Glyph.xadvance * f2 : (float)(bitmapFont$Glyph.width + bitmapFont$Glyph.xoffset) * f2 - this.padRight;
            floatArray.add(f3);
        }
    }

    public int getWrapIndex(Array objectArray, int n2) {
        objectArray = objectArray.items;
        char c2 = (char)((BitmapFont$Glyph)objectArray.items[--n2]).id;
        if (this.isWhitespace(c2)) {
            return n2;
        }
        if (this.isBreakChar(c2)) {
            --n2;
        }
        while (n2 > 0) {
            c2 = (char)((BitmapFont$Glyph)objectArray[n2]).id;
            if (this.isWhitespace(c2) || this.isBreakChar(c2)) {
                return n2 + 1;
            }
            --n2;
        }
        return 0;
    }

    public boolean isBreakChar(char c2) {
        if (this.breakChars == null) {
            return false;
        }
        char[] cArray = this.breakChars;
        int n2 = this.breakChars.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = cArray[i2];
            if (c2 != c3) continue;
            return true;
        }
        return false;
    }

    public boolean isWhitespace(char c2) {
        switch (c2) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public String getImagePath(int n2) {
        return this.imagePaths[n2];
    }

    public String[] getImagePaths() {
        return this.imagePaths;
    }

    public a getFontFile() {
        return this.fontFile;
    }

    public void setScale(float f2, float f3) {
        if (f2 == 0.0f) {
            throw new IllegalArgumentException("scaleX cannot be 0.");
        }
        if (f3 == 0.0f) {
            throw new IllegalArgumentException("scaleY cannot be 0.");
        }
        float f4 = f2 / this.scaleX;
        float f5 = f3 / this.scaleY;
        this.lineHeight *= f5;
        this.spaceXadvance *= f4;
        this.xHeight *= f5;
        this.capHeight *= f5;
        this.ascent *= f5;
        this.descent *= f5;
        this.down *= f5;
        this.padLeft *= f4;
        this.padRight *= f4;
        this.padTop *= f5;
        this.padBottom *= f5;
        this.scaleX = f2;
        this.scaleY = f3;
    }

    public void setScale(float f2) {
        float f3 = f2;
        this.setScale(f3, f3);
    }

    public void scale(float f2) {
        BitmapFont$BitmapFontData bitmapFont$BitmapFontData = this;
        bitmapFont$BitmapFontData.setScale(bitmapFont$BitmapFontData.scaleX + f2, this.scaleY + f2);
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }
}

