/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.d.a;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.TextureArrayData;
import com.badlogic.gdx.graphics.TextureArrayData$Factory;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class TextureArray
extends GLTexture {
    static final Map managedTextureArrays = new HashMap();
    private TextureArrayData data;

    public TextureArray(String ... stringArray) {
        this(TextureArray.getInternalHandles(stringArray));
    }

    public TextureArray(a ... aArray) {
        this(false, aArray);
    }

    public TextureArray(boolean bl2, a ... aArray) {
        this(bl2, Pixmap$Format.RGBA8888, aArray);
    }

    public TextureArray(boolean bl2, Pixmap$Format pixmap$Format, a ... aArray) {
        this(TextureArrayData$Factory.loadFromFiles(pixmap$Format, bl2, aArray));
    }

    public TextureArray(TextureArrayData textureArrayData) {
        super(35866, Gdx.g.glGenTexture());
        if (Gdx.i == null) {
            throw new GdxRuntimeException("TextureArray requires a device running with GLES 3.0 compatibilty");
        }
        this.load(textureArrayData);
        if (textureArrayData.isManaged()) {
            TextureArray.addManagedTexture(Gdx.a, this);
        }
    }

    private static a[] getInternalHandles(String ... stringArray) {
        a[] aArray = new a[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            aArray[i2] = Gdx.e.b(stringArray[i2]);
        }
        return aArray;
    }

    private void load(TextureArrayData textureArrayData) {
        if (this.data != null && textureArrayData.isManaged() != this.data.isManaged()) {
            throw new GdxRuntimeException("New data must have the same managed status as the old data");
        }
        this.data = textureArrayData;
        this.bind();
        Gdx.i.glTexImage3D(35866, 0, textureArrayData.getInternalFormat(), textureArrayData.getWidth(), textureArrayData.getHeight(), textureArrayData.getDepth(), 0, textureArrayData.getInternalFormat(), textureArrayData.getGLType(), null);
        if (!textureArrayData.isPrepared()) {
            textureArrayData.prepare();
        }
        textureArrayData.consumeTextureArrayData();
        TextureArray textureArray = this;
        textureArray.setFilter(textureArray.minFilter, this.magFilter);
        TextureArray textureArray2 = this;
        textureArray2.setWrap(textureArray2.uWrap, this.vWrap);
        Gdx.g.glBindTexture(this.glTarget, 0);
    }

    @Override
    public int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public int getHeight() {
        return this.data.getHeight();
    }

    @Override
    public int getDepth() {
        return this.data.getDepth();
    }

    @Override
    public boolean isManaged() {
        return this.data.isManaged();
    }

    @Override
    protected void reload() {
        if (!((GLTexture)this).isManaged()) {
            throw new GdxRuntimeException("Tried to reload an unmanaged TextureArray");
        }
        this.glHandle = Gdx.g.glGenTexture();
        TextureArray textureArray = this;
        textureArray.load(textureArray.data);
    }

    private static void addManagedTexture(Application application, TextureArray textureArray) {
        Array array = (Array)managedTextureArrays.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(textureArray);
        managedTextureArrays.put(application, array);
    }

    public static void clearAllTextureArrays(Application application) {
        managedTextureArrays.remove(application);
    }

    public static void invalidateAllTextureArrays(Application object) {
        if ((object = (Array)managedTextureArrays.get(object)) == null) {
            return;
        }
        for (int i2 = 0; i2 < ((Array)object).size; ++i2) {
            ((TextureArray)((Array)object).get(i2)).reload();
        }
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed TextureArrays/app: { ");
        for (Application application : managedTextureArrays.keySet()) {
            stringBuilder.append(((Array)TextureArray.managedTextureArrays.get((Object)application)).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedTextureArrays() {
        return ((Array)TextureArray.managedTextureArrays.get((Object)Gdx.a)).size;
    }
}

