/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.a.a.j;
import com.badlogic.gdx.a.d;
import com.badlogic.gdx.d.a;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.TextureData$Factory;
import com.badlogic.gdx.graphics.g;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class Texture
extends GLTexture {
    private static d assetManager;
    static final Map managedTextures;
    TextureData data;

    protected Texture() {
        super(0, 0);
    }

    public Texture(String string) {
        this(Gdx.e.b(string));
    }

    public Texture(a a2) {
        this(a2, null, false);
    }

    public Texture(a a2, boolean bl2) {
        this(a2, null, bl2);
    }

    public Texture(a a2, Pixmap$Format pixmap$Format, boolean bl2) {
        this(TextureData$Factory.loadFromFile(a2, pixmap$Format, bl2));
    }

    public Texture(Pixmap pixmap) {
        this(new PixmapTextureData(pixmap, null, false, false));
    }

    public Texture(Pixmap pixmap, boolean bl2) {
        this(new PixmapTextureData(pixmap, null, bl2, false));
    }

    public Texture(Pixmap pixmap, Pixmap$Format pixmap$Format, boolean bl2) {
        this(new PixmapTextureData(pixmap, pixmap$Format, bl2, false));
    }

    public Texture(int n2, int n3, Pixmap$Format pixmap$Format) {
        this(new PixmapTextureData(new Pixmap(n2, n3, pixmap$Format), null, false, true));
    }

    public Texture(TextureData textureData) {
        this(3553, Gdx.g.glGenTexture(), textureData);
    }

    protected Texture(int n2, int n3, TextureData textureData) {
        super(n2, n3);
        this.load(textureData);
        if (textureData.isManaged()) {
            Texture.addManagedTexture(Gdx.a, this);
        }
    }

    public void load(TextureData textureData) {
        if (this.data != null && textureData.isManaged() != this.data.isManaged()) {
            throw new GdxRuntimeException("New data must have the same managed status as the old data");
        }
        this.data = textureData;
        if (!textureData.isPrepared()) {
            textureData.prepare();
        }
        this.bind();
        Texture.uploadImageData(3553, textureData);
        Texture texture = this;
        texture.unsafeSetFilter(texture.minFilter, this.magFilter, true);
        Texture texture2 = this;
        texture2.unsafeSetWrap(texture2.uWrap, this.vWrap, true);
        Texture texture3 = this;
        texture3.unsafeSetAnisotropicFilter(texture3.anisotropicFilterLevel, true);
        Gdx.g.glBindTexture(this.glTarget, 0);
    }

    @Override
    protected void reload() {
        if (!((GLTexture)this).isManaged()) {
            throw new GdxRuntimeException("Tried to reload unmanaged Texture");
        }
        this.glHandle = Gdx.g.glGenTexture();
        Texture texture = this;
        texture.load(texture.data);
    }

    public void draw(Pixmap pixmap, int n2, int n3) {
        if (this.data.isManaged()) {
            throw new GdxRuntimeException("can't draw to a managed texture");
        }
        this.bind();
        Gdx.g.glTexSubImage2D(this.glTarget, 0, n2, n3, pixmap.getWidth(), pixmap.getHeight(), pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
    }

    @Override
    public int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public int getHeight() {
        return this.data.getHeight();
    }

    @Override
    public int getDepth() {
        return 0;
    }

    public TextureData getTextureData() {
        return this.data;
    }

    @Override
    public boolean isManaged() {
        return this.data.isManaged();
    }

    @Override
    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        this.delete();
        if (this.data.isManaged() && managedTextures.get(Gdx.a) != null) {
            ((Array)managedTextures.get(Gdx.a)).removeValue(this, true);
        }
    }

    public String toString() {
        if (this.data instanceof FileTextureData) {
            return this.data.toString();
        }
        return super.toString();
    }

    private static void addManagedTexture(Application application, Texture texture) {
        Array array = (Array)managedTextures.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(texture);
        managedTextures.put(application, array);
    }

    public static void clearAllTextures(Application application) {
        managedTextures.remove(application);
    }

    public static void invalidateAllTextures(Application object) {
        if ((object = (Array)managedTextures.get(object)) == null) {
            return;
        }
        if (assetManager == null) {
            for (int i2 = 0; i2 < ((Array)object).size; ++i2) {
                ((Texture)((Array)object).get(i2)).reload();
            }
            return;
        }
        assetManager.g();
        Array array = new Array((Array)object);
        for (Texture texture : array) {
            if (assetManager.e() == null) {
                texture.reload();
                continue;
            }
            int n2 = assetManager.h();
            assetManager.i();
            texture.glHandle = 0;
            j j2 = new j();
            new j().c = texture.getTextureData();
            j2.d = texture.getMinFilter();
            j2.e = texture.getMagFilter();
            j2.f = texture.getUWrap();
            j2.g = texture.getVWrap();
            j2.a = texture.data.useMipMaps();
            j2.b = texture;
            j2.loadedCallback = new g(n2);
            assetManager.d();
            texture.glHandle = Gdx.g.glGenTexture();
            assetManager.f();
        }
        ((Array)object).clear();
        ((Array)object).addAll(array);
    }

    public static void setAssetManager(d d2) {
        assetManager = d2;
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed textures/app: { ");
        for (Application application : managedTextures.keySet()) {
            stringBuilder.append(((Array)Texture.managedTextures.get((Object)application)).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedTextures() {
        return ((Array)Texture.managedTextures.get((Object)Gdx.a)).size;
    }

    static {
        managedTextures = new HashMap();
    }
}

