/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.d.a;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.f;
import com.badlogic.gdx.utils.ByteArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PixmapIO$PNG
implements Disposable {
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final byte COLOR_ARGB = 6;
    private static final byte COMPRESSION_DEFLATE = 0;
    private static final byte FILTER_NONE = 0;
    private static final byte INTERLACE_NONE = 0;
    private static final byte PAETH = 4;
    private final f buffer;
    private final Deflater deflater;
    private ByteArray lineOutBytes;
    private ByteArray curLineBytes;
    private ByteArray prevLineBytes;
    private boolean flipY = true;
    private int lastLineLen;

    public PixmapIO$PNG() {
        this(16384);
    }

    public PixmapIO$PNG(int n2) {
        this.buffer = new f(n2);
        this.deflater = new Deflater();
    }

    public void setFlipY(boolean bl2) {
        this.flipY = bl2;
    }

    public void setCompression(int n2) {
        this.deflater.setLevel(n2);
    }

    public void write(a object, Pixmap pixmap) {
        object = ((a)object).k();
        try {
            this.write((OutputStream)object, pixmap);
            return;
        }
        finally {
            StreamUtils.closeQuietly((Closeable)object);
        }
    }

    public void write(OutputStream outputStream, Pixmap pixmap) {
        int n2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(SIGNATURE);
        this.buffer.writeInt(1229472850);
        this.buffer.writeInt(pixmap.getWidth());
        this.buffer.writeInt(pixmap.getHeight());
        this.buffer.writeByte(8);
        this.buffer.writeByte(6);
        this.buffer.writeByte(0);
        this.buffer.writeByte(0);
        this.buffer.writeByte(0);
        this.buffer.a(dataOutputStream);
        this.buffer.writeInt(1229209940);
        this.deflater.reset();
        int n3 = pixmap.getWidth() << 2;
        if (this.lineOutBytes == null) {
            this.lineOutBytes = new ByteArray(n3);
            byArray3 = this.lineOutBytes.items;
            this.curLineBytes = new ByteArray(n3);
            byArray2 = this.curLineBytes.items;
            this.prevLineBytes = new ByteArray(n3);
            byArray = this.prevLineBytes.items;
        } else {
            byArray3 = this.lineOutBytes.ensureCapacity(n3);
            byArray2 = this.curLineBytes.ensureCapacity(n3);
            byArray = this.prevLineBytes.ensureCapacity(n3);
            n2 = this.lastLineLen;
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = 0;
            }
        }
        this.lastLineLen = n3;
        ByteBuffer byteBuffer = pixmap.getPixels();
        n2 = byteBuffer.position();
        boolean bl2 = pixmap.getFormat() == Pixmap$Format.RGBA8888;
        int n4 = pixmap.getHeight();
        for (int i3 = 0; i3 < n4; ++i3) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = n8 = this.flipY ? n4 - i3 - 1 : i3;
            if (bl2) {
                ((Buffer)byteBuffer).position(n8 * n3);
                byteBuffer.get(byArray2, 0, n3);
            } else {
                n7 = 0;
                for (n6 = 0; n6 < pixmap.getWidth(); ++n6) {
                    n5 = pixmap.getPixel(n6, n8);
                    byArray2[n7++] = (byte)(n5 >>> 24);
                    byArray2[n7++] = (byte)(n5 >> 16);
                    byArray2[n7++] = (byte)(n5 >> 8);
                    byArray2[n7++] = (byte)n5;
                }
            }
            byArray3[0] = (byte)(byArray2[0] - byArray[0]);
            byArray3[1] = (byte)(byArray2[1] - byArray[1]);
            byArray3[2] = (byte)(byArray2[2] - byArray[2]);
            byArray3[3] = (byte)(byArray2[3] - byArray[3]);
            for (n6 = 4; n6 < n3; ++n6) {
                int n10;
                n7 = byArray2[n6 - 4] & 0xFF;
                n5 = byArray[n6] & 0xFF;
                n8 = byArray[n6 - 4] & 0xFF;
                int n11 = n7 + n5 - n8;
                int n12 = n11 - n7;
                if (n12 < 0) {
                    n12 = -n12;
                }
                if ((n10 = n11 - n5) < 0) {
                    n10 = -n10;
                }
                if ((n11 -= n8) < 0) {
                    n11 = -n11;
                }
                if (n12 <= n10 && n12 <= n11) {
                    n8 = n7;
                } else if (n10 <= n11) {
                    n8 = n5;
                }
                byArray3[n6] = (byte)(byArray2[n6] - n8);
            }
            deflaterOutputStream.write(4);
            deflaterOutputStream.write(byArray3, 0, n3);
            byte[] byArray4 = byArray2;
            byArray2 = byArray;
            byArray = byArray4;
        }
        ((Buffer)byteBuffer).position(n2);
        deflaterOutputStream.finish();
        this.buffer.a(dataOutputStream);
        this.buffer.writeInt(1229278788);
        this.buffer.a(dataOutputStream);
        outputStream.flush();
    }

    @Override
    public void dispose() {
        this.deflater.end();
    }
}

