/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Mesh$VertexDataType;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.IndexArray;
import com.badlogic.gdx.graphics.glutils.IndexBufferObject;
import com.badlogic.gdx.graphics.glutils.IndexBufferObjectSubData;
import com.badlogic.gdx.graphics.glutils.IndexData;
import com.badlogic.gdx.graphics.glutils.InstanceBufferObject;
import com.badlogic.gdx.graphics.glutils.InstanceData;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexArray;
import com.badlogic.gdx.graphics.glutils.VertexBufferObject;
import com.badlogic.gdx.graphics.glutils.VertexBufferObjectSubData;
import com.badlogic.gdx.graphics.glutils.VertexBufferObjectWithVAO;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;

public class Mesh
implements Disposable {
    static final Map meshes = new HashMap();
    final VertexData vertices;
    final IndexData indices;
    boolean autoBind = true;
    final boolean isVertexArray;
    InstanceData instances;
    boolean isInstanced = false;
    private final Vector3 tmpV = new Vector3();

    protected Mesh(VertexData vertexData, IndexData indexData, boolean bl2) {
        this.vertices = vertexData;
        this.indices = indexData;
        this.isVertexArray = bl2;
        Mesh.addManagedMesh(Gdx.a, this);
    }

    public Mesh(boolean bl2, int n2, int n3, VertexAttribute ... vertexAttributeArray) {
        this.vertices = this.makeVertexBuffer(bl2, n2, new VertexAttributes(vertexAttributeArray));
        this.indices = new IndexBufferObject(bl2, n3);
        this.isVertexArray = false;
        Mesh.addManagedMesh(Gdx.a, this);
    }

    public Mesh(boolean bl2, int n2, int n3, VertexAttributes vertexAttributes) {
        this.vertices = this.makeVertexBuffer(bl2, n2, vertexAttributes);
        this.indices = new IndexBufferObject(bl2, n3);
        this.isVertexArray = false;
        Mesh.addManagedMesh(Gdx.a, this);
    }

    public Mesh(boolean bl2, boolean bl3, int n2, int n3, VertexAttributes vertexAttributes) {
        this.vertices = this.makeVertexBuffer(bl2, n2, vertexAttributes);
        this.indices = new IndexBufferObject(bl3, n3);
        this.isVertexArray = false;
        Mesh.addManagedMesh(Gdx.a, this);
    }

    private VertexData makeVertexBuffer(boolean bl2, int n2, VertexAttributes vertexAttributes) {
        if (Gdx.i != null) {
            return new VertexBufferObjectWithVAO(bl2, n2, vertexAttributes);
        }
        return new VertexBufferObject(bl2, n2, vertexAttributes);
    }

    public Mesh(Mesh$VertexDataType mesh$VertexDataType, boolean bl2, int n2, int n3, VertexAttribute ... vertexAttributeArray) {
        this(mesh$VertexDataType, bl2, n2, n3, new VertexAttributes(vertexAttributeArray));
    }

    public Mesh(Mesh$VertexDataType mesh$VertexDataType, boolean bl2, int n2, int n3, VertexAttributes vertexAttributes) {
        switch (mesh$VertexDataType) {
            case VertexBufferObject: {
                this.vertices = new VertexBufferObject(bl2, n2, vertexAttributes);
                this.indices = new IndexBufferObject(bl2, n3);
                this.isVertexArray = false;
                break;
            }
            case VertexBufferObjectSubData: {
                this.vertices = new VertexBufferObjectSubData(bl2, n2, vertexAttributes);
                this.indices = new IndexBufferObjectSubData(bl2, n3);
                this.isVertexArray = false;
                break;
            }
            case VertexBufferObjectWithVAO: {
                this.vertices = new VertexBufferObjectWithVAO(bl2, n2, vertexAttributes);
                this.indices = new IndexBufferObjectSubData(bl2, n3);
                this.isVertexArray = false;
                break;
            }
            default: {
                this.vertices = new VertexArray(n2, vertexAttributes);
                this.indices = new IndexArray(n3);
                this.isVertexArray = true;
            }
        }
        Mesh.addManagedMesh(Gdx.a, this);
    }

    public Mesh enableInstancedRendering(boolean bl2, int n2, VertexAttribute ... vertexAttributeArray) {
        if (this.isInstanced) {
            throw new GdxRuntimeException("Trying to enable InstancedRendering on same Mesh instance twice. Use disableInstancedRendering to clean up old InstanceData first");
        }
        this.isInstanced = true;
        this.instances = new InstanceBufferObject(bl2, n2, vertexAttributeArray);
        return this;
    }

    public Mesh disableInstancedRendering() {
        if (this.isInstanced) {
            this.isInstanced = false;
            this.instances.dispose();
            this.instances = null;
        }
        return this;
    }

    public Mesh setInstanceData(float[] fArray, int n2, int n3) {
        if (this.instances == null) {
            throw new GdxRuntimeException("An InstanceBufferObject must be set before setting instance data!");
        }
        this.instances.setInstanceData(fArray, n2, n3);
        return this;
    }

    public Mesh setInstanceData(float[] fArray) {
        if (this.instances == null) {
            throw new GdxRuntimeException("An InstanceBufferObject must be set before setting instance data!");
        }
        this.instances.setInstanceData(fArray, 0, fArray.length);
        return this;
    }

    public Mesh setInstanceData(FloatBuffer floatBuffer, int n2) {
        if (this.instances == null) {
            throw new GdxRuntimeException("An InstanceBufferObject must be set before setting instance data!");
        }
        this.instances.setInstanceData(floatBuffer, n2);
        return this;
    }

    public Mesh setInstanceData(FloatBuffer floatBuffer) {
        if (this.instances == null) {
            throw new GdxRuntimeException("An InstanceBufferObject must be set before setting instance data!");
        }
        FloatBuffer floatBuffer2 = floatBuffer;
        this.instances.setInstanceData(floatBuffer2, floatBuffer2.limit());
        return this;
    }

    public Mesh updateInstanceData(int n2, float[] fArray) {
        return this.updateInstanceData(n2, fArray, 0, fArray.length);
    }

    public Mesh updateInstanceData(int n2, float[] fArray, int n3, int n4) {
        this.instances.updateInstanceData(n2, fArray, n3, n4);
        return this;
    }

    public Mesh updateInstanceData(int n2, FloatBuffer floatBuffer) {
        return this.updateInstanceData(n2, floatBuffer, 0, floatBuffer.limit());
    }

    public Mesh updateInstanceData(int n2, FloatBuffer floatBuffer, int n3, int n4) {
        this.instances.updateInstanceData(n2, floatBuffer, n3, n4);
        return this;
    }

    public Mesh setVertices(float[] fArray) {
        this.vertices.setVertices(fArray, 0, fArray.length);
        return this;
    }

    public boolean isInstanced() {
        return this.isInstanced;
    }

    public Mesh setVertices(float[] fArray, int n2, int n3) {
        this.vertices.setVertices(fArray, n2, n3);
        return this;
    }

    public Mesh updateVertices(int n2, float[] fArray) {
        return this.updateVertices(n2, fArray, 0, fArray.length);
    }

    public Mesh updateVertices(int n2, float[] fArray, int n3, int n4) {
        this.vertices.updateVertices(n2, fArray, n3, n4);
        return this;
    }

    public float[] getVertices(float[] fArray) {
        return this.getVertices(0, -1, fArray);
    }

    public float[] getVertices(int n2, float[] fArray) {
        return this.getVertices(n2, -1, fArray);
    }

    public float[] getVertices(int n2, int n3, float[] fArray) {
        return this.getVertices(n2, n3, fArray, 0);
    }

    public float[] getVertices(int n2, int n3, float[] fArray, int n4) {
        int n5 = this.getNumVertices() * this.getVertexSize() / 4;
        if (n3 == -1 && (n3 = n5 - n2) > fArray.length - n4) {
            n3 = fArray.length - n4;
        }
        if (n2 < 0 || n3 <= 0 || n2 + n3 > n5 || n4 < 0 || n4 >= fArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (fArray.length - n4 < n3) {
            throw new IllegalArgumentException("not enough room in vertices array, has " + fArray.length + " floats, needs " + n3);
        }
        FloatBuffer floatBuffer = this.getVerticesBuffer(false);
        int n6 = floatBuffer.position();
        ((Buffer)floatBuffer).position(n2);
        floatBuffer.get(fArray, n4, n3);
        ((Buffer)floatBuffer).position(n6);
        return fArray;
    }

    public Mesh setIndices(short[] sArray) {
        this.indices.setIndices(sArray, 0, sArray.length);
        return this;
    }

    public Mesh setIndices(short[] sArray, int n2, int n3) {
        this.indices.setIndices(sArray, n2, n3);
        return this;
    }

    public void getIndices(short[] sArray) {
        this.getIndices(sArray, 0);
    }

    public void getIndices(short[] sArray, int n2) {
        this.getIndices(0, sArray, n2);
    }

    public void getIndices(int n2, short[] sArray, int n3) {
        this.getIndices(n2, -1, sArray, n3);
    }

    public void getIndices(int n2, int n3, short[] sArray, int n4) {
        int n5 = this.getNumIndices();
        if (n3 < 0) {
            n3 = n5 - n2;
        }
        if (n2 < 0 || n2 >= n5 || n2 + n3 > n5) {
            throw new IllegalArgumentException("Invalid range specified, offset: " + n2 + ", count: " + n3 + ", max: " + n5);
        }
        if (sArray.length - n4 < n3) {
            throw new IllegalArgumentException("not enough room in indices array, has " + sArray.length + " shorts, needs " + n3);
        }
        ShortBuffer shortBuffer = this.getIndicesBuffer(false);
        int n6 = shortBuffer.position();
        ((Buffer)shortBuffer).position(n2);
        shortBuffer.get(sArray, n4, n3);
        ((Buffer)shortBuffer).position(n6);
    }

    public int getNumIndices() {
        return this.indices.getNumIndices();
    }

    public int getNumVertices() {
        return this.vertices.getNumVertices();
    }

    public int getMaxVertices() {
        return this.vertices.getNumMaxVertices();
    }

    public int getMaxIndices() {
        return this.indices.getNumMaxIndices();
    }

    public int getVertexSize() {
        return this.vertices.getAttributes().vertexSize;
    }

    public IndexData getIndexData() {
        return this.indices;
    }

    public void setAutoBind(boolean bl2) {
        this.autoBind = bl2;
    }

    public void bind(ShaderProgram shaderProgram) {
        this.bind(shaderProgram, null, null);
    }

    public void bind(ShaderProgram shaderProgram, int[] nArray, int[] nArray2) {
        this.vertices.bind(shaderProgram, nArray);
        if (this.instances != null && this.instances.getNumInstances() > 0) {
            this.instances.bind(shaderProgram, nArray2);
        }
        if (this.indices.getNumIndices() > 0) {
            this.indices.bind();
        }
    }

    public void unbind(ShaderProgram shaderProgram) {
        this.unbind(shaderProgram, null, null);
    }

    public void unbind(ShaderProgram shaderProgram, int[] nArray, int[] nArray2) {
        this.vertices.unbind(shaderProgram, nArray);
        if (this.instances != null && this.instances.getNumInstances() > 0) {
            this.instances.unbind(shaderProgram, nArray2);
        }
        if (this.indices.getNumIndices() > 0) {
            this.indices.unbind();
        }
    }

    public void render(ShaderProgram shaderProgram, int n2) {
        this.render(shaderProgram, n2, 0, this.indices.getNumMaxIndices() > 0 ? this.getNumIndices() : this.getNumVertices(), this.autoBind);
    }

    public void render(ShaderProgram shaderProgram, int n2, int n3, int n4) {
        this.render(shaderProgram, n2, n3, n4, this.autoBind);
    }

    public void render(ShaderProgram shaderProgram, int n2, int n3, int n4, boolean bl2) {
        if (n4 == 0) {
            return;
        }
        if (bl2) {
            this.bind(shaderProgram);
        }
        if (this.isVertexArray) {
            if (this.indices.getNumIndices() > 0) {
                ShortBuffer shortBuffer = this.indices.getBuffer(false);
                int n5 = shortBuffer.position();
                shortBuffer.limit();
                ((Buffer)shortBuffer).position(n3);
                Gdx.h.glDrawElements(n2, n4, 5123, shortBuffer);
                ((Buffer)shortBuffer).position(n5);
            } else {
                Gdx.h.glDrawArrays(n2, n3, n4);
            }
        } else {
            int n6 = 0;
            if (this.isInstanced) {
                n6 = this.instances.getNumInstances();
            }
            if (this.indices.getNumIndices() > 0) {
                if (n4 + n3 > this.indices.getNumMaxIndices()) {
                    throw new GdxRuntimeException("Mesh attempting to access memory outside of the index buffer (count: " + n4 + ", offset: " + n3 + ", max: " + this.indices.getNumMaxIndices() + ")");
                }
                if (this.isInstanced && n6 > 0) {
                    Gdx.i.glDrawElementsInstanced(n2, n4, 5123, n3 << 1, n6);
                } else {
                    Gdx.h.glDrawElements(n2, n4, 5123, n3 << 1);
                }
            } else if (this.isInstanced && n6 > 0) {
                Gdx.i.glDrawArraysInstanced(n2, n3, n4, n6);
            } else {
                Gdx.h.glDrawArrays(n2, n3, n4);
            }
        }
        if (bl2) {
            this.unbind(shaderProgram);
        }
    }

    @Override
    public void dispose() {
        if (meshes.get(Gdx.a) != null) {
            ((Array)meshes.get(Gdx.a)).removeValue(this, true);
        }
        this.vertices.dispose();
        if (this.instances != null) {
            this.instances.dispose();
        }
        this.indices.dispose();
    }

    public VertexAttribute getVertexAttribute(int n2) {
        VertexAttributes vertexAttributes = this.vertices.getAttributes();
        int n3 = vertexAttributes.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (vertexAttributes.get((int)i2).usage != n2) continue;
            return vertexAttributes.get(i2);
        }
        return null;
    }

    public VertexAttributes getVertexAttributes() {
        return this.vertices.getAttributes();
    }

    public VertexAttributes getInstancedAttributes() {
        if (this.instances != null) {
            return this.instances.getAttributes();
        }
        return null;
    }

    public FloatBuffer getVerticesBuffer() {
        return this.vertices.getBuffer(true);
    }

    public FloatBuffer getVerticesBuffer(boolean bl2) {
        return this.vertices.getBuffer(bl2);
    }

    public BoundingBox calculateBoundingBox() {
        BoundingBox boundingBox = new BoundingBox();
        this.calculateBoundingBox(boundingBox);
        return boundingBox;
    }

    public void calculateBoundingBox(BoundingBox boundingBox) {
        int n2 = this.getNumVertices();
        if (n2 == 0) {
            throw new GdxRuntimeException("No vertices defined");
        }
        FloatBuffer floatBuffer = this.vertices.getBuffer(false);
        boundingBox.inf();
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n3 = vertexAttribute.offset / 4;
        int n4 = this.vertices.getAttributes().vertexSize / 4;
        switch (vertexAttribute.numComponents) {
            case 1: {
                for (int i2 = 0; i2 < n2; ++i2) {
                    boundingBox.ext(floatBuffer.get(n3), 0.0f, 0.0f);
                    n3 += n4;
                }
                return;
            }
            case 2: {
                for (int i3 = 0; i3 < n2; ++i3) {
                    boundingBox.ext(floatBuffer.get(n3), floatBuffer.get(n3 + 1), 0.0f);
                    n3 += n4;
                }
                return;
            }
            case 3: {
                for (int i4 = 0; i4 < n2; ++i4) {
                    boundingBox.ext(floatBuffer.get(n3), floatBuffer.get(n3 + 1), floatBuffer.get(n3 + 2));
                    n3 += n4;
                }
                break;
            }
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox, int n2, int n3) {
        return this.extendBoundingBox(boundingBox.inf(), n2, n3);
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox, int n2, int n3, Matrix4 matrix4) {
        return this.extendBoundingBox(boundingBox.inf(), n2, n3, matrix4);
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox, int n2, int n3) {
        return this.extendBoundingBox(boundingBox, n2, n3, null);
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox, int n2, int n3, Matrix4 matrix4) {
        int n4 = this.getNumIndices();
        int n5 = this.getNumVertices();
        int n6 = n5 = n4 == 0 ? n5 : n4;
        if (n2 < 0 || n3 <= 0 || n2 + n3 > n5) {
            throw new GdxRuntimeException("Invalid part specified ( offset=" + n2 + ", count=" + n3 + ", max=" + n5 + " )");
        }
        FloatBuffer floatBuffer = this.vertices.getBuffer(false);
        ShortBuffer shortBuffer = this.indices.getBuffer(false);
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n7 = vertexAttribute.offset / 4;
        int n8 = this.vertices.getAttributes().vertexSize / 4;
        n3 = n2 + n3;
        switch (vertexAttribute.numComponents) {
            case 1: {
                if (n4 > 0) {
                    while (n2 < n3) {
                        n4 = (shortBuffer.get(n2) & 0xFFFF) * n8 + n7;
                        this.tmpV.set(floatBuffer.get(n4), 0.0f, 0.0f);
                        if (matrix4 != null) {
                            this.tmpV.mul(matrix4);
                        }
                        boundingBox.ext(this.tmpV);
                        ++n2;
                    }
                } else {
                    while (n2 < n3) {
                        n4 = n2 * n8 + n7;
                        this.tmpV.set(floatBuffer.get(n4), 0.0f, 0.0f);
                        if (matrix4 != null) {
                            this.tmpV.mul(matrix4);
                        }
                        boundingBox.ext(this.tmpV);
                        ++n2;
                    }
                }
                break;
            }
            case 2: {
                if (n4 > 0) {
                    while (n2 < n3) {
                        n4 = (shortBuffer.get(n2) & 0xFFFF) * n8 + n7;
                        this.tmpV.set(floatBuffer.get(n4), floatBuffer.get(n4 + 1), 0.0f);
                        if (matrix4 != null) {
                            this.tmpV.mul(matrix4);
                        }
                        boundingBox.ext(this.tmpV);
                        ++n2;
                    }
                } else {
                    while (n2 < n3) {
                        n4 = n2 * n8 + n7;
                        this.tmpV.set(floatBuffer.get(n4), floatBuffer.get(n4 + 1), 0.0f);
                        if (matrix4 != null) {
                            this.tmpV.mul(matrix4);
                        }
                        boundingBox.ext(this.tmpV);
                        ++n2;
                    }
                }
                break;
            }
            case 3: {
                if (n4 > 0) {
                    while (n2 < n3) {
                        n4 = (shortBuffer.get(n2) & 0xFFFF) * n8 + n7;
                        this.tmpV.set(floatBuffer.get(n4), floatBuffer.get(n4 + 1), floatBuffer.get(n4 + 2));
                        if (matrix4 != null) {
                            this.tmpV.mul(matrix4);
                        }
                        boundingBox.ext(this.tmpV);
                        ++n2;
                    }
                } else {
                    while (n2 < n3) {
                        n4 = n2 * n8 + n7;
                        this.tmpV.set(floatBuffer.get(n4), floatBuffer.get(n4 + 1), floatBuffer.get(n4 + 2));
                        if (matrix4 != null) {
                            this.tmpV.mul(matrix4);
                        }
                        boundingBox.ext(this.tmpV);
                        ++n2;
                    }
                }
                break;
            }
        }
        return boundingBox;
    }

    public float calculateRadiusSquared(float f2, float f3, float f4, int n2, int n3, Matrix4 matrix4) {
        int n4 = this.getNumIndices();
        if (n2 < 0 || n3 <= 0 || n2 + n3 > n4) {
            throw new GdxRuntimeException("Not enough indices");
        }
        FloatBuffer floatBuffer = this.vertices.getBuffer(false);
        ShortBuffer shortBuffer = this.indices.getBuffer(false);
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n5 = vertexAttribute.offset / 4;
        int n6 = this.vertices.getAttributes().vertexSize / 4;
        n3 = n2 + n3;
        float f5 = 0.0f;
        switch (vertexAttribute.numComponents) {
            case 1: {
                while (n2 < n3) {
                    float f6;
                    int n7 = (shortBuffer.get(n2) & 0xFFFF) * n6 + n5;
                    this.tmpV.set(floatBuffer.get(n7), 0.0f, 0.0f);
                    if (matrix4 != null) {
                        this.tmpV.mul(matrix4);
                    }
                    float f7 = this.tmpV.sub(f2, f3, f4).len2();
                    if (f6 > f5) {
                        f5 = f7;
                    }
                    ++n2;
                }
                break;
            }
            case 2: {
                while (n2 < n3) {
                    float f8;
                    int n8 = (shortBuffer.get(n2) & 0xFFFF) * n6 + n5;
                    this.tmpV.set(floatBuffer.get(n8), floatBuffer.get(n8 + 1), 0.0f);
                    if (matrix4 != null) {
                        this.tmpV.mul(matrix4);
                    }
                    float f9 = this.tmpV.sub(f2, f3, f4).len2();
                    if (f8 > f5) {
                        f5 = f9;
                    }
                    ++n2;
                }
                break;
            }
            case 3: {
                while (n2 < n3) {
                    float f10;
                    int n9 = (shortBuffer.get(n2) & 0xFFFF) * n6 + n5;
                    this.tmpV.set(floatBuffer.get(n9), floatBuffer.get(n9 + 1), floatBuffer.get(n9 + 2));
                    if (matrix4 != null) {
                        this.tmpV.mul(matrix4);
                    }
                    float f11 = this.tmpV.sub(f2, f3, f4).len2();
                    if (f10 > f5) {
                        f5 = f11;
                    }
                    ++n2;
                }
                break;
            }
        }
        return f5;
    }

    public float calculateRadius(float f2, float f3, float f4, int n2, int n3, Matrix4 matrix4) {
        return (float)Math.sqrt(this.calculateRadiusSquared(f2, f3, f4, n2, n3, matrix4));
    }

    public float calculateRadius(Vector3 vector3, int n2, int n3, Matrix4 matrix4) {
        return this.calculateRadius(vector3.x, vector3.y, vector3.z, n2, n3, matrix4);
    }

    public float calculateRadius(float f2, float f3, float f4, int n2, int n3) {
        return this.calculateRadius(f2, f3, f4, n2, n3, null);
    }

    public float calculateRadius(Vector3 vector3, int n2, int n3) {
        return this.calculateRadius(vector3.x, vector3.y, vector3.z, n2, n3, null);
    }

    public float calculateRadius(float f2, float f3, float f4) {
        return this.calculateRadius(f2, f3, f4, 0, this.getNumIndices(), null);
    }

    public float calculateRadius(Vector3 vector3) {
        return this.calculateRadius(vector3.x, vector3.y, vector3.z, 0, this.getNumIndices(), null);
    }

    public ShortBuffer getIndicesBuffer() {
        return this.indices.getBuffer(true);
    }

    public ShortBuffer getIndicesBuffer(boolean bl2) {
        return this.indices.getBuffer(bl2);
    }

    private static void addManagedMesh(Application application, Mesh mesh) {
        Array array = (Array)meshes.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(mesh);
        meshes.put(application, array);
    }

    public static void invalidateAllMeshes(Application object) {
        if ((object = (Array)meshes.get(object)) == null) {
            return;
        }
        for (int i2 = 0; i2 < ((Array)object).size; ++i2) {
            ((Mesh)((Array)object).get((int)i2)).vertices.invalidate();
            ((Mesh)((Array)object).get((int)i2)).indices.invalidate();
        }
    }

    public static void clearAllMeshes(Application application) {
        meshes.remove(application);
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed meshes/app: { ");
        for (Application application : meshes.keySet()) {
            stringBuilder.append(((Array)Mesh.meshes.get((Object)application)).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void scale(float f2, float f3, float f4) {
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n2 = vertexAttribute.offset / 4;
        int n3 = vertexAttribute.numComponents;
        int n4 = this.getNumVertices();
        int n5 = this.getVertexSize() / 4;
        float[] fArray = new float[n4 * n5];
        this.getVertices(fArray);
        switch (n3) {
            case 1: {
                for (n3 = 0; n3 < n4; ++n3) {
                    int n6 = n2;
                    fArray[n6] = fArray[n6] * f2;
                    n2 += n5;
                }
                break;
            }
            case 2: {
                for (n3 = 0; n3 < n4; ++n3) {
                    int n7 = n2;
                    fArray[n7] = fArray[n7] * f2;
                    int n8 = n2 + 1;
                    fArray[n8] = fArray[n8] * f3;
                    n2 += n5;
                }
                break;
            }
            case 3: {
                for (n3 = 0; n3 < n4; ++n3) {
                    int n9 = n2;
                    fArray[n9] = fArray[n9] * f2;
                    int n10 = n2 + 1;
                    fArray[n10] = fArray[n10] * f3;
                    int n11 = n2 + 2;
                    fArray[n11] = fArray[n11] * f4;
                    n2 += n5;
                }
                break;
            }
        }
        this.setVertices(fArray);
    }

    public void transform(Matrix4 matrix4) {
        this.transform(matrix4, 0, this.getNumVertices());
    }

    public void transform(Matrix4 matrix4, int n2, int n3) {
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n4 = vertexAttribute.offset / 4;
        int n5 = this.getVertexSize() / 4;
        int n6 = vertexAttribute.numComponents;
        this.getNumVertices();
        float[] fArray = new float[n3 * n5];
        this.getVertices(n2 * n5, n3 * n5, fArray);
        Mesh.transform(matrix4, fArray, n5, n4, n6, 0, n3);
        this.updateVertices(n2 * n5, fArray);
    }

    public static void transform(Matrix4 matrix4, float[] fArray, int n2, int n3, int n4, int n5, int n6) {
        if (n3 < 0 || n4 <= 0 || n3 + n4 > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n5 < 0 || n6 <= 0 || (n5 + n6) * n2 > fArray.length) {
            throw new IndexOutOfBoundsException("start = " + n5 + ", count = " + n6 + ", vertexSize = " + n2 + ", length = " + fArray.length);
        }
        Vector3 vector3 = new Vector3();
        n3 += n5 * n2;
        switch (n4) {
            case 1: {
                for (n4 = 0; n4 < n6; ++n4) {
                    vector3.set(fArray[n3], 0.0f, 0.0f).mul(matrix4);
                    fArray[n3] = vector3.x;
                    n3 += n2;
                }
                return;
            }
            case 2: {
                for (n4 = 0; n4 < n6; ++n4) {
                    vector3.set(fArray[n3], fArray[n3 + 1], 0.0f).mul(matrix4);
                    fArray[n3] = vector3.x;
                    fArray[n3 + 1] = vector3.y;
                    n3 += n2;
                }
                return;
            }
            case 3: {
                for (n4 = 0; n4 < n6; ++n4) {
                    vector3.set(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]).mul(matrix4);
                    fArray[n3] = vector3.x;
                    fArray[n3 + 1] = vector3.y;
                    fArray[n3 + 2] = vector3.z;
                    n3 += n2;
                }
                break;
            }
        }
    }

    public void transformUV(Matrix3 matrix3) {
        this.transformUV(matrix3, 0, this.getNumVertices());
    }

    protected void transformUV(Matrix3 matrix3, int n2, int n3) {
        int n4 = this.getVertexAttribute((int)16).offset / 4;
        int n5 = this.getVertexSize() / 4;
        float[] fArray = new float[this.getNumVertices() * n5];
        this.getVertices(0, fArray.length, fArray);
        Mesh.transformUV(matrix3, fArray, n5, n4, n2, n3);
        this.setVertices(fArray, 0, fArray.length);
    }

    public static void transformUV(Matrix3 matrix3, float[] fArray, int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 <= 0 || (n4 + n5) * n2 > fArray.length) {
            throw new IndexOutOfBoundsException("start = " + n4 + ", count = " + n5 + ", vertexSize = " + n2 + ", length = " + fArray.length);
        }
        Vector2 vector2 = new Vector2();
        n3 += n4 * n2;
        for (n4 = 0; n4 < n5; ++n4) {
            vector2.set(fArray[n3], fArray[n3 + 1]).mul(matrix3);
            fArray[n3] = vector2.x;
            fArray[n3 + 1] = vector2.y;
            n3 += n2;
        }
    }

    public Mesh copy(boolean bl2, boolean bl3, int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getVertexSize() / 4;
        int n7 = this.getNumVertices();
        float[] fArray = new float[n7 * n6];
        this.getVertices(0, fArray.length, fArray);
        short[] sArray = null;
        VertexAttribute[] vertexAttributeArray = null;
        int n8 = 0;
        if (nArray != null) {
            int n9;
            n5 = 0;
            int n10 = 0;
            for (n9 = 0; n9 < nArray.length; ++n9) {
                if (this.getVertexAttribute(nArray[n9]) == null) continue;
                n5 += this.getVertexAttribute((int)nArray[n9]).numComponents;
                ++n10;
            }
            if (n5 > 0) {
                vertexAttributeArray = new VertexAttribute[n10];
                sArray = new short[n5];
                n9 = -1;
                n4 = -1;
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    VertexAttribute vertexAttribute = this.getVertexAttribute(nArray[n3]);
                    if (vertexAttribute == null) continue;
                    for (n2 = 0; n2 < vertexAttribute.numComponents; ++n2) {
                        sArray[++n9] = (short)(vertexAttribute.offset + n2);
                    }
                    vertexAttributeArray[++n4] = vertexAttribute.copy();
                    n8 += vertexAttribute.numComponents;
                }
            }
        }
        if (sArray == null) {
            sArray = new short[n6];
            for (n5 = 0; n5 < n6; n5 = (int)((short)(n5 + 1))) {
                int n11 = n5;
                sArray[n11] = n11;
            }
            n8 = n6;
        }
        n5 = this.getNumIndices();
        short[] sArray2 = null;
        if (n5 > 0) {
            sArray2 = new short[n5];
            this.getIndices(sArray2);
            if (bl3 || n8 != n6) {
                float[] fArray2 = new float[fArray.length];
                n4 = 0;
                for (n3 = 0; n3 < n5; ++n3) {
                    int n12 = sArray2[n3] * n6;
                    n2 = -1;
                    if (bl3) {
                        for (int n13 = 0; n13 < n4 && n2 < 0; n13 = (int)((short)(n13 + 1))) {
                            n7 = n13 * n8;
                            boolean bl4 = true;
                            for (int i2 = 0; i2 < sArray.length && bl4; ++i2) {
                                if (fArray2[n7 + i2] == fArray[n12 + sArray[i2]]) continue;
                                bl4 = false;
                            }
                            if (!bl4) continue;
                            n2 = n13;
                        }
                    }
                    if (n2 > 0) {
                        sArray2[n3] = n2;
                        continue;
                    }
                    int n14 = n4 * n8;
                    for (n7 = 0; n7 < sArray.length; ++n7) {
                        fArray2[n14 + n7] = fArray[n12 + sArray[n7]];
                    }
                    sArray2[n3] = (short)n4;
                    ++n4;
                }
                fArray = fArray2;
                n7 = n4;
            }
        }
        Mesh mesh = vertexAttributeArray == null ? new Mesh(bl2, n7, sArray2 == null ? 0 : sArray2.length, this.getVertexAttributes()) : new Mesh(bl2, n7, sArray2 == null ? 0 : sArray2.length, vertexAttributeArray);
        mesh.setVertices(fArray, 0, n7 * n8);
        if (sArray2 != null) {
            mesh.setIndices(sArray2);
        }
        return mesh;
    }

    public Mesh copy(boolean bl2) {
        return this.copy(bl2, false, null);
    }
}

