/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.a.a.d;
import com.badlogic.gdx.graphics.CubemapData;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.TextureData$Factory;
import com.badlogic.gdx.graphics.a;
import com.badlogic.gdx.graphics.glutils.FacedCubemapData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class Cubemap
extends GLTexture {
    private static com.badlogic.gdx.a.d assetManager;
    static final Map managedCubemaps;
    protected CubemapData data;

    public Cubemap(CubemapData cubemapData) {
        super(34067);
        this.data = cubemapData;
        this.load(cubemapData);
        if (cubemapData.isManaged()) {
            Cubemap.addManagedCubemap(Gdx.a, this);
        }
    }

    public Cubemap(com.badlogic.gdx.d.a a2, com.badlogic.gdx.d.a a3, com.badlogic.gdx.d.a a4, com.badlogic.gdx.d.a a5, com.badlogic.gdx.d.a a6, com.badlogic.gdx.d.a a7) {
        this(a2, a3, a4, a5, a6, a7, false);
    }

    public Cubemap(com.badlogic.gdx.d.a a2, com.badlogic.gdx.d.a a3, com.badlogic.gdx.d.a a4, com.badlogic.gdx.d.a a5, com.badlogic.gdx.d.a a6, com.badlogic.gdx.d.a a7, boolean bl2) {
        this(TextureData$Factory.loadFromFile(a2, bl2), TextureData$Factory.loadFromFile(a3, bl2), TextureData$Factory.loadFromFile(a4, bl2), TextureData$Factory.loadFromFile(a5, bl2), TextureData$Factory.loadFromFile(a6, bl2), TextureData$Factory.loadFromFile(a7, bl2));
    }

    public Cubemap(Pixmap pixmap, Pixmap pixmap2, Pixmap pixmap3, Pixmap pixmap4, Pixmap pixmap5, Pixmap pixmap6) {
        this(pixmap, pixmap2, pixmap3, pixmap4, pixmap5, pixmap6, false);
    }

    public Cubemap(Pixmap pixmap, Pixmap pixmap2, Pixmap pixmap3, Pixmap pixmap4, Pixmap pixmap5, Pixmap pixmap6, boolean bl2) {
        this(pixmap == null ? null : new PixmapTextureData(pixmap, null, bl2, false), pixmap2 == null ? null : new PixmapTextureData(pixmap2, null, bl2, false), pixmap3 == null ? null : new PixmapTextureData(pixmap3, null, bl2, false), pixmap4 == null ? null : new PixmapTextureData(pixmap4, null, bl2, false), pixmap5 == null ? null : new PixmapTextureData(pixmap5, null, bl2, false), pixmap6 == null ? null : new PixmapTextureData(pixmap6, null, bl2, false));
    }

    public Cubemap(int n2, int n3, int n4, Pixmap$Format pixmap$Format) {
        this(new PixmapTextureData(new Pixmap(n4, n3, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n4, n3, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n2, n4, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n2, n4, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n2, n3, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n2, n3, pixmap$Format), null, false, true));
    }

    public Cubemap(TextureData textureData, TextureData textureData2, TextureData textureData3, TextureData textureData4, TextureData textureData5, TextureData textureData6) {
        this(new FacedCubemapData(textureData, textureData2, textureData3, textureData4, textureData5, textureData6));
    }

    public void load(CubemapData cubemapData) {
        if (!cubemapData.isPrepared()) {
            cubemapData.prepare();
        }
        this.bind();
        Cubemap cubemap = this;
        cubemap.unsafeSetFilter(cubemap.minFilter, this.magFilter, true);
        Cubemap cubemap2 = this;
        cubemap2.unsafeSetWrap(cubemap2.uWrap, this.vWrap, true);
        Cubemap cubemap3 = this;
        cubemap3.unsafeSetAnisotropicFilter(cubemap3.anisotropicFilterLevel, true);
        cubemapData.consumeCubemapData();
        Gdx.g.glBindTexture(this.glTarget, 0);
    }

    public CubemapData getCubemapData() {
        return this.data;
    }

    @Override
    public boolean isManaged() {
        return this.data.isManaged();
    }

    @Override
    protected void reload() {
        if (!((GLTexture)this).isManaged()) {
            throw new GdxRuntimeException("Tried to reload an unmanaged Cubemap");
        }
        this.glHandle = Gdx.g.glGenTexture();
        Cubemap cubemap = this;
        cubemap.load(cubemap.data);
    }

    @Override
    public int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public int getHeight() {
        return this.data.getHeight();
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        this.delete();
        if (this.data.isManaged() && managedCubemaps.get(Gdx.a) != null) {
            ((Array)managedCubemaps.get(Gdx.a)).removeValue(this, true);
        }
    }

    private static void addManagedCubemap(Application application, Cubemap cubemap) {
        Array array = (Array)managedCubemaps.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(cubemap);
        managedCubemaps.put(application, array);
    }

    public static void clearAllCubemaps(Application application) {
        managedCubemaps.remove(application);
    }

    public static void invalidateAllCubemaps(Application object) {
        if ((object = (Array)managedCubemaps.get(object)) == null) {
            return;
        }
        if (assetManager == null) {
            for (int i2 = 0; i2 < ((Array)object).size; ++i2) {
                ((Cubemap)((Array)object).get(i2)).reload();
            }
            return;
        }
        assetManager.g();
        Array array = new Array((Array)object);
        for (Cubemap cubemap : array) {
            if (assetManager.e() == null) {
                cubemap.reload();
                continue;
            }
            int n2 = assetManager.h();
            assetManager.i();
            cubemap.glHandle = 0;
            d d2 = new d();
            new d().b = cubemap.getCubemapData();
            d2.c = cubemap.getMinFilter();
            d2.d = cubemap.getMagFilter();
            d2.e = cubemap.getUWrap();
            d2.f = cubemap.getVWrap();
            d2.a = cubemap;
            d2.loadedCallback = new a(n2);
            assetManager.d();
            cubemap.glHandle = Gdx.g.glGenTexture();
            assetManager.f();
        }
        ((Array)object).clear();
        ((Array)object).addAll(array);
    }

    public static void setAssetManager(com.badlogic.gdx.a.d d2) {
        assetManager = d2;
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed cubemap/app: { ");
        for (Application application : managedCubemaps.keySet()) {
            stringBuilder.append(((Array)Cubemap.managedCubemaps.get((Object)application)).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedCubemaps() {
        return ((Array)Cubemap.managedCubemaps.get((Object)Gdx.a)).size;
    }

    static {
        managedCubemaps = new HashMap();
    }
}

