/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers.desktop.support;

import com.badlogic.gdx.controllers.c;
import com.badlogic.gdx.controllers.desktop.support.CompositeControllerListener;
import com.badlogic.gdx.controllers.desktop.support.JamepadMapping;
import com.badlogic.gdx.controllers.e;
import com.badlogic.gdx.controllers.h;
import com.badlogic.gdx.controllers.i;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.Logger;
import com.badlogic.gdx.utils.TimeUtils;
import com.studiohartman.jamepad.ControllerAxis;
import com.studiohartman.jamepad.ControllerButton;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerUnpluggedException;
import java.util.UUID;

public class JamepadController
implements c {
    private static final IntMap CODE_TO_BUTTON = new IntMap(ControllerButton.values().length);
    private static final IntMap CODE_TO_AXIS = new IntMap(ControllerAxis.values().length);
    private static final Logger logger = new Logger(JamepadController.class.getSimpleName());
    private final CompositeControllerListener compositeControllerListener = new CompositeControllerListener();
    private final ControllerIndex controllerIndex;
    private final IntMap buttonState = new IntMap();
    private final IntMap axisState = new IntMap();
    private final String uuid;
    private boolean connected = true;
    private Boolean canVibrate = null;
    private long vibrationEndMs;
    private int axisCount = -1;
    private int maxButtonIndex = -1;

    public JamepadController(ControllerIndex controllerIndex) {
        this.controllerIndex = controllerIndex;
        this.uuid = UUID.randomUUID().toString();
        this.initializeState();
    }

    public boolean getButton(int n2) {
        try {
            ControllerButton controllerButton = this.toButton(n2);
            return controllerButton != null && this.controllerIndex.isButtonPressed(controllerButton);
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return false;
        }
    }

    public float getAxis(int n2) {
        try {
            ControllerAxis controllerAxis = this.toAxis(n2);
            if (controllerAxis == null) {
                return 0.0f;
            }
            return this.controllerIndex.getAxisState(controllerAxis);
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return 0.0f;
        }
    }

    @Override
    public String getName() {
        try {
            return this.controllerIndex.getName();
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return "Unknown";
        }
    }

    private void setDisconnected() {
        if (this.connected) {
            this.connected = false;
            logger.info("Failed querying controller at index: " + this.controllerIndex.getIndex());
            this.compositeControllerListener.disconnected(this);
        }
    }

    public void addListener(e e2) {
        this.compositeControllerListener.addListener(e2);
    }

    public void removeListener(e e2) {
        this.compositeControllerListener.removeListener(e2);
    }

    public boolean update() {
        this.updateButtonsState();
        this.updateAxisState();
        return this.connected;
    }

    private ControllerButton toButton(int n2) {
        return (ControllerButton)((Object)CODE_TO_BUTTON.get(n2));
    }

    private ControllerAxis toAxis(int n2) {
        return (ControllerAxis)((Object)CODE_TO_AXIS.get(n2));
    }

    private void updateAxisState() {
        ControllerAxis[] controllerAxisArray = ControllerAxis.values();
        int n2 = controllerAxisArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = controllerAxisArray[i2].ordinal();
            float f2 = this.getAxis(n3);
            if (f2 != ((Float)this.axisState.get(n3)).floatValue()) {
                if (logger.getLevel() == 3) {
                    logger.debug("Axis [" + n3 + " - " + (Object)((Object)this.toAxis(n3)) + "] moved [" + f2 + "]");
                }
                this.compositeControllerListener.axisMoved(this, n3, f2);
            }
            this.axisState.put(n3, Float.valueOf(f2));
        }
    }

    private void updateButtonsState() {
        ControllerButton[] controllerButtonArray = ControllerButton.values();
        int n2 = controllerButtonArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = controllerButtonArray[i2].ordinal();
            boolean bl2 = this.getButton(n3);
            if (bl2 != (Boolean)this.buttonState.get(n3)) {
                if (bl2) {
                    this.compositeControllerListener.buttonDown(this, n3);
                } else {
                    this.compositeControllerListener.buttonUp(this, n3);
                }
                if (logger.getLevel() == 3) {
                    logger.debug("Button [" + n3 + " - " + (Object)((Object)this.toButton(n3)) + "] is " + (bl2 ? "pressed" : "released"));
                }
            }
            this.buttonState.put(n3, bl2);
        }
    }

    private void initializeState() {
        for (ControllerAxis enum_ : ControllerAxis.values()) {
            this.axisState.put(enum_.ordinal(), Float.valueOf(0.0f));
        }
        for (Enum enum_ : ControllerButton.values()) {
            this.buttonState.put(enum_.ordinal(), Boolean.FALSE);
        }
    }

    public boolean canVibrate() {
        if (this.canVibrate == null) {
            try {
                this.canVibrate = this.controllerIndex.canVibrate();
            }
            catch (ControllerUnpluggedException controllerUnpluggedException) {
                this.setDisconnected();
            }
        }
        return this.canVibrate;
    }

    public boolean isVibrating() {
        return this.canVibrate() && TimeUtils.millis() < this.vibrationEndMs;
    }

    public void startVibration(int n2, float f2) {
        try {
            float f3 = f2;
            if (this.controllerIndex.doVibration(f3, f3, n2)) {
                this.vibrationEndMs = TimeUtils.millis() + (long)n2;
                this.canVibrate = Boolean.TRUE;
            }
            return;
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return;
        }
    }

    public void cancelVibration() {
        if (this.isVibrating()) {
            this.startVibration(0, 0.0f);
        }
    }

    public String getUniqueId() {
        return this.uuid;
    }

    public boolean supportsPlayerIndex() {
        return true;
    }

    public int getPlayerIndex() {
        try {
            return this.controllerIndex.getPlayerIndex();
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return -1;
        }
    }

    public void setPlayerIndex(int n2) {
        try {
            this.controllerIndex.setPlayerIndex(n2);
            return;
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return;
        }
    }

    public int getMinButtonIndex() {
        return 0;
    }

    public int getMaxButtonIndex() {
        if (this.maxButtonIndex >= 0) {
            return this.maxButtonIndex;
        }
        this.maxButtonIndex = JamepadController.CODE_TO_BUTTON.size - 1;
        try {
            while (this.maxButtonIndex > 0 && !this.controllerIndex.isButtonAvailable((ControllerButton)((Object)CODE_TO_BUTTON.get(this.maxButtonIndex)))) {
                --this.maxButtonIndex;
            }
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
        }
        return this.maxButtonIndex;
    }

    public int getAxisCount() {
        if (this.axisCount >= 0) {
            return this.axisCount;
        }
        this.axisCount = JamepadController.CODE_TO_AXIS.size;
        try {
            while (this.axisCount > 0 && !this.controllerIndex.isAxisAvailable((ControllerAxis)((Object)CODE_TO_AXIS.get(this.axisCount - 1)))) {
                --this.axisCount;
            }
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
        }
        return this.axisCount;
    }

    public boolean isConnected() {
        return this.connected && this.controllerIndex.isConnected();
    }

    public h getMapping() {
        return JamepadMapping.getInstance();
    }

    public i getPowerLevel() {
        try {
            switch (this.controllerIndex.getPowerLevel()) {
                case POWER_MAX: 
                case POWER_FULL: {
                    return i.e;
                }
                case POWER_MEDIUM: {
                    return i.d;
                }
                case POWER_LOW: {
                    return i.c;
                }
                case POWER_EMPTY: {
                    return i.b;
                }
                case POWER_WIRED: {
                    return i.f;
                }
            }
            return i.a;
        }
        catch (Throwable throwable) {
            return i.a;
        }
    }

    static {
        for (ControllerButton enum_ : ControllerButton.values()) {
            CODE_TO_BUTTON.put(enum_.ordinal(), (Object)enum_);
        }
        for (Enum enum_ : ControllerAxis.values()) {
            CODE_TO_AXIS.put(enum_.ordinal(), enum_);
        }
    }
}

